// Copyright 2022-2023 The sacloud/iaas-api-go Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// generated by 'github.com/sacloud/iaas-api-go/internal/tools/gen-api-fake-data'; DO NOT EDIT

package fake

import (
	"github.com/sacloud/iaas-api-go"
	"github.com/sacloud/iaas-api-go/types"
)

var initCDROM = map[string][]*iaas.CDROM{
	"is1a": {
		{
			ID:           types.ID(113202013362),
			Name:         "CentOS 7.9 (2009) 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-centos", "distro-ver-7.9", "os-linux"},
			DisplayOrder: 100100709011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201975683),
			Name:         "CentOS Stream 8 (20201203) 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-centos", "distro-ver-stream-8", "os-linux"},
			DisplayOrder: 100100803011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113400182749),
			Name:         "CentOS Stream 9 (20220126) 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-centos", "distro-ver-stream-9", "os-linux"},
			DisplayOrder: 100100926011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113300996838),
			Name:         "AlmaLinux 8.4 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-alma", "distro-ver-8.4", "os-linux"},
			DisplayOrder: 100200804011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113301160680),
			Name:         "Rocky Linux 8.4",
			Description:  "fake",
			Tags:         types.Tags{"@arch-64bit", "centos-alternative-8", "distro-rocky", "distro-ver-8.4", "os-linux"},
			DisplayOrder: 100201804011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113301723225),
			Name:         "MIRACLE LINUX 8.4",
			Description:  "fake",
			Tags:         types.Tags{"@arch-64bit", "centos-alternative-8", "current-stable", "distro-miracle", "distro-ver-8.4", "os-linux"},
			DisplayOrder: 100201805011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113302010996),
			Name:         "Rocky Linux 8.5",
			Description:  "fake",
			Tags:         types.Tags{"@arch-64bit", "centos-alternative-8", "current-stable", "distro-rocky", "distro-ver-8.5", "os-linux"},
			DisplayOrder: 100201805011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113201674155),
			Name:         "Fedora 33 Server Edition 64bit (DVD)",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-fedora", "distro-ver-33", "os-linux"},
			DisplayOrder: 100303300011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113302011156),
			Name:         "Fedora 35 Server Edition 64bit (DVD)",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-fedora", "distro-ver-35", "os-linux"},
			DisplayOrder: 100303500011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201587038),
			Name:         "Ubuntu Server 18.04.5 LTS 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-18.04.4", "os-unix"},
			DisplayOrder: 100401804511,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201374242),
			Name:         "Ubuntu Server 20.04.1 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-20.04.1", "os-linux"},
			DisplayOrder: 100402004111,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201647171),
			Name:         "Ubuntu Server 20.10 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-20.04", "os-linux"},
			DisplayOrder: 100402010011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113301858943),
			Name:         "Ubuntu Server 21.10 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-21.10", "os-linux"},
			DisplayOrder: 100402110011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113400751838),
			Name:         "Ubuntu Server 22.04 LTS 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-ubuntu", "distro-ver-22.04", "os-linux"},
			DisplayOrder: 100402204011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113300088556),
			Name:         "Debian GNU/Linux 10.7.0 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-debian", "distro-ver-10.7.0", "os-linux"},
			DisplayOrder: 100501070011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113301858189),
			Name:         "Debian GNU/Linux 11.1.0 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-debian", "distro-ver-11.1.0", "os-linux"},
			DisplayOrder: 100501101011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201673885),
			Name:         "FreeBSD 12.2-RELEASE 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-freebsd", "distro-ver-12.2", "os-unix"},
			DisplayOrder: 100601220011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113301809413),
			Name:         "FreeBSD 13.0-RELEASE 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-freebsd", "distro-ver-13.0", "os-unix"},
			DisplayOrder: 100601300011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113400063966),
			Name:         "ClearLinux 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-clear", "distro-ver-35000", "os-linux"},
			DisplayOrder: 100700350011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201634760),
			Name:         "NetBSD 9.1 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-netbsd", "distro-ver-9.1", "os-unix"},
			DisplayOrder: 100800901011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201060364),
			Name:         "openSUSE Leap 15.2 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-opensuse", "distro-ver-15.2", "os-linux"},
			DisplayOrder: 100901520011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113100878174),
			Name:         "openSUSE Tumbleweed Kubic (20190224) 64bit ",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-kubic", "distro-ver-20190527", "os-linux"},
			DisplayOrder: 100951000011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113300088577),
			Name:         "Arch Linux 2021.01.01",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-arch", "distro-ver-2021.01.01", "os-linux"},
			DisplayOrder: 200300211101,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201557427),
			Name:         "k3OS v0.11.1 amd64",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-k3os", "distro-ver-v0.11.1", "os-linux"},
			DisplayOrder: 200400011100,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113101107828),
			Name:         "Alpine Linux standard 3.10.0 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-alpine", "distro-ver-3.10.0", "os-linux"},
			DisplayOrder: 200400103001,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113200032925),
			Name:         "RancherOS v1.5.5 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-rancheros", "distro-ver-1.5.5", "os-linux"},
			DisplayOrder: 200400105500,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113300088607),
			Name:         "Fedora CoreOS x86_64 stable (ISO) 33.20201214.3.1 (stable)",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-fedora-coreos", "distro-ver-33.20201214.3.1", "os-linux"},
			DisplayOrder: 200401214300,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113400063953),
			Name:         "netboot.xyz",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-netboot", "distro-ver-2.0.54", "os-linux"},
			DisplayOrder: 200900205400,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113101379698),
			Name:         "OPNsense 19.7",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-opnsense", "distro-ver-19.7", "os-unix"},
			DisplayOrder: 300300232011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113101779366),
			Name:         "Microsoft SQL Server 2017 Express",
			Description:  "fake",
			Tags:         types.Tags{"app-windows", "arch-64bit", "os-windows"},
			DisplayOrder: 600100601011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201628110),
			Name:         "Microsoft SQL Server 2019 Express",
			Description:  "fake",
			Tags:         types.Tags{"app-windows", "arch-64bit", "current-stable", "os-windows"},
			DisplayOrder: 600100601011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201674310),
			Name:         "TrueNAS CORE 12.0-RELEASE 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-freenas", "distro-ver-12.0-RELEASE", "os-unix"},
			DisplayOrder: 3002001200111,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
	},
	"is1b": {
		{
			ID:           types.ID(113300112165),
			Name:         "CentOS 7.9 (2009) 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-centos", "distro-ver-7.9", "os-linux"},
			DisplayOrder: 100100709011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113202012897),
			Name:         "CentOS Stream 8 (20201203) 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-centos", "distro-ver-stream-8", "os-linux"},
			DisplayOrder: 100100803011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113400183553),
			Name:         "CentOS Stream 9 (20220126) 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-centos", "distro-ver-stream-9", "os-linux"},
			DisplayOrder: 100100926011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113301078431),
			Name:         "AlmaLinux 8.4 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-alma", "distro-ver-8.4", "os-linux"},
			DisplayOrder: 100200804011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113301185685),
			Name:         "Rocky Linux 8.4",
			Description:  "fake",
			Tags:         types.Tags{"@arch-64bit", "centos-alternative-8", "distro-rocky", "distro-ver-8.4", "os-linux"},
			DisplayOrder: 100201804011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113301801370),
			Name:         "MIRACLE LINUX 8.4",
			Description:  "fake",
			Tags:         types.Tags{"@arch-64bit", "centos-alternative-8", "current-stable", "distro-miracle", "distro-ver-8.4", "os-linux"},
			DisplayOrder: 100201805011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113302064437),
			Name:         "Rocky Linux 8.5",
			Description:  "fake",
			Tags:         types.Tags{"@arch-64bit", "centos-alternative-8", "current-stable", "distro-rocky", "distro-ver-8.5", "os-linux"},
			DisplayOrder: 100201805011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113201747788),
			Name:         "Fedora 33 Server Edition 64bit (DVD)",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-fedora", "distro-ver-33", "os-linux"},
			DisplayOrder: 100303300011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113302064460),
			Name:         "Fedora 35 Server Edition 64bit (DVD)",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-fedora", "distro-ver-35", "os-linux"},
			DisplayOrder: 100303500011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201595239),
			Name:         "Ubuntu Server 18.04.5 LTS 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-18.04.4", "os-unix"},
			DisplayOrder: 100401804511,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201392200),
			Name:         "Ubuntu Server 20.04.1 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-20.04.1", "os-linux"},
			DisplayOrder: 100402004111,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201668038),
			Name:         "Ubuntu Server 20.10 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-20.04", "os-linux"},
			DisplayOrder: 100402010011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113301924834),
			Name:         "Ubuntu Server 21.10 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-21.10", "os-linux"},
			DisplayOrder: 100402110011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113400984135),
			Name:         "Ubuntu Server 22.04 LTS 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-ubuntu", "distro-ver-22.04", "os-linux"},
			DisplayOrder: 100402204011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113300112186),
			Name:         "Debian GNU/Linux 10.7.0 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-debian", "distro-ver-10.7.0", "os-linux"},
			DisplayOrder: 100501070011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113301924741),
			Name:         "Debian GNU/Linux 11.1.0 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-debian", "distro-ver-11.1.0", "os-linux"},
			DisplayOrder: 100501101011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201747677),
			Name:         "FreeBSD 12.2-RELEASE 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-freebsd", "distro-ver-12.2", "os-unix"},
			DisplayOrder: 100601220011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113301823274),
			Name:         "FreeBSD 13.0-RELEASE 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-freebsd", "distro-ver-13.0", "os-unix"},
			DisplayOrder: 100601300011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113400183600),
			Name:         "ClearLinux 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-clear", "distro-ver-35000", "os-linux"},
			DisplayOrder: 100700350011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201668042),
			Name:         "NetBSD 9.1 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-netbsd", "distro-ver-9.1", "os-unix"},
			DisplayOrder: 100800901011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201078527),
			Name:         "openSUSE Leap 15.2 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-opensuse", "distro-ver-15.2", "os-linux"},
			DisplayOrder: 100901520011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113100878570),
			Name:         "openSUSE Tumbleweed Kubic (20190224) 64bit ",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-kubic", "distro-ver-20190527", "os-linux"},
			DisplayOrder: 100951000011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113300112158),
			Name:         "Arch Linux 2021.01.01",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-arch", "distro-ver-2021.01.01", "os-linux"},
			DisplayOrder: 200300211101,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201585049),
			Name:         "k3OS v0.11.1 amd64",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-k3os", "distro-ver-v0.11.1", "os-linux"},
			DisplayOrder: 200400011100,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113101108041),
			Name:         "Alpine Linux standard 3.10.0 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-alpine", "distro-ver-3.10.0", "os-linux"},
			DisplayOrder: 200400103001,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113200033183),
			Name:         "RancherOS v1.5.5 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-rancheros", "distro-ver-1.5.5", "os-linux"},
			DisplayOrder: 200400105500,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113300112180),
			Name:         "Fedora CoreOS x86_64 stable (ISO) 33.20201214.3.1 (stable)",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-fedora-coreos", "distro-ver-33.20201214.3.1", "os-linux"},
			DisplayOrder: 200401214300,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113400183614),
			Name:         "netboot.xyz",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-netboot", "distro-ver-2.0.54", "os-linux"},
			DisplayOrder: 200900205400,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113101369222),
			Name:         "OPNsense 19.7",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-opnsense", "distro-ver-19.7", "os-unix"},
			DisplayOrder: 300300232011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113101779367),
			Name:         "Microsoft SQL Server 2017 Express",
			Description:  "fake",
			Tags:         types.Tags{"app-windows", "arch-64bit", "os-windows"},
			DisplayOrder: 600100601011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201628111),
			Name:         "Microsoft SQL Server 2019 Express",
			Description:  "fake",
			Tags:         types.Tags{"app-windows", "arch-64bit", "current-stable", "os-windows"},
			DisplayOrder: 600100601011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201747829),
			Name:         "TrueNAS CORE 12.0-RELEASE 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-freenas", "distro-ver-12.0-RELEASE", "os-unix"},
			DisplayOrder: 3002001200111,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
	},
	"tk1a": {
		{
			ID:           types.ID(113300112163),
			Name:         "CentOS 7.9 (2009) 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-centos", "distro-ver-7.9", "os-linux"},
			DisplayOrder: 100100709011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113202012894),
			Name:         "CentOS Stream 8 (20201203) 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-centos", "distro-ver-stream-8", "os-linux"},
			DisplayOrder: 100100803011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113400183558),
			Name:         "CentOS Stream 9 (20220126) 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-centos", "distro-ver-stream-9", "os-linux"},
			DisplayOrder: 100100926011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113301078428),
			Name:         "AlmaLinux 8.4 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-alma", "distro-ver-8.4", "os-linux"},
			DisplayOrder: 100200804011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113301185683),
			Name:         "Rocky Linux 8.4",
			Description:  "fake",
			Tags:         types.Tags{"@arch-64bit", "centos-alternative-8", "distro-rocky", "distro-ver-8.4", "os-linux"},
			DisplayOrder: 100201804011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113301801376),
			Name:         "MIRACLE LINUX 8.4",
			Description:  "fake",
			Tags:         types.Tags{"@arch-64bit", "centos-alternative-8", "current-stable", "distro-miracle", "distro-ver-8.4", "os-linux"},
			DisplayOrder: 100201805011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113302064438),
			Name:         "Rocky Linux 8.5",
			Description:  "fake",
			Tags:         types.Tags{"@arch-64bit", "centos-alternative-8", "current-stable", "distro-rocky", "distro-ver-8.5", "os-linux"},
			DisplayOrder: 100201805011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113201747694),
			Name:         "Fedora 33 Server Edition 64bit (DVD)",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-fedora", "distro-ver-33", "os-linux"},
			DisplayOrder: 100303300011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113302064461),
			Name:         "Fedora 35 Server Edition 64bit (DVD)",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-fedora", "distro-ver-35", "os-linux"},
			DisplayOrder: 100303500011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201595209),
			Name:         "Ubuntu Server 18.04.5 LTS 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-18.04.4", "os-unix"},
			DisplayOrder: 100401804511,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201392196),
			Name:         "Ubuntu Server 20.04.1 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-20.04.1", "os-linux"},
			DisplayOrder: 100402004111,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201668039),
			Name:         "Ubuntu Server 20.10 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-20.04", "os-linux"},
			DisplayOrder: 100402010011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113301924835),
			Name:         "Ubuntu Server 21.10 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-21.10", "os-linux"},
			DisplayOrder: 100402110011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113400984138),
			Name:         "Ubuntu Server 22.04 LTS 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-ubuntu", "distro-ver-22.04", "os-linux"},
			DisplayOrder: 100402204011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113300112170),
			Name:         "Debian GNU/Linux 10.7.0 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-debian", "distro-ver-10.7.0", "os-linux"},
			DisplayOrder: 100501070011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113301924761),
			Name:         "Debian GNU/Linux 11.1.0 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-debian", "distro-ver-11.1.0", "os-linux"},
			DisplayOrder: 100501101011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201747674),
			Name:         "FreeBSD 12.2-RELEASE 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-freebsd", "distro-ver-12.2", "os-unix"},
			DisplayOrder: 100601220011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113301823275),
			Name:         "FreeBSD 13.0-RELEASE 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-freebsd", "distro-ver-13.0", "os-unix"},
			DisplayOrder: 100601300011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113400183601),
			Name:         "ClearLinux 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-clear", "distro-ver-35000", "os-linux"},
			DisplayOrder: 100700350011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201668043),
			Name:         "NetBSD 9.1 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-netbsd", "distro-ver-9.1", "os-unix"},
			DisplayOrder: 100800901011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201078526),
			Name:         "openSUSE Leap 15.2 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-opensuse", "distro-ver-15.2", "os-linux"},
			DisplayOrder: 100901520011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113100878569),
			Name:         "openSUSE Tumbleweed Kubic (20190224) 64bit ",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-kubic", "distro-ver-20190527", "os-linux"},
			DisplayOrder: 100951000011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113300112154),
			Name:         "Arch Linux 2021.01.01",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-arch", "distro-ver-2021.01.01", "os-linux"},
			DisplayOrder: 200300211101,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201585055),
			Name:         "k3OS v0.11.1 amd64",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-k3os", "distro-ver-v0.11.1", "os-linux"},
			DisplayOrder: 200400011100,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113101108040),
			Name:         "Alpine Linux standard 3.10.0 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-alpine", "distro-ver-3.10.0", "os-linux"},
			DisplayOrder: 200400103001,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113200033179),
			Name:         "RancherOS v1.5.5 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-rancheros", "distro-ver-1.5.5", "os-linux"},
			DisplayOrder: 200400105500,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201585070),
			Name:         "Fedora CoreOS x86_64 stable (ISO) 32.20200923.3.0 (stable)",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-fedora-coreos", "distro-ver-20200923.3.0", "os-linux"},
			DisplayOrder: 200400923300,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113300112176),
			Name:         "Fedora CoreOS x86_64 stable (ISO) 33.20201214.3.1 (stable)",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-fedora-coreos", "distro-ver-33.20201214.3.1", "os-linux"},
			DisplayOrder: 200401214300,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113400183618),
			Name:         "netboot.xyz",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-netboot", "distro-ver-2.0.54", "os-linux"},
			DisplayOrder: 200900205400,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113101379662),
			Name:         "OPNsense 19.7",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-opnsense", "distro-ver-19.7", "os-unix"},
			DisplayOrder: 300300232011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113101773515),
			Name:         "Microsoft SQL Server 2017 Express",
			Description:  "fake",
			Tags:         types.Tags{"app-windows", "arch-64bit", "os-windows"},
			DisplayOrder: 600100601011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201625643),
			Name:         "Microsoft SQL Server 2019 Express",
			Description:  "fake",
			Tags:         types.Tags{"app-windows", "arch-64bit", "current-stable", "os-windows"},
			DisplayOrder: 600100601011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201747825),
			Name:         "TrueNAS CORE 12.0-RELEASE 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-freenas", "distro-ver-12.0-RELEASE", "os-unix"},
			DisplayOrder: 3002001200111,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
	},
	"tk1b": {
		{
			ID:           types.ID(113300112164),
			Name:         "CentOS 7.9 (2009) 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-centos", "distro-ver-7.9", "os-linux"},
			DisplayOrder: 100100709011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113202012896),
			Name:         "CentOS Stream 8 (20201203) 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-centos", "distro-ver-stream-8", "os-linux"},
			DisplayOrder: 100100803011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113400183559),
			Name:         "CentOS Stream 9 (20220126) 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-centos", "distro-ver-stream-9", "os-linux"},
			DisplayOrder: 100100926011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113301078430),
			Name:         "AlmaLinux 8.4 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-alma", "distro-ver-8.4", "os-linux"},
			DisplayOrder: 100200804011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113301185684),
			Name:         "Rocky Linux 8.4",
			Description:  "fake",
			Tags:         types.Tags{"@arch-64bit", "centos-alternative-8", "distro-rocky", "distro-ver-8.4", "os-linux"},
			DisplayOrder: 100201804011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113301801378),
			Name:         "MIRACLE LINUX 8.4",
			Description:  "fake",
			Tags:         types.Tags{"@arch-64bit", "centos-alternative-8", "current-stable", "distro-miracle", "distro-ver-8.4", "os-linux"},
			DisplayOrder: 100201805011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113302064439),
			Name:         "Rocky Linux 8.5",
			Description:  "fake",
			Tags:         types.Tags{"@arch-64bit", "centos-alternative-8", "current-stable", "distro-rocky", "distro-ver-8.5", "os-linux"},
			DisplayOrder: 100201805011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113201747785),
			Name:         "Fedora 33 Server Edition 64bit (DVD)",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-fedora", "distro-ver-33", "os-linux"},
			DisplayOrder: 100303300011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113302064465),
			Name:         "Fedora 35 Server Edition 64bit (DVD)",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-fedora", "distro-ver-35", "os-linux"},
			DisplayOrder: 100303500011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201595211),
			Name:         "Ubuntu Server 18.04.5 LTS 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-18.04.4", "os-unix"},
			DisplayOrder: 100401804511,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201392198),
			Name:         "Ubuntu Server 20.04.1 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-20.04.1", "os-linux"},
			DisplayOrder: 100402004111,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201668040),
			Name:         "Ubuntu Server 20.10 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-20.04", "os-linux"},
			DisplayOrder: 100402010011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113301924836),
			Name:         "Ubuntu Server 21.10 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-21.10", "os-linux"},
			DisplayOrder: 100402110011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113400984142),
			Name:         "Ubuntu Server 22.04 LTS 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-ubuntu", "distro-ver-22.04", "os-linux"},
			DisplayOrder: 100402204011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113300112243),
			Name:         "Debian GNU/Linux 10.7.0 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-debian", "distro-ver-10.7.0", "os-linux"},
			DisplayOrder: 100501070011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113301924762),
			Name:         "Debian GNU/Linux 11.1.0 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-debian", "distro-ver-11.1.0", "os-linux"},
			DisplayOrder: 100501101011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201747676),
			Name:         "FreeBSD 12.2-RELEASE 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-freebsd", "distro-ver-12.2", "os-unix"},
			DisplayOrder: 100601220011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113301823276),
			Name:         "FreeBSD 13.0-RELEASE 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-freebsd", "distro-ver-13.0", "os-unix"},
			DisplayOrder: 100601300011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113400183602),
			Name:         "ClearLinux 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-clear", "distro-ver-35000", "os-linux"},
			DisplayOrder: 100700350011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201668044),
			Name:         "NetBSD 9.1 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-netbsd", "distro-ver-9.1", "os-unix"},
			DisplayOrder: 100800901011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201230425),
			Name:         "openSUSE Leap 15.2 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-opensuse", "distro-ver-15.2", "os-linux"},
			DisplayOrder: 100901520011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201230650),
			Name:         "openSUSE Tumbleweed Kubic (20190224) 64bit ",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-kubic", "distro-ver-20190527", "os-linux"},
			DisplayOrder: 100951000011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113300112157),
			Name:         "Arch Linux 2021.01.01",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-arch", "distro-ver-2021.01.01", "os-linux"},
			DisplayOrder: 200300211101,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201585058),
			Name:         "k3OS v0.11.1 amd64",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-k3os", "distro-ver-v0.11.1", "os-linux"},
			DisplayOrder: 200400011100,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201230649),
			Name:         "Alpine Linux standard 3.10.0 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-alpine", "distro-ver-3.10.0", "os-linux"},
			DisplayOrder: 200400103001,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201230618),
			Name:         "RancherOS v1.5.5 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-rancheros", "distro-ver-1.5.5", "os-linux"},
			DisplayOrder: 200400105500,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113300112179),
			Name:         "Fedora CoreOS x86_64 stable (ISO) 33.20201214.3.1 (stable)",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-fedora-coreos", "distro-ver-33.20201214.3.1", "os-linux"},
			DisplayOrder: 200401214300,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113400183619),
			Name:         "netboot.xyz",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-netboot", "distro-ver-2.0.54", "os-linux"},
			DisplayOrder: 200900205400,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201230641),
			Name:         "OPNsense 19.7",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-opnsense", "distro-ver-19.7", "os-unix"},
			DisplayOrder: 300300232011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201230632),
			Name:         "Microsoft SQL Server 2017 Express",
			Description:  "fake",
			Tags:         types.Tags{"app-windows", "arch-64bit", "os-windows"},
			DisplayOrder: 600100601011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201628105),
			Name:         "Microsoft SQL Server 2019 Express",
			Description:  "fake",
			Tags:         types.Tags{"app-windows", "arch-64bit", "current-stable", "os-windows"},
			DisplayOrder: 600100601011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201747826),
			Name:         "TrueNAS CORE 12.0-RELEASE 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-freenas", "distro-ver-12.0-RELEASE", "os-unix"},
			DisplayOrder: 3002001200111,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
	},
	"tk1v": {
		{
			ID:           types.ID(113300112166),
			Name:         "CentOS 7.9 (2009) 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-centos", "distro-ver-7.9", "os-linux"},
			DisplayOrder: 100100709011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113202012898),
			Name:         "CentOS Stream 8 (20201203) 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-centos", "distro-ver-stream-8", "os-linux"},
			DisplayOrder: 100100803011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113400183582),
			Name:         "CentOS Stream 9 (20220126) 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-centos", "distro-ver-stream-9", "os-linux"},
			DisplayOrder: 100100926011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113001461329),
			Name:         "Scientific Linux 6.10 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-sl", "distro-ver-6.10", "os-linux"},
			DisplayOrder: 100200610011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113201747687),
			Name:         "Scientific Linux 7.9 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-sl", "distro-ver-7.9", "os-linux"},
			DisplayOrder: 100200709011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113301078432),
			Name:         "AlmaLinux 8.4 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-alma", "distro-ver-8.4", "os-linux"},
			DisplayOrder: 100200804011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113301185686),
			Name:         "Rocky Linux 8.4",
			Description:  "fake",
			Tags:         types.Tags{"@arch-64bit", "centos-alternative-8", "distro-rocky", "distro-ver-8.4", "os-linux"},
			DisplayOrder: 100201804011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113301801399),
			Name:         "MIRACLE LINUX 8.4",
			Description:  "fake",
			Tags:         types.Tags{"@arch-64bit", "centos-alternative-8", "current-stable", "distro-miracle", "distro-ver-8.4", "os-linux"},
			DisplayOrder: 100201805011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113302064440),
			Name:         "Rocky Linux 8.5",
			Description:  "fake",
			Tags:         types.Tags{"@arch-64bit", "centos-alternative-8", "current-stable", "distro-rocky", "distro-ver-8.5", "os-linux"},
			DisplayOrder: 100201805011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       10240,
		},
		{
			ID:           types.ID(113201747793),
			Name:         "Fedora 33 Server Edition 64bit (DVD)",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-fedora", "distro-ver-33", "os-linux"},
			DisplayOrder: 100303300011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113302064468),
			Name:         "Fedora 35 Server Edition 64bit (DVD)",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-fedora", "distro-ver-35", "os-linux"},
			DisplayOrder: 100303500011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113100422048),
			Name:         "Ubuntu Server 16.04.6 LTS 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-16.04.6", "os-unix"},
			DisplayOrder: 100401604611,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201595212),
			Name:         "Ubuntu Server 18.04.5 LTS 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-18.04.4", "os-unix"},
			DisplayOrder: 100401804511,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201392199),
			Name:         "Ubuntu Server 20.04.1 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-20.04.1", "os-linux"},
			DisplayOrder: 100402004111,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201668041),
			Name:         "Ubuntu Server 20.10 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-20.04", "os-linux"},
			DisplayOrder: 100402010011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113301924837),
			Name:         "Ubuntu Server 21.10 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-ubuntu", "distro-ver-21.10", "os-linux"},
			DisplayOrder: 100402110011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113400984143),
			Name:         "Ubuntu Server 22.04 LTS 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-ubuntu", "distro-ver-22.04", "os-linux"},
			DisplayOrder: 100402204011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113001458164),
			Name:         "Debian GNU/Linux 8.11.0 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-debian", "distro-ver-8.11.0", "os-linux"},
			DisplayOrder: 100500811011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113101593271),
			Name:         "Debian GNU/Linux 9.11.0 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-debian", "distro-ver-9.11.0", "os-linux"},
			DisplayOrder: 100500911011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113300112187),
			Name:         "Debian GNU/Linux 10.7.0 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-debian", "distro-ver-10.7.0", "os-linux"},
			DisplayOrder: 100501070011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113301924763),
			Name:         "Debian GNU/Linux 11.1.0 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-debian", "distro-ver-11.1.0", "os-linux"},
			DisplayOrder: 100501101011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201747678),
			Name:         "FreeBSD 12.2-RELEASE 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-freebsd", "distro-ver-12.2", "os-unix"},
			DisplayOrder: 100601220011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113301823278),
			Name:         "FreeBSD 13.0-RELEASE 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-freebsd", "distro-ver-13.0", "os-unix"},
			DisplayOrder: 100601300011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113400183607),
			Name:         "ClearLinux 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-clear", "distro-ver-35000", "os-linux"},
			DisplayOrder: 100700350011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201668045),
			Name:         "NetBSD 9.1 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-netbsd", "distro-ver-9.1", "os-unix"},
			DisplayOrder: 100800901011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201078528),
			Name:         "openSUSE Leap 15.2 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-opensuse", "distro-ver-15.2", "os-linux"},
			DisplayOrder: 100901520011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113100878586),
			Name:         "openSUSE Tumbleweed Kubic (20190224) 64bit ",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-kubic", "distro-ver-20190527", "os-linux"},
			DisplayOrder: 100951000011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113300112159),
			Name:         "Arch Linux 2021.01.01",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-arch", "distro-ver-2021.01.01", "os-linux"},
			DisplayOrder: 200300211101,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201585053),
			Name:         "k3OS v0.11.1 amd64",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-k3os", "distro-ver-v0.11.1", "os-linux"},
			DisplayOrder: 200400011100,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113101108042),
			Name:         "Alpine Linux standard 3.10.0 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-alpine", "distro-ver-3.10.0", "os-linux"},
			DisplayOrder: 200400103001,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113101593144),
			Name:         "RancherOS v1.5.4 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "distro-rancheros", "distro-ver-1.5.4", "os-linux"},
			DisplayOrder: 200400105400,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113200033181),
			Name:         "RancherOS v1.5.5 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-rancheros", "distro-ver-1.5.5", "os-linux"},
			DisplayOrder: 200400105500,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113300112182),
			Name:         "Fedora CoreOS x86_64 stable (ISO) 33.20201214.3.1 (stable)",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-fedora-coreos", "distro-ver-33.20201214.3.1", "os-linux"},
			DisplayOrder: 200401214300,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113400183621),
			Name:         "netboot.xyz",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-netboot", "distro-ver-2.0.54", "os-linux"},
			DisplayOrder: 200900205400,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113101379664),
			Name:         "OPNsense 19.7",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-opnsense", "distro-ver-19.7", "os-unix"},
			DisplayOrder: 300300232011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113101779369),
			Name:         "Microsoft SQL Server 2017 Express",
			Description:  "fake",
			Tags:         types.Tags{"app-windows", "arch-64bit", "os-windows"},
			DisplayOrder: 600100601011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201664160),
			Name:         "Microsoft SQL Server 2019 Express",
			Description:  "fake",
			Tags:         types.Tags{"app-windows", "arch-64bit", "current-stable", "os-windows"},
			DisplayOrder: 600100601011,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
		{
			ID:           types.ID(113201747828),
			Name:         "TrueNAS CORE 12.0-RELEASE 64bit",
			Description:  "fake",
			Tags:         types.Tags{"arch-64bit", "current-stable", "distro-freenas", "distro-ver-12.0-RELEASE", "os-unix"},
			DisplayOrder: 3002001200111,
			Availability: types.EAvailability("available"),
			Scope:        types.EScope("shared"),
			SizeMB:       5120,
		},
	},
}
