/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.commonjs.module.provider;

import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.commonjs.module.ModuleScript;
import org.mozilla.javascript.commonjs.module.ModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.provider.ModuleSource;
import org.mozilla.javascript.commonjs.module.provider.ModuleSourceProvider;

public abstract class CachingModuleScriptProviderBase
implements ModuleScriptProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int loadConcurrencyLevel;
    private static final int loadLockShift;
    private static final int loadLockMask;
    private static final int loadLockCount;
    private final Object[] loadLocks = new Object[loadLockCount];
    private final ModuleSourceProvider moduleSourceProvider;

    protected CachingModuleScriptProviderBase(ModuleSourceProvider moduleSourceProvider) {
        for (int i = 0; i < this.loadLocks.length; ++i) {
            this.loadLocks[i] = new Object();
        }
        this.moduleSourceProvider = moduleSourceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public ModuleScript getModuleScript(Context context, String string, URI uRI, URI uRI2, Scriptable scriptable) throws Exception {
        Reader reader;
        ModuleSource moduleSource;
        block8: {
            ModuleScript moduleScript;
            CachedModuleScript cachedModuleScript = this.getLoadedModule(string);
            Object object = CachingModuleScriptProviderBase.getValidator(cachedModuleScript);
            ModuleSource moduleSource2 = moduleSource = uRI == null ? this.moduleSourceProvider.loadSource(string, scriptable, object) : this.moduleSourceProvider.loadSource(uRI, uRI2, object);
            if (moduleSource == ModuleSourceProvider.NOT_MODIFIED) {
                return cachedModuleScript.getModule();
            }
            if (moduleSource == null) {
                return null;
            }
            reader = moduleSource.getReader();
            try {
                int n = string.hashCode();
                Object object2 = this.loadLocks[n >>> loadLockShift & loadLockMask];
                // MONITORENTER : object2
                CachedModuleScript cachedModuleScript2 = this.getLoadedModule(string);
                if (cachedModuleScript2 == null || CachingModuleScriptProviderBase.equal(object, CachingModuleScriptProviderBase.getValidator(cachedModuleScript2))) break block8;
                moduleScript = cachedModuleScript2.getModule();
                // MONITOREXIT : object2
            }
            catch (Throwable throwable) {
                reader.close();
                throw throwable;
            }
            reader.close();
            return moduleScript;
        }
        URI uRI3 = moduleSource.getUri();
        ModuleScript moduleScript = new ModuleScript(context.compileReader(reader, uRI3.toString(), 1, moduleSource.getSecurityDomain()), uRI3, moduleSource.getBase());
        this.putLoadedModule(string, moduleScript, moduleSource.getValidator());
        ModuleScript moduleScript2 = moduleScript;
        // MONITOREXIT : object2
        reader.close();
        return moduleScript2;
    }

    protected abstract void putLoadedModule(String var1, ModuleScript var2, Object var3);

    protected abstract CachedModuleScript getLoadedModule(String var1);

    private static Object getValidator(CachedModuleScript cachedModuleScript) {
        return cachedModuleScript == null ? null : cachedModuleScript.getValidator();
    }

    private static boolean equal(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    protected static int getConcurrencyLevel() {
        return loadLockCount;
    }

    static {
        int n;
        loadConcurrencyLevel = Runtime.getRuntime().availableProcessors() * 8;
        int n2 = 0;
        for (n = 1; n < loadConcurrencyLevel; n <<= 1) {
            ++n2;
        }
        loadLockShift = 32 - n2;
        loadLockMask = n - 1;
        loadLockCount = n;
    }

    public static class CachedModuleScript {
        private final ModuleScript moduleScript;
        private final Object validator;

        public CachedModuleScript(ModuleScript moduleScript, Object object) {
            this.moduleScript = moduleScript;
            this.validator = object;
        }

        ModuleScript getModule() {
            return this.moduleScript;
        }

        Object getValidator() {
            return this.validator;
        }
    }
}

