/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.ProtocolFamily;
import jdk.Exported;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.ResourceIdImpl;

@Exported(value=false)
@InstrumentationTarget(value="sun.nio.ch.Net")
public class NetRMHooks {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    static FileDescriptor socket(ProtocolFamily protocolFamily, boolean bl) throws IOException {
        FileDescriptor fileDescriptor = NetRMHooks.socket(protocolFamily, bl);
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(fileDescriptor);
        ResourceRequest resourceRequest = ApproverGroup.FILEDESCRIPTOR_OPEN_GROUP.getApprover(fileDescriptor);
        long l = 0L;
        long l2 = 0L;
        try {
            try {
                l = resourceRequest.request(1L, resourceIdImpl);
                if (l < 1L) {
                    throw new IOException("Resource limited: too many open file descriptors");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                throw new IOException("Resource limited: too many open file descriptors", resourceRequestDeniedException);
            }
            l2 = 1L;
        }
        finally {
            resourceRequest.request(-(l - l2), resourceIdImpl);
        }
        return fileDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    static FileDescriptor serverSocket(boolean bl) {
        FileDescriptor fileDescriptor = NetRMHooks.serverSocket(bl);
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(fileDescriptor);
        ResourceRequest resourceRequest = ApproverGroup.FILEDESCRIPTOR_OPEN_GROUP.getApprover(fileDescriptor);
        long l = 0L;
        long l2 = 0L;
        try {
            l = resourceRequest.request(1L, resourceIdImpl);
            if (l < 1L) {
                throw new ResourceRequestDeniedException("Resource limited: too many open file descriptors");
            }
            l2 = 1L;
        }
        finally {
            resourceRequest.request(-(l - l2), resourceIdImpl);
        }
        return fileDescriptor;
    }
}

