/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.yaml.internal.items;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.common.registry.AbstractProvider;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.model.yaml.YamlModelUtils;
import org.openhab.core.model.yaml.internal.util.YamlElementUtils;
import org.openhab.core.thing.ChannelUID;
import org.openhab.core.thing.link.ItemChannelLink;
import org.openhab.core.thing.link.ItemChannelLinkProvider;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={ItemChannelLinkProvider.class, YamlChannelLinkProvider.class})
public class YamlChannelLinkProvider
extends AbstractProvider<ItemChannelLink>
implements ItemChannelLinkProvider {
    private final Logger logger = LoggerFactory.getLogger(YamlChannelLinkProvider.class);
    private Map<String, Map<String, Map<ChannelUID, ItemChannelLink>>> itemsChannelLinksMap = new ConcurrentHashMap<String, Map<String, Map<ChannelUID, ItemChannelLink>>>();

    public Collection<ItemChannelLink> getAll() {
        return this.itemsChannelLinksMap.keySet().stream().filter(name -> !YamlModelUtils.isIsolatedModel(name)).map(name -> this.itemsChannelLinksMap.getOrDefault(name, Map.of())).flatMap(m -> m.values().stream()).flatMap(m -> m.values().stream()).toList();
    }

    public Collection<ItemChannelLink> getAllFromModel(String modelName) {
        return this.itemsChannelLinksMap.getOrDefault(modelName, Map.of()).values().stream().flatMap(m -> m.values().stream()).toList();
    }

    public void updateItemChannelLinks(String modelName, String itemName, Map<String, Configuration> channelLinks) {
        Map channelLinksMap = Objects.requireNonNull(this.itemsChannelLinksMap.computeIfAbsent(modelName, k -> new ConcurrentHashMap()));
        Map links = Objects.requireNonNull(channelLinksMap.computeIfAbsent(itemName, k -> new ConcurrentHashMap(2)));
        HashSet linksToBeRemoved = new HashSet(links.keySet());
        for (Map.Entry<String, Configuration> entry : channelLinks.entrySet()) {
            String profile;
            Object object;
            ChannelUID channelUIDObject;
            String channelUID = entry.getKey();
            Configuration configuration = entry.getValue();
            try {
                channelUIDObject = new ChannelUID(channelUID);
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("Invalid channel UID '{}' in channel link for item '{}'!", new Object[]{channelUID, itemName, e});
                continue;
            }
            if (configuration.containsKey("profile") && (object = configuration.get("profile")) instanceof String && (profile = (String)object).indexOf(":") == -1) {
                String fullProfile = "system:" + profile;
                configuration.put("profile", (Object)fullProfile);
                this.logger.info("Profile '{}' for channel '{}' is missing the scope prefix, assuming the correct UID is '{}'. Check your configuration.", new Object[]{profile, channelUID, fullProfile});
            }
            ItemChannelLink itemChannelLink = new ItemChannelLink(itemName, channelUIDObject, configuration);
            linksToBeRemoved.remove(channelUIDObject);
            ItemChannelLink oldLink = (ItemChannelLink)links.get(channelUIDObject);
            if (oldLink == null) {
                links.put(channelUIDObject, itemChannelLink);
                this.logger.debug("model {} added channel link {}", (Object)modelName, (Object)itemChannelLink.getUID());
                if (YamlModelUtils.isIsolatedModel(modelName)) continue;
                this.notifyListenersAboutAddedElement(itemChannelLink);
                continue;
            }
            if (YamlElementUtils.equalsConfig(configuration.getProperties(), oldLink.getConfiguration().getProperties())) continue;
            links.put(channelUIDObject, itemChannelLink);
            this.logger.debug("model {} updated channel link {}", (Object)modelName, (Object)itemChannelLink.getUID());
            if (YamlModelUtils.isIsolatedModel(modelName)) continue;
            this.notifyListenersAboutUpdatedElement(oldLink, itemChannelLink);
        }
        linksToBeRemoved.forEach(uid -> {
            ItemChannelLink link = (ItemChannelLink)links.remove(uid);
            if (link != null) {
                this.logger.debug("model {} removed channel link {}", (Object)modelName, (Object)link.getUID());
                if (!YamlModelUtils.isIsolatedModel(modelName)) {
                    this.notifyListenersAboutRemovedElement(link);
                }
            }
        });
        if (links.isEmpty()) {
            channelLinksMap.remove(itemName);
        }
        if (channelLinksMap.isEmpty()) {
            this.itemsChannelLinksMap.remove(modelName);
        }
    }
}

