/**************************************************************************
 **SA Network Connection Profiler [sancp] - A TCP/IP statistical/collection tool
 * ************************************************************************
 * * Copyright (C) 2003 John Curry <john.curry@metre.net>
 * *
 * * This program is distributed under the terms of version 1.0 of the
 * * Q Public License.  See LICENSE.QPL for further details.
 * *
 * * This program is distributed in the hope that it will be useful,
 * * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * *
 * ***********************************************************************/



#ifndef __MEMORYPOOL_H__
#define __MEMORYPOOL_H__

//#define NULL 0
#define BYTE unsigned char
#define CRITICAL_SECTION bool
#include <stdio.h>
//void InitializeCriticalSection( CRITICAL_SECTION m_critsec ) { return; }
//void DeleteCriticalSection( CRITICAL_SECTION m_critsec ) { return; }
//void EnterCriticalSection( CRITICAL_SECTION m_critsec ) { return; }
//void LeaveCriticalSection( CRITICAL_SECTION m_critsec ) { return; }

//unsigned int min (unsigned int x,unsigned int y){ return (x>y)?x:y; }

class CBuffer;

class CBufferCollection
{
	CBuffer*	m_pHead;
	CBuffer*	m_pTail;
	unsigned int		m_dwSize;
public:
	bool equals(CBuffer*);
	void update(CBuffer*);
	
	
	CBufferCollection();
	~CBufferCollection();
	void		AddHead(CBuffer* pBuffer);
	CBuffer*	RemoveTail();
	void		Remove(CBuffer*  pBuffer);
	CBuffer*	Head();
	CBuffer*	Tail();
	unsigned int		Count();
	void		Clear();
};


class CMemoryPool
{
protected:
	
	CBufferCollection	m_usedPool;
	CBufferCollection	m_freePool;
	unsigned int				m_dwBufferSize;
	unsigned int				m_dwCount;
	bool				m_bAutoGrow;

	CRITICAL_SECTION	m_critsec;

	//inline void Enter() { EnterCriticalSection(&m_critsec); }
	//inline void Leave() { LeaveCriticalSection(&m_critsec); }
	//inline void Enter() { printf("Enter\n"); }
	//inline void Leave() { printf("Leave\n"); }
	inline void Enter() { return; }
	inline void Leave() { return; }

public:

	CMemoryPool(bool bAutoGrow = false, unsigned int dwBufferSize = 4096, unsigned int dwInitialCount = 1099);
	~CMemoryPool();
	CBuffer* Alloc();
	void Free(CBuffer* pBuffer);
	unsigned int GetTotalBuffers();
	unsigned int GetUsedBuffers();
	unsigned int GetFreeBuffers();
	unsigned int GetBufferSize();
	bool Resize(unsigned long dwNewCount);
	bool ResizeD(long iCountDiff);
	bool IsAutoGrow();
};

class CBuffer
{
private:
	CBuffer(CMemoryPool* pPool);
	~CBuffer();

	CMemoryPool*	m_pPool;
	BYTE*			m_pBuffer;
	unsigned int			m_dwSize;

	CBuffer*		m_pNext;
	CBuffer*		m_pPrev;
public:
	friend class CMemoryPool;
	friend class CBufferCollection;

	void Free();
	BYTE* GetBuffer();


	unsigned int GetBufferSize();
	unsigned int GetSizeUsed();
	unsigned int SetSizeUsed(unsigned int dwSizeUsed);
};


#endif	//__MEMORYPOOL_H__


