// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.23.0
// 	protoc        v4.24.4
// source: envoy/extensions/filters/http/rate_limit_quota/v3/rate_limit_quota.proto

package rate_limit_quotav3

import (
	v3 "github.com/cilium/proxy/go/envoy/config/core/v3"
	v32 "github.com/cilium/proxy/go/envoy/type/v3"
	_ "github.com/cncf/xds/go/udpa/annotations"
	_ "github.com/cncf/xds/go/xds/annotations/v3"
	v31 "github.com/cncf/xds/go/xds/type/matcher/v3"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	proto "github.com/golang/protobuf/proto"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Configures the Rate Limit Quota filter.
//
// Can be overridden in the per-route and per-host configurations.
// The more specific definition completely overrides the less specific definition.
// [#next-free-field: 7]
type RateLimitQuotaFilterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configures the gRPC Rate Limit Quota Service (RLQS) RateLimitQuotaService.
	RlqsServer *v3.GrpcService `protobuf:"bytes,1,opt,name=rlqs_server,json=rlqsServer,proto3" json:"rlqs_server,omitempty"`
	// The application domain to use when calling the service. This enables sharing the quota
	// server between different applications without fear of overlap.
	// E.g., "envoy".
	Domain string `protobuf:"bytes,2,opt,name=domain,proto3" json:"domain,omitempty"`
	// The match tree to use for grouping incoming requests into buckets.
	//
	// Example:
	//
	// .. validated-code-block:: yaml
	//
	//	:type-name: xds.type.matcher.v3.Matcher
	//
	//	matcher_list:
	//	  matchers:
	//	  # Assign requests with header['env'] set to 'staging' to the bucket { name: 'staging' }
	//	  - predicate:
	//	      single_predicate:
	//	        input:
	//	          typed_config:
	//	            '@type': type.googleapis.com/envoy.type.matcher.v3.HttpRequestHeaderMatchInput
	//	            header_name: env
	//	        value_match:
	//	          exact: staging
	//	    on_match:
	//	      action:
	//	        typed_config:
	//	          '@type': type.googleapis.com/envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings
	//	          bucket_id_builder:
	//	            bucket_id_builder:
	//	              name:
	//	                string_value: staging
	//
	//	  # Assign requests with header['user_group'] set to 'admin' to the bucket { acl: 'admin_users' }
	//	  - predicate:
	//	      single_predicate:
	//	        input:
	//	          typed_config:
	//	            '@type': type.googleapis.com/xds.type.matcher.v3.HttpAttributesCelMatchInput
	//	        custom_match:
	//	          typed_config:
	//	            '@type': type.googleapis.com/xds.type.matcher.v3.CelMatcher
	//	            expr_match:
	//	              # Shortened for illustration purposes. Here should be parsed CEL expression:
	//	              # request.headers['user_group'] == 'admin'
	//	              parsed_expr: {}
	//	    on_match:
	//	      action:
	//	        typed_config:
	//	          '@type': type.googleapis.com/envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings
	//	          bucket_id_builder:
	//	            bucket_id_builder:
	//	              acl:
	//	                string_value: admin_users
	//
	//	# Catch-all clause for the requests not matched by any of the matchers.
	//	# In this example, deny all requests.
	//	on_no_match:
	//	  action:
	//	    typed_config:
	//	      '@type': type.googleapis.com/envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings
	//	      no_assignment_behavior:
	//	        fallback_rate_limit:
	//	          blanket_rule: DENY_ALL
	//
	// .. attention::
	//
	//	The first matched group wins. Once the request is matched into a bucket, matcher
	//	evaluation ends.
	//
	// Use “on_no_match“ field to assign the catch-all bucket. If a request is not matched
	// into any bucket, and there's no  “on_no_match“ field configured, the request will be
	// ALLOWED by default. It will NOT be reported to the RLQS server.
	//
	// Refer to :ref:`Unified Matcher API <envoy_v3_api_msg_.xds.type.matcher.v3.Matcher>`
	// documentation for more information on the matcher trees.
	BucketMatchers *v31.Matcher `protobuf:"bytes,3,opt,name=bucket_matchers,json=bucketMatchers,proto3" json:"bucket_matchers,omitempty"`
	// If set, this will enable -- but not necessarily enforce -- the rate limit for the given
	// fraction of requests.
	//
	// Defaults to 100% of requests.
	FilterEnabled *v3.RuntimeFractionalPercent `protobuf:"bytes,4,opt,name=filter_enabled,json=filterEnabled,proto3" json:"filter_enabled,omitempty"`
	// If set, this will enforce the rate limit decisions for the given fraction of requests.
	// For requests that are not enforced the filter will still obtain the quota and include it
	// in the load computation, however the request will always be allowed regardless of the outcome
	// of quota application. This allows validation or testing of the rate limiting service
	// infrastructure without disrupting existing traffic.
	//
	// Note: this only applies to the fraction of enabled requests.
	//
	// Defaults to 100% of requests.
	FilterEnforced *v3.RuntimeFractionalPercent `protobuf:"bytes,5,opt,name=filter_enforced,json=filterEnforced,proto3" json:"filter_enforced,omitempty"`
	// Specifies a list of HTTP headers that should be added to each request that
	// has been rate limited and is also forwarded upstream. This can only occur when the
	// filter is enabled but not enforced.
	RequestHeadersToAddWhenNotEnforced []*v3.HeaderValueOption `protobuf:"bytes,6,rep,name=request_headers_to_add_when_not_enforced,json=requestHeadersToAddWhenNotEnforced,proto3" json:"request_headers_to_add_when_not_enforced,omitempty"`
}

func (x *RateLimitQuotaFilterConfig) Reset() {
	*x = RateLimitQuotaFilterConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitQuotaFilterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitQuotaFilterConfig) ProtoMessage() {}

func (x *RateLimitQuotaFilterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitQuotaFilterConfig.ProtoReflect.Descriptor instead.
func (*RateLimitQuotaFilterConfig) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_rawDescGZIP(), []int{0}
}

func (x *RateLimitQuotaFilterConfig) GetRlqsServer() *v3.GrpcService {
	if x != nil {
		return x.RlqsServer
	}
	return nil
}

func (x *RateLimitQuotaFilterConfig) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

func (x *RateLimitQuotaFilterConfig) GetBucketMatchers() *v31.Matcher {
	if x != nil {
		return x.BucketMatchers
	}
	return nil
}

func (x *RateLimitQuotaFilterConfig) GetFilterEnabled() *v3.RuntimeFractionalPercent {
	if x != nil {
		return x.FilterEnabled
	}
	return nil
}

func (x *RateLimitQuotaFilterConfig) GetFilterEnforced() *v3.RuntimeFractionalPercent {
	if x != nil {
		return x.FilterEnforced
	}
	return nil
}

func (x *RateLimitQuotaFilterConfig) GetRequestHeadersToAddWhenNotEnforced() []*v3.HeaderValueOption {
	if x != nil {
		return x.RequestHeadersToAddWhenNotEnforced
	}
	return nil
}

// Per-route and per-host configuration overrides. The more specific definition completely
// overrides the less specific definition.
type RateLimitQuotaOverride struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The application domain to use when calling the service. This enables sharing the quota
	// server between different applications without fear of overlap.
	// E.g., "envoy".
	//
	// If empty, inherits the value from the less specific definition.
	Domain string `protobuf:"bytes,1,opt,name=domain,proto3" json:"domain,omitempty"`
	// The match tree to use for grouping incoming requests into buckets.
	//
	// If set, fully overrides the bucket matchers provided on the less specific definition.
	// If not set, inherits the value from the less specific definition.
	//
	// See usage example: :ref:`RateLimitQuotaFilterConfig.bucket_matchers
	// <envoy_v3_api_field_extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaFilterConfig.bucket_matchers>`.
	BucketMatchers *v31.Matcher `protobuf:"bytes,2,opt,name=bucket_matchers,json=bucketMatchers,proto3" json:"bucket_matchers,omitempty"`
}

func (x *RateLimitQuotaOverride) Reset() {
	*x = RateLimitQuotaOverride{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitQuotaOverride) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitQuotaOverride) ProtoMessage() {}

func (x *RateLimitQuotaOverride) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitQuotaOverride.ProtoReflect.Descriptor instead.
func (*RateLimitQuotaOverride) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_rawDescGZIP(), []int{1}
}

func (x *RateLimitQuotaOverride) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

func (x *RateLimitQuotaOverride) GetBucketMatchers() *v31.Matcher {
	if x != nil {
		return x.BucketMatchers
	}
	return nil
}

// Rate Limit Quota Bucket Settings to apply on the successful “bucket_matchers“ match.
//
// Specify this message in the :ref:`Matcher.OnMatch.action
// <envoy_v3_api_field_.xds.type.matcher.v3.Matcher.OnMatch.action>` field of the
// “bucket_matchers“ matcher tree to assign the matched requests to the Quota Bucket.
// Usage example: :ref:`RateLimitQuotaFilterConfig.bucket_matchers
// <envoy_v3_api_field_extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaFilterConfig.bucket_matchers>`.
// [#next-free-field: 6]
type RateLimitQuotaBucketSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// “BucketId“ builder.
	//
	// :ref:`BucketId <envoy_v3_api_msg_service.rate_limit_quota.v3.BucketId>` is a map from
	// the string key to the string value which serves as bucket identifier common for on
	// the control plane and the data plane.
	//
	// While “BucketId“ is always static, “BucketIdBuilder“ allows to populate map values
	// with the dynamic properties associated with the each individual request.
	//
	// Example 1: static fields only
	//
	// “BucketIdBuilder“:
	//
	// .. validated-code-block:: yaml
	//
	//	:type-name: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.BucketIdBuilder
	//
	//	bucket_id_builder:
	//	  name:
	//	    string_value: my_bucket
	//	  hello:
	//	    string_value: world
	//
	// Produces the following “BucketId“ for all requests:
	//
	// .. validated-code-block:: yaml
	//
	//	:type-name: envoy.service.rate_limit_quota.v3.BucketId
	//
	//	bucket:
	//	  name: my_bucket
	//	  hello: world
	//
	// Example 2: static and dynamic fields
	//
	// .. validated-code-block:: yaml
	//
	//	:type-name: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.BucketIdBuilder
	//
	//	bucket_id_builder:
	//	  name:
	//	    string_value: my_bucket
	//	  env:
	//	    custom_value:
	//	      typed_config:
	//	        '@type': type.googleapis.com/envoy.type.matcher.v3.HttpRequestHeaderMatchInput
	//	        header_name: environment
	//
	// In this example, the value of “BucketId“ key “env“ is substituted from the “environment“
	// request header.
	//
	// This is equivalent to the following “pseudo-code“:
	//
	// .. code-block:: yaml
	//
	//	name: 'my_bucket'
	//	env: $header['environment']
	//
	// For example, the request with the HTTP header “env“ set to “staging“ will produce
	// the following “BucketId“:
	//
	// .. validated-code-block:: yaml
	//
	//	:type-name: envoy.service.rate_limit_quota.v3.BucketId
	//
	//	bucket:
	//	  name: my_bucket
	//	  env: staging
	//
	// For the request with the HTTP header “environment“ set to “prod“, will produce:
	//
	// .. validated-code-block:: yaml
	//
	//	:type-name: envoy.service.rate_limit_quota.v3.BucketId
	//
	//	bucket:
	//	  name: my_bucket
	//	  env: prod
	//
	// .. note::
	//
	//	The order of ``BucketId`` keys do not matter. Buckets ``{ a: 'A', b: 'B' }`` and
	//	``{ b: 'B', a: 'A' }`` are identical.
	//
	// If not set, requests will NOT be reported to the server, and will always limited
	// according to :ref:`no_assignment_behavior
	// <envoy_v3_api_field_extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.no_assignment_behavior>`
	// configuration.
	BucketIdBuilder *RateLimitQuotaBucketSettings_BucketIdBuilder `protobuf:"bytes,1,opt,name=bucket_id_builder,json=bucketIdBuilder,proto3" json:"bucket_id_builder,omitempty"`
	// The interval at which the data plane (RLQS client) is to report quota usage for this bucket.
	//
	// When the first request is matched to a bucket with no assignment, the data plane is to report
	// the request immediately in the :ref:`RateLimitQuotaUsageReports
	// <envoy_v3_api_msg_service.rate_limit_quota.v3.RateLimitQuotaUsageReports>` message.
	// For the RLQS server, this signals that the data plane is now subscribed to
	// the quota assignments in this bucket, and will start sending the assignment as described in
	// the :ref:`RLQS documentation <envoy_v3_api_file_envoy/service/rate_limit_quota/v3/rlqs.proto>`.
	//
	// After sending the initial report, the data plane is to continue reporting the bucket usage with
	// the internal specified in this field.
	//
	// If for any reason RLQS client doesn't receive the initial assignment for the reported bucket,
	// the data plane will eventually consider the bucket abandoned and stop sending the usage
	// reports. This is explained in more details at :ref:`Rate Limit Quota Service (RLQS)
	// <envoy_v3_api_file_envoy/service/rate_limit_quota/v3/rlqs.proto>`.
	//
	// [#comment: 100000000 nanoseconds = 0.1 seconds]
	ReportingInterval *durationpb.Duration `protobuf:"bytes,2,opt,name=reporting_interval,json=reportingInterval,proto3" json:"reporting_interval,omitempty"`
	// Customize the deny response to the requests over the rate limit.
	// If not set, the filter will be configured as if an empty message is set,
	// and will behave according to the defaults specified in :ref:`DenyResponseSettings
	// <envoy_v3_api_msg_extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.DenyResponseSettings>`.
	DenyResponseSettings *RateLimitQuotaBucketSettings_DenyResponseSettings `protobuf:"bytes,3,opt,name=deny_response_settings,json=denyResponseSettings,proto3" json:"deny_response_settings,omitempty"`
	// Configures the behavior in the "no assignment" state: after the first request has been
	// matched to the bucket, and before the the RLQS server returns the first quota assignment.
	//
	// If not set, the default behavior is to allow all requests.
	NoAssignmentBehavior *RateLimitQuotaBucketSettings_NoAssignmentBehavior `protobuf:"bytes,4,opt,name=no_assignment_behavior,json=noAssignmentBehavior,proto3" json:"no_assignment_behavior,omitempty"`
	// Configures the behavior in the "expired assignment" state: the bucket's assignment has expired,
	// and cannot be refreshed.
	//
	// If not set, the bucket is abandoned when its “active“ assignment expires.
	// The process of abandoning the bucket, and restarting the subscription is described in the
	// :ref:`AbandonAction <envoy_v3_api_msg_service.rate_limit_quota.v3.RateLimitQuotaResponse.BucketAction.AbandonAction>`
	// message.
	ExpiredAssignmentBehavior *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior `protobuf:"bytes,5,opt,name=expired_assignment_behavior,json=expiredAssignmentBehavior,proto3" json:"expired_assignment_behavior,omitempty"`
}

func (x *RateLimitQuotaBucketSettings) Reset() {
	*x = RateLimitQuotaBucketSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitQuotaBucketSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitQuotaBucketSettings) ProtoMessage() {}

func (x *RateLimitQuotaBucketSettings) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitQuotaBucketSettings.ProtoReflect.Descriptor instead.
func (*RateLimitQuotaBucketSettings) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_rawDescGZIP(), []int{2}
}

func (x *RateLimitQuotaBucketSettings) GetBucketIdBuilder() *RateLimitQuotaBucketSettings_BucketIdBuilder {
	if x != nil {
		return x.BucketIdBuilder
	}
	return nil
}

func (x *RateLimitQuotaBucketSettings) GetReportingInterval() *durationpb.Duration {
	if x != nil {
		return x.ReportingInterval
	}
	return nil
}

func (x *RateLimitQuotaBucketSettings) GetDenyResponseSettings() *RateLimitQuotaBucketSettings_DenyResponseSettings {
	if x != nil {
		return x.DenyResponseSettings
	}
	return nil
}

func (x *RateLimitQuotaBucketSettings) GetNoAssignmentBehavior() *RateLimitQuotaBucketSettings_NoAssignmentBehavior {
	if x != nil {
		return x.NoAssignmentBehavior
	}
	return nil
}

func (x *RateLimitQuotaBucketSettings) GetExpiredAssignmentBehavior() *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior {
	if x != nil {
		return x.ExpiredAssignmentBehavior
	}
	return nil
}

// Configures the behavior after the first request has been matched to the bucket, and before the
// the RLQS server returns the first quota assignment.
type RateLimitQuotaBucketSettings_NoAssignmentBehavior struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to NoAssignmentBehavior:
	//
	//	*RateLimitQuotaBucketSettings_NoAssignmentBehavior_FallbackRateLimit
	NoAssignmentBehavior isRateLimitQuotaBucketSettings_NoAssignmentBehavior_NoAssignmentBehavior `protobuf_oneof:"no_assignment_behavior"`
}

func (x *RateLimitQuotaBucketSettings_NoAssignmentBehavior) Reset() {
	*x = RateLimitQuotaBucketSettings_NoAssignmentBehavior{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitQuotaBucketSettings_NoAssignmentBehavior) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitQuotaBucketSettings_NoAssignmentBehavior) ProtoMessage() {}

func (x *RateLimitQuotaBucketSettings_NoAssignmentBehavior) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitQuotaBucketSettings_NoAssignmentBehavior.ProtoReflect.Descriptor instead.
func (*RateLimitQuotaBucketSettings_NoAssignmentBehavior) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_rawDescGZIP(), []int{2, 0}
}

func (m *RateLimitQuotaBucketSettings_NoAssignmentBehavior) GetNoAssignmentBehavior() isRateLimitQuotaBucketSettings_NoAssignmentBehavior_NoAssignmentBehavior {
	if m != nil {
		return m.NoAssignmentBehavior
	}
	return nil
}

func (x *RateLimitQuotaBucketSettings_NoAssignmentBehavior) GetFallbackRateLimit() *v32.RateLimitStrategy {
	if x, ok := x.GetNoAssignmentBehavior().(*RateLimitQuotaBucketSettings_NoAssignmentBehavior_FallbackRateLimit); ok {
		return x.FallbackRateLimit
	}
	return nil
}

type isRateLimitQuotaBucketSettings_NoAssignmentBehavior_NoAssignmentBehavior interface {
	isRateLimitQuotaBucketSettings_NoAssignmentBehavior_NoAssignmentBehavior()
}

type RateLimitQuotaBucketSettings_NoAssignmentBehavior_FallbackRateLimit struct {
	// Apply pre-configured rate limiting strategy until the server sends the first assignment.
	FallbackRateLimit *v32.RateLimitStrategy `protobuf:"bytes,1,opt,name=fallback_rate_limit,json=fallbackRateLimit,proto3,oneof"`
}

func (*RateLimitQuotaBucketSettings_NoAssignmentBehavior_FallbackRateLimit) isRateLimitQuotaBucketSettings_NoAssignmentBehavior_NoAssignmentBehavior() {
}

// Specifies the behavior when the bucket's assignment has expired, and cannot be refreshed for
// any reason.
type RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Limit the time :ref:`ExpiredAssignmentBehavior
	// <envoy_v3_api_msg_extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.ExpiredAssignmentBehavior>`
	// is applied. If the server doesn't respond within this duration:
	//
	//  1. Selected “ExpiredAssignmentBehavior“ is no longer applied.
	//  2. The bucket is abandoned. The process of abandoning the bucket is described in the
	//     :ref:`AbandonAction <envoy_v3_api_msg_service.rate_limit_quota.v3.RateLimitQuotaResponse.BucketAction.AbandonAction>`
	//     message.
	//  3. If a new request is matched into the bucket that has become abandoned,
	//     the data plane restarts the subscription to the bucket. The process of restarting the
	//     subscription is described in the :ref:`AbandonAction
	//     <envoy_v3_api_msg_service.rate_limit_quota.v3.RateLimitQuotaResponse.BucketAction.AbandonAction>`
	//     message.
	//
	// If not set, defaults to zero, and the bucket is abandoned immediately.
	ExpiredAssignmentBehaviorTimeout *durationpb.Duration `protobuf:"bytes,1,opt,name=expired_assignment_behavior_timeout,json=expiredAssignmentBehaviorTimeout,proto3" json:"expired_assignment_behavior_timeout,omitempty"`
	// Types that are assignable to ExpiredAssignmentBehavior:
	//
	//	*RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_FallbackRateLimit
	//	*RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment_
	ExpiredAssignmentBehavior isRateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ExpiredAssignmentBehavior `protobuf_oneof:"expired_assignment_behavior"`
}

func (x *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior) Reset() {
	*x = RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior) ProtoMessage() {}

func (x *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior.ProtoReflect.Descriptor instead.
func (*RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_rawDescGZIP(), []int{2, 1}
}

func (x *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior) GetExpiredAssignmentBehaviorTimeout() *durationpb.Duration {
	if x != nil {
		return x.ExpiredAssignmentBehaviorTimeout
	}
	return nil
}

func (m *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior) GetExpiredAssignmentBehavior() isRateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ExpiredAssignmentBehavior {
	if m != nil {
		return m.ExpiredAssignmentBehavior
	}
	return nil
}

func (x *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior) GetFallbackRateLimit() *v32.RateLimitStrategy {
	if x, ok := x.GetExpiredAssignmentBehavior().(*RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_FallbackRateLimit); ok {
		return x.FallbackRateLimit
	}
	return nil
}

func (x *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior) GetReuseLastAssignment() *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment {
	if x, ok := x.GetExpiredAssignmentBehavior().(*RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment_); ok {
		return x.ReuseLastAssignment
	}
	return nil
}

type isRateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ExpiredAssignmentBehavior interface {
	isRateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ExpiredAssignmentBehavior()
}

type RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_FallbackRateLimit struct {
	// Apply the rate limiting strategy to all requests matched into the bucket until the RLQS
	// server sends a new assignment, or the :ref:`expired_assignment_behavior_timeout
	// <envoy_v3_api_field_extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.ExpiredAssignmentBehavior.expired_assignment_behavior_timeout>`
	// runs out.
	FallbackRateLimit *v32.RateLimitStrategy `protobuf:"bytes,2,opt,name=fallback_rate_limit,json=fallbackRateLimit,proto3,oneof"`
}

type RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment_ struct {
	// Reuse the last “active“ assignment until the RLQS server sends a new assignment, or the
	// :ref:`expired_assignment_behavior_timeout
	// <envoy_v3_api_field_extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.ExpiredAssignmentBehavior.expired_assignment_behavior_timeout>`
	// runs out.
	ReuseLastAssignment *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment `protobuf:"bytes,3,opt,name=reuse_last_assignment,json=reuseLastAssignment,proto3,oneof"`
}

func (*RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_FallbackRateLimit) isRateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ExpiredAssignmentBehavior() {
}

func (*RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment_) isRateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ExpiredAssignmentBehavior() {
}

// Customize the deny response to the requests over the rate limit.
type RateLimitQuotaBucketSettings_DenyResponseSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// HTTP response code to deny for HTTP requests (gRPC excluded).
	// Defaults to 429 (:ref:`StatusCode.TooManyRequests<envoy_v3_api_enum_value_type.v3.StatusCode.TooManyRequests>`).
	HttpStatus *v32.HttpStatus `protobuf:"bytes,1,opt,name=http_status,json=httpStatus,proto3" json:"http_status,omitempty"`
	// HTTP response body used to deny for HTTP requests (gRPC excluded).
	// If not set, an empty body is returned.
	HttpBody *wrapperspb.BytesValue `protobuf:"bytes,2,opt,name=http_body,json=httpBody,proto3" json:"http_body,omitempty"`
	// Configure the deny response for gRPC requests over the rate limit.
	// Allows to specify the `RPC status code
	// <https://cloud.google.com/natural-language/docs/reference/rpc/google.rpc#google.rpc.Code>`_,
	// and the error message.
	// Defaults to the Status with the RPC Code “UNAVAILABLE“ and empty message.
	//
	// To identify gRPC requests, Envoy checks that the “Content-Type“ header is
	// “application/grpc“, or one of the various “application/grpc+“ values.
	//
	// .. note::
	//
	//	The HTTP code for a gRPC response is always 200.
	GrpcStatus *status.Status `protobuf:"bytes,3,opt,name=grpc_status,json=grpcStatus,proto3" json:"grpc_status,omitempty"`
	// Specifies a list of HTTP headers that should be added to each response for requests that
	// have been rate limited. Applies both to plain HTTP, and gRPC requests.
	// The headers are added even when the rate limit quota was not enforced.
	ResponseHeadersToAdd []*v3.HeaderValueOption `protobuf:"bytes,4,rep,name=response_headers_to_add,json=responseHeadersToAdd,proto3" json:"response_headers_to_add,omitempty"`
}

func (x *RateLimitQuotaBucketSettings_DenyResponseSettings) Reset() {
	*x = RateLimitQuotaBucketSettings_DenyResponseSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitQuotaBucketSettings_DenyResponseSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitQuotaBucketSettings_DenyResponseSettings) ProtoMessage() {}

func (x *RateLimitQuotaBucketSettings_DenyResponseSettings) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitQuotaBucketSettings_DenyResponseSettings.ProtoReflect.Descriptor instead.
func (*RateLimitQuotaBucketSettings_DenyResponseSettings) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_rawDescGZIP(), []int{2, 2}
}

func (x *RateLimitQuotaBucketSettings_DenyResponseSettings) GetHttpStatus() *v32.HttpStatus {
	if x != nil {
		return x.HttpStatus
	}
	return nil
}

func (x *RateLimitQuotaBucketSettings_DenyResponseSettings) GetHttpBody() *wrapperspb.BytesValue {
	if x != nil {
		return x.HttpBody
	}
	return nil
}

func (x *RateLimitQuotaBucketSettings_DenyResponseSettings) GetGrpcStatus() *status.Status {
	if x != nil {
		return x.GrpcStatus
	}
	return nil
}

func (x *RateLimitQuotaBucketSettings_DenyResponseSettings) GetResponseHeadersToAdd() []*v3.HeaderValueOption {
	if x != nil {
		return x.ResponseHeadersToAdd
	}
	return nil
}

// “BucketIdBuilder“ makes it possible to build :ref:`BucketId
// <envoy_v3_api_msg_service.rate_limit_quota.v3.BucketId>` with values substituted
// from the dynamic properties associated with each individual request. See usage examples in
// the docs to :ref:`bucket_id_builder
// <envoy_v3_api_field_extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.bucket_id_builder>`
// field.
type RateLimitQuotaBucketSettings_BucketIdBuilder struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The map translated into the “BucketId“ map.
	//
	// The “string key“ of this map and becomes the key of “BucketId“ map as is.
	//
	// The “ValueBuilder value“ for the key can be:
	//
	//   - static “StringValue string_value“ — becomes the value in the “BucketId“ map as is.
	//   - dynamic “TypedExtensionConfig custom_value“ — evaluated for each request. Must produce
	//     a string output, which becomes the value in the the “BucketId“ map.
	//
	// See usage examples in the docs to :ref:`bucket_id_builder
	// <envoy_v3_api_field_extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.bucket_id_builder>`
	// field.
	BucketIdBuilder map[string]*RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder `protobuf:"bytes,1,rep,name=bucket_id_builder,json=bucketIdBuilder,proto3" json:"bucket_id_builder,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *RateLimitQuotaBucketSettings_BucketIdBuilder) Reset() {
	*x = RateLimitQuotaBucketSettings_BucketIdBuilder{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitQuotaBucketSettings_BucketIdBuilder) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitQuotaBucketSettings_BucketIdBuilder) ProtoMessage() {}

func (x *RateLimitQuotaBucketSettings_BucketIdBuilder) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitQuotaBucketSettings_BucketIdBuilder.ProtoReflect.Descriptor instead.
func (*RateLimitQuotaBucketSettings_BucketIdBuilder) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_rawDescGZIP(), []int{2, 3}
}

func (x *RateLimitQuotaBucketSettings_BucketIdBuilder) GetBucketIdBuilder() map[string]*RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder {
	if x != nil {
		return x.BucketIdBuilder
	}
	return nil
}

// Reuse the last known quota assignment, effectively extending it for the duration
// specified in the :ref:`expired_assignment_behavior_timeout
// <envoy_v3_api_field_extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.ExpiredAssignmentBehavior.expired_assignment_behavior_timeout>`
// field.
type RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment) Reset() {
	*x = RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment) ProtoMessage() {}

func (x *RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment.ProtoReflect.Descriptor instead.
func (*RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_rawDescGZIP(), []int{2, 1, 0}
}

// Produces the value of the :ref:`BucketId
// <envoy_v3_api_msg_service.rate_limit_quota.v3.BucketId>` map.
type RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ValueSpecifier:
	//
	//	*RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder_StringValue
	//	*RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder_CustomValue
	ValueSpecifier isRateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder_ValueSpecifier `protobuf_oneof:"value_specifier"`
}

func (x *RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder) Reset() {
	*x = RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder) ProtoMessage() {}

func (x *RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder.ProtoReflect.Descriptor instead.
func (*RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_rawDescGZIP(), []int{2, 3, 0}
}

func (m *RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder) GetValueSpecifier() isRateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder_ValueSpecifier {
	if m != nil {
		return m.ValueSpecifier
	}
	return nil
}

func (x *RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder) GetStringValue() string {
	if x, ok := x.GetValueSpecifier().(*RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder) GetCustomValue() *v3.TypedExtensionConfig {
	if x, ok := x.GetValueSpecifier().(*RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder_CustomValue); ok {
		return x.CustomValue
	}
	return nil
}

type isRateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder_ValueSpecifier interface {
	isRateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder_ValueSpecifier()
}

type RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder_StringValue struct {
	// Static string value — becomes the value in the :ref:`BucketId
	// <envoy_v3_api_msg_service.rate_limit_quota.v3.BucketId>` map as is.
	StringValue string `protobuf:"bytes,1,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder_CustomValue struct {
	// Dynamic value — evaluated for each request. Must produce a string output, which becomes
	// the value in the :ref:`BucketId <envoy_v3_api_msg_service.rate_limit_quota.v3.BucketId>`
	// map. For example, extensions with the “envoy.matching.http.input“ category can be used.
	CustomValue *v3.TypedExtensionConfig `protobuf:"bytes,2,opt,name=custom_value,json=customValue,proto3,oneof"`
}

func (*RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder_StringValue) isRateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder_ValueSpecifier() {
}

func (*RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder_CustomValue) isRateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder_ValueSpecifier() {
}

var File_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto protoreflect.FileDescriptor

var file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_rawDesc = []byte{
	0x0a, 0x48, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x2f,
	0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61,
	0x2f, 0x76, 0x33, 0x2f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x71,
	0x75, 0x6f, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x31, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x2e, 0x76, 0x33, 0x1a, 0x1f, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x63, 0x6f, 0x72, 0x65,
	0x2f, 0x76, 0x33, 0x2f, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x63, 0x6f, 0x72,
	0x65, 0x2f, 0x76, 0x33, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x67, 0x72, 0x70, 0x63, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x68, 0x74, 0x74,
	0x70, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x72, 0x61,
	0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72,
	0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x78, 0x64, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x76, 0x33, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x21, 0x78, 0x64, 0x73, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2f, 0x76, 0x33, 0x2f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x75, 0x64, 0x70, 0x61, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x96, 0x04, 0x0a, 0x1a,
	0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4c, 0x0a, 0x0b, 0x72, 0x6c,
	0x71, 0x73, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x72, 0x70, 0x63, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0a, 0x72, 0x6c,
	0x71, 0x73, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x10,
	0x01, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x4f, 0x0a, 0x0f, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x78, 0x64, 0x73, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0e, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x12, 0x55, 0x0a, 0x0e, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x52, 0x0d, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x12, 0x57, 0x0a, 0x0f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x66, 0x6f,
	0x72, 0x63, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x33, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x45, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x64, 0x12, 0x87, 0x01, 0x0a, 0x28, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x5f, 0x74,
	0x6f, 0x5f, 0x61, 0x64, 0x64, 0x5f, 0x77, 0x68, 0x65, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x65,
	0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x64, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x10, 0x0a,
	0x52, 0x22, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73,
	0x54, 0x6f, 0x41, 0x64, 0x64, 0x57, 0x68, 0x65, 0x6e, 0x4e, 0x6f, 0x74, 0x45, 0x6e, 0x66, 0x6f,
	0x72, 0x63, 0x65, 0x64, 0x22, 0x77, 0x0a, 0x16, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69,
	0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x45, 0x0a, 0x0f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x78, 0x64, 0x73, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x0e, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x22, 0x92, 0x11,
	0x0a, 0x1c, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x8b,
	0x01, 0x0a, 0x11, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x5f, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5f, 0x2e, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x5f,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x2e, 0x76, 0x33, 0x2e, 0x52,
	0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x49, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x0f, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x49, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x59, 0x0a, 0x12,
	0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x0f, 0xfa, 0x42, 0x0c, 0xaa, 0x01, 0x09, 0x08, 0x01, 0x2a, 0x05, 0x10,
	0x80, 0xc2, 0xd7, 0x2f, 0x52, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x9a, 0x01, 0x0a, 0x16, 0x64, 0x65, 0x6e, 0x79,
	0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x64, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79,
	0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61, 0x74,
	0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x65, 0x6e, 0x79, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x14,
	0x64, 0x65, 0x6e, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x9a, 0x01, 0x0a, 0x16, 0x6e, 0x6f, 0x5f, 0x61, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x64, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74,
	0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69,
	0x6d, 0x69, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x4e, 0x6f, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x52, 0x14, 0x6e, 0x6f, 0x41,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x12, 0xa9, 0x01, 0x0a, 0x1b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x69, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65,
	0x4c, 0x69, 0x6d, 0x69, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x64,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x52, 0x19, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x64, 0x41, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x1a, 0x89, 0x01,
	0x0a, 0x14, 0x4e, 0x6f, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x12, 0x52, 0x0a, 0x13, 0x66, 0x61, 0x6c, 0x6c, 0x62, 0x61,
	0x63, 0x6b, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x53, 0x74, 0x72,
	0x61, 0x74, 0x65, 0x67, 0x79, 0x48, 0x00, 0x52, 0x11, 0x66, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63,
	0x6b, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x42, 0x1d, 0x0a, 0x16, 0x6e, 0x6f,
	0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x1a, 0xd4, 0x03, 0x0a, 0x19, 0x45, 0x78,
	0x70, 0x69, 0x72, 0x65, 0x64, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x42,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x12, 0x72, 0x0a, 0x23, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x65, 0x64, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0xaa, 0x01, 0x02, 0x2a, 0x00, 0x52, 0x20, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x65, 0x64, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x52, 0x0a, 0x13, 0x66,
	0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79,
	0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x48, 0x00, 0x52, 0x11, 0x66, 0x61,
	0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12,
	0xb3, 0x01, 0x0a, 0x15, 0x72, 0x65, 0x75, 0x73, 0x65, 0x5f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x61,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x7d, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e,
	0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61,
	0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x51, 0x75, 0x6f,
	0x74, 0x61, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x64, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x52, 0x65, 0x75, 0x73, 0x65,
	0x4c, 0x61, 0x73, 0x74, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00,
	0x52, 0x13, 0x72, 0x65, 0x75, 0x73, 0x65, 0x4c, 0x61, 0x73, 0x74, 0x41, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0x15, 0x0a, 0x13, 0x52, 0x65, 0x75, 0x73, 0x65, 0x4c, 0x61,
	0x73, 0x74, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x22, 0x0a, 0x1b,
	0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x12, 0x03, 0xf8, 0x42, 0x01,
	0x1a, 0xab, 0x02, 0x0a, 0x14, 0x44, 0x65, 0x6e, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3a, 0x0a, 0x0b, 0x68, 0x74, 0x74,
	0x70, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x48,
	0x74, 0x74, 0x70, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0a, 0x68, 0x74, 0x74, 0x70, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x38, 0x0a, 0x09, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x62, 0x6f,
	0x64, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x68, 0x74, 0x74, 0x70, 0x42, 0x6f, 0x64, 0x79, 0x12,
	0x33, 0x0a, 0x0b, 0x67, 0x72, 0x70, 0x63, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70,
	0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0a, 0x67, 0x72, 0x70, 0x63, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x68, 0x0a, 0x17, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x61, 0x64, 0x64, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08,
	0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x10, 0x0a, 0x52, 0x14, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x54, 0x6f, 0x41, 0x64, 0x64, 0x1a, 0x91,
	0x04, 0x0a, 0x0f, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x49, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64,
	0x65, 0x72, 0x12, 0xaa, 0x01, 0x0a, 0x11, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x69, 0x64,
	0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x74,
	0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72,
	0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x2e,
	0x76, 0x33, 0x2e, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x51, 0x75, 0x6f, 0x74,
	0x61, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x49, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x2e,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x49, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x9a, 0x01, 0x02, 0x08, 0x01, 0x52, 0x0f,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x49, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x1a,
	0x9c, 0x01, 0x0a, 0x0c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72,
	0x12, 0x23, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x4f, 0x0a, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x33, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x16, 0x0a, 0x0f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f,
	0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x1a, 0xb1,
	0x01, 0x0a, 0x14, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x49, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64,
	0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x82, 0x01, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x6c, 0x2e, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x61,
	0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x49, 0x64, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x42, 0xd5, 0x01, 0x0a, 0x3f, 0x69, 0x6f, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x70,
	0x72, 0x6f, 0x78, 0x79, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x2e, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x2e, 0x76, 0x33, 0x42, 0x13, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69,
	0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x6b, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x70,
	0x72, 0x6f, 0x78, 0x79, 0x2f, 0x67, 0x6f, 0x2d, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2d,
	0x70, 0x6c, 0x61, 0x6e, 0x65, 0x2f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x65, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x68,
	0x74, 0x74, 0x70, 0x2f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x71,
	0x75, 0x6f, 0x74, 0x61, 0x2f, 0x76, 0x33, 0x3b, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x76, 0x33, 0xba, 0x80, 0xc8, 0xd1, 0x06, 0x02,
	0x10, 0x02, 0xd2, 0xc6, 0xa4, 0xe1, 0x06, 0x02, 0x08, 0x01, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_rawDescOnce sync.Once
	file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_rawDescData = file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_rawDesc
)

func file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_rawDescGZIP() []byte {
	file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_rawDescOnce.Do(func() {
		file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_rawDescData = protoimpl.X.CompressGZIP(file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_rawDescData)
	})
	return file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_rawDescData
}

var file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_goTypes = []interface{}{
	(*RateLimitQuotaFilterConfig)(nil),                                                 // 0: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaFilterConfig
	(*RateLimitQuotaOverride)(nil),                                                     // 1: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaOverride
	(*RateLimitQuotaBucketSettings)(nil),                                               // 2: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings
	(*RateLimitQuotaBucketSettings_NoAssignmentBehavior)(nil),                          // 3: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.NoAssignmentBehavior
	(*RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior)(nil),                     // 4: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.ExpiredAssignmentBehavior
	(*RateLimitQuotaBucketSettings_DenyResponseSettings)(nil),                          // 5: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.DenyResponseSettings
	(*RateLimitQuotaBucketSettings_BucketIdBuilder)(nil),                               // 6: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.BucketIdBuilder
	(*RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment)(nil), // 7: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.ExpiredAssignmentBehavior.ReuseLastAssignment
	(*RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder)(nil),                  // 8: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.BucketIdBuilder.ValueBuilder
	nil,                                 // 9: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.BucketIdBuilder.BucketIdBuilderEntry
	(*v3.GrpcService)(nil),              // 10: envoy.config.core.v3.GrpcService
	(*v31.Matcher)(nil),                 // 11: xds.type.matcher.v3.Matcher
	(*v3.RuntimeFractionalPercent)(nil), // 12: envoy.config.core.v3.RuntimeFractionalPercent
	(*v3.HeaderValueOption)(nil),        // 13: envoy.config.core.v3.HeaderValueOption
	(*durationpb.Duration)(nil),         // 14: google.protobuf.Duration
	(*v32.RateLimitStrategy)(nil),       // 15: envoy.type.v3.RateLimitStrategy
	(*v32.HttpStatus)(nil),              // 16: envoy.type.v3.HttpStatus
	(*wrapperspb.BytesValue)(nil),       // 17: google.protobuf.BytesValue
	(*status.Status)(nil),               // 18: google.rpc.Status
	(*v3.TypedExtensionConfig)(nil),     // 19: envoy.config.core.v3.TypedExtensionConfig
}
var file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_depIdxs = []int32{
	10, // 0: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaFilterConfig.rlqs_server:type_name -> envoy.config.core.v3.GrpcService
	11, // 1: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaFilterConfig.bucket_matchers:type_name -> xds.type.matcher.v3.Matcher
	12, // 2: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaFilterConfig.filter_enabled:type_name -> envoy.config.core.v3.RuntimeFractionalPercent
	12, // 3: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaFilterConfig.filter_enforced:type_name -> envoy.config.core.v3.RuntimeFractionalPercent
	13, // 4: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaFilterConfig.request_headers_to_add_when_not_enforced:type_name -> envoy.config.core.v3.HeaderValueOption
	11, // 5: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaOverride.bucket_matchers:type_name -> xds.type.matcher.v3.Matcher
	6,  // 6: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.bucket_id_builder:type_name -> envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.BucketIdBuilder
	14, // 7: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.reporting_interval:type_name -> google.protobuf.Duration
	5,  // 8: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.deny_response_settings:type_name -> envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.DenyResponseSettings
	3,  // 9: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.no_assignment_behavior:type_name -> envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.NoAssignmentBehavior
	4,  // 10: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.expired_assignment_behavior:type_name -> envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.ExpiredAssignmentBehavior
	15, // 11: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.NoAssignmentBehavior.fallback_rate_limit:type_name -> envoy.type.v3.RateLimitStrategy
	14, // 12: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.ExpiredAssignmentBehavior.expired_assignment_behavior_timeout:type_name -> google.protobuf.Duration
	15, // 13: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.ExpiredAssignmentBehavior.fallback_rate_limit:type_name -> envoy.type.v3.RateLimitStrategy
	7,  // 14: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.ExpiredAssignmentBehavior.reuse_last_assignment:type_name -> envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.ExpiredAssignmentBehavior.ReuseLastAssignment
	16, // 15: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.DenyResponseSettings.http_status:type_name -> envoy.type.v3.HttpStatus
	17, // 16: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.DenyResponseSettings.http_body:type_name -> google.protobuf.BytesValue
	18, // 17: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.DenyResponseSettings.grpc_status:type_name -> google.rpc.Status
	13, // 18: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.DenyResponseSettings.response_headers_to_add:type_name -> envoy.config.core.v3.HeaderValueOption
	9,  // 19: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.BucketIdBuilder.bucket_id_builder:type_name -> envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.BucketIdBuilder.BucketIdBuilderEntry
	19, // 20: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.BucketIdBuilder.ValueBuilder.custom_value:type_name -> envoy.config.core.v3.TypedExtensionConfig
	8,  // 21: envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.BucketIdBuilder.BucketIdBuilderEntry.value:type_name -> envoy.extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.BucketIdBuilder.ValueBuilder
	22, // [22:22] is the sub-list for method output_type
	22, // [22:22] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_init() }
func file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_init() {
	if File_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitQuotaFilterConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitQuotaOverride); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitQuotaBucketSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitQuotaBucketSettings_NoAssignmentBehavior); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitQuotaBucketSettings_DenyResponseSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitQuotaBucketSettings_BucketIdBuilder); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*RateLimitQuotaBucketSettings_NoAssignmentBehavior_FallbackRateLimit)(nil),
	}
	file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_FallbackRateLimit)(nil),
		(*RateLimitQuotaBucketSettings_ExpiredAssignmentBehavior_ReuseLastAssignment_)(nil),
	}
	file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder_StringValue)(nil),
		(*RateLimitQuotaBucketSettings_BucketIdBuilder_ValueBuilder_CustomValue)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_goTypes,
		DependencyIndexes: file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_depIdxs,
		MessageInfos:      file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_msgTypes,
	}.Build()
	File_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto = out.File
	file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_rawDesc = nil
	file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_goTypes = nil
	file_envoy_extensions_filters_http_rate_limit_quota_v3_rate_limit_quota_proto_depIdxs = nil
}
