/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util;

import de.unkrig.commons.nullanalysis.Nullable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;

public abstract class TreeComparator<N extends Node<N>, EX extends Throwable> {
    public long compare(N node1, N node2) throws EX {
        SortedSet children1 = node1.children();
        SortedSet children2 = node2.children();
        if (children1 == null) {
            if (children2 == null) {
                this.leafNodeRemains(node1, node2);
                return 0L;
            }
            this.leafNodeChangedToNonLeafNode(node1, node2);
            return 1L;
        }
        if (children2 == null) {
            this.nonLeafNodeChangedToLeafNode(node1, node2);
            return 1L;
        }
        Comparator comparator = children1.comparator();
        if (comparator != children2.comparator()) {
            throw new IllegalArgumentException("Child sets have different comparators");
        }
        Iterator it1 = children1.iterator();
        Iterator it2 = children2.iterator();
        long differenceCount = 0L;
        if (it1.hasNext() && it2.hasNext()) {
            Node subnode1 = (Node)it1.next();
            Node subnode2 = (Node)it2.next();
            while (true) {
                int comp;
                int n = comp = comparator == null ? ((Comparable)((Object)subnode1)).compareTo(subnode2) : comparator.compare(subnode1, subnode2);
                if (comp < 0) {
                    this.nodeDeleted(subnode1);
                    ++differenceCount;
                    if (!it1.hasNext()) {
                        this.nodeAdded(subnode2);
                        ++differenceCount;
                        break;
                    }
                    subnode1 = (Node)it1.next();
                    continue;
                }
                if (comp > 0) {
                    this.nodeAdded(subnode2);
                    ++differenceCount;
                    if (!it2.hasNext()) {
                        this.nodeDeleted(subnode1);
                        ++differenceCount;
                        break;
                    }
                    subnode2 = (Node)it2.next();
                    continue;
                }
                differenceCount += this.compare(subnode1, subnode2);
                if (!it1.hasNext() || !it2.hasNext()) break;
                subnode1 = (Node)it1.next();
                subnode2 = (Node)it2.next();
            }
        }
        while (it1.hasNext()) {
            this.nodeDeleted((Node)it1.next());
            ++differenceCount;
        }
        while (it2.hasNext()) {
            this.nodeAdded((Node)it2.next());
            ++differenceCount;
        }
        return differenceCount;
    }

    protected abstract void nodeAdded(N var1) throws EX;

    protected abstract void nodeDeleted(N var1) throws EX;

    protected abstract void nonLeafNodeChangedToLeafNode(N var1, N var2) throws EX;

    protected abstract void leafNodeChangedToNonLeafNode(N var1, N var2) throws EX;

    protected abstract void leafNodeRemains(N var1, N var2) throws EX;

    public static interface Node<N extends Node<N>> {
        @Nullable
        public SortedSet<N> children();
    }
}

