/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.pattern;

import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.ObjectUtil;
import de.unkrig.commons.lang.protocol.Function;
import de.unkrig.commons.lang.protocol.Mapping;
import de.unkrig.commons.lang.protocol.Mappings;
import de.unkrig.commons.lang.protocol.NoException;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateUtil;
import de.unkrig.commons.lang.protocol.Transformer;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.expression.EvaluationException;
import de.unkrig.commons.text.expression.Expression;
import de.unkrig.commons.text.expression.ExpressionEvaluator;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.text.pattern.PatternUtil;
import java.util.ArrayList;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;

public final class ExpressionMatchReplacer {
    private ExpressionMatchReplacer() {
    }

    public static String replaceSome(Matcher matcher, String spec) throws ParseException {
        return PatternUtil.replaceSome(matcher, ExpressionMatchReplacer.parse(spec));
    }

    public static Function<MatchResult, String> parse(String spec) throws ParseException {
        return ExpressionMatchReplacer.parse(spec, Mappings.none(), PredicateUtil.<String>never());
    }

    public static Function<MatchResult, String> parse(String spec, Object ... variableNamesAndValues) throws ParseException {
        Mapping variables = Mappings.mapping(variableNamesAndValues);
        Predicate<String> isValidVariableName = Mappings.containsKeyPredicate(variables);
        return ExpressionMatchReplacer.parse(spec, variables, isValidVariableName);
    }

    public static Function<MatchResult, String> parse(String spec, Mapping<String, ?> variables, Predicate<String> isValidVariableName) throws ParseException {
        return (Function)ExpressionMatchReplacer.parse(spec, isValidVariableName).transform(variables);
    }

    public static Transformer<Mapping<String, ?>, Function<MatchResult, String>> parse(String spec, Predicate<String> isValidVariableName) throws ParseException {
        Predicate<String> variableNamePredicate = PredicateUtil.or(isValidVariableName, PredicateUtil.equal("m"));
        final Expression expression = new ExpressionEvaluator(variableNamePredicate).parse(spec);
        return new Transformer<Mapping<String, ?>, Function<MatchResult, String>>(){

            @Override
            public Function<MatchResult, String> transform(Mapping<String, ?> variables) throws NoException {
                assert (variables != null);
                return ExpressionMatchReplacer.get(expression, variables);
            }
        };
    }

    public static Transformer<Mapping<String, ?>, Function<MatchResult, String>> parseExt(String spec, Predicate<String> isValidVariableName) throws ParseException {
        int specLength = spec.length();
        Predicate<String> variableNamePredicate = PredicateUtil.or(isValidVariableName, PredicateUtil.equal("m"));
        final ArrayList segments = new ArrayList();
        int idx = 0;
        while (idx < specLength) {
            int to;
            if (spec.charAt(idx) == '$' && idx <= specLength - 2) {
                char c2 = spec.charAt(idx + 1);
                if (Character.isDigit(c2)) {
                    int to2;
                    for (to2 = idx + 2; to2 < specLength && Character.isDigit(spec.charAt(to2)); ++to2) {
                    }
                    final int groupNumber = Integer.parseInt(spec.substring(idx + 1, to2));
                    segments.add(new Transformer<Mapping<String, ?>, String>(){

                        @Override
                        public String transform(Mapping<String, ?> variables) {
                            Object m = variables.get("m");
                            assert (m != null);
                            return ((MatchResult)m).group(groupNumber);
                        }
                    });
                    idx = to2;
                    continue;
                }
                if (Character.isJavaIdentifierStart(c2)) {
                    int to3;
                    for (to3 = idx + 2; to3 < specLength && Character.isJavaIdentifierPart(spec.charAt(to3)); ++to3) {
                    }
                    final String variableName = spec.substring(idx + 1, to3);
                    segments.add(new Transformer<Mapping<String, ?>, String>(){

                        @Override
                        public String transform(Mapping<String, ?> variables) {
                            Object variableValue = variables.get(variableName);
                            assert (variableValue != null);
                            return variableValue.toString();
                        }
                    });
                    idx = to3;
                    continue;
                }
                if (c2 == '{') {
                    ExpressionEvaluator ee = new ExpressionEvaluator(variableNamePredicate);
                    int[] offset = new int[1];
                    final Expression expression = ee.parsePart(spec.substring(idx + 2), offset);
                    int to4 = idx + 2 + offset[0];
                    if (to4 < specLength && spec.charAt(to4) == '}') {
                        segments.add(new Transformer<Mapping<String, ?>, String>(){

                            @Override
                            public String transform(Mapping<String, ?> variables) {
                                try {
                                    return ObjectUtil.or(expression.evaluateTo(variables, String.class), "");
                                }
                                catch (EvaluationException ee) {
                                    throw ExceptionUtil.wrap("Evaluating \"" + expression + "\"", ee, IllegalArgumentException.class);
                                }
                            }
                        });
                        idx = to4 + 1;
                        continue;
                    }
                }
            }
            for (to = idx + 1; to < specLength && spec.charAt(to) != '$'; ++to) {
            }
            final String s = spec.substring(idx, to);
            segments.add(new Transformer<Mapping<String, ?>, String>(){

                @Override
                public String transform(Mapping<String, ?> in) {
                    return s;
                }
            });
            idx = to;
        }
        return new Transformer<Mapping<String, ?>, Function<MatchResult, String>>(){

            @Override
            public Function<MatchResult, String> transform(final Mapping<String, ?> variables) {
                return new Function<MatchResult, String>(){

                    @Override
                    @Nullable
                    public String call(@Nullable MatchResult matchResult) throws NoException {
                        Mapping variables2 = Mappings.override(variables, "m", matchResult);
                        StringBuilder sb = new StringBuilder();
                        for (Transformer segment : segments) {
                            sb.append((String)segment.transform(variables2));
                        }
                        return sb.toString();
                    }
                };
            }
        };
    }

    public static Function<MatchResult, String> parseExt(String spec) throws ParseException {
        return (Function)ExpressionMatchReplacer.parseExt(spec, PredicateUtil.<String>never()).transform(Mappings.none());
    }

    public static Function<MatchResult, String> get(Expression expression, Object ... variableNamesAndValues) {
        return ExpressionMatchReplacer.get(expression, Mappings.mapping(variableNamesAndValues));
    }

    public static Function<MatchResult, String> get(final Expression expression, final Mapping<String, ?> variables) {
        return new Function<MatchResult, String>(){

            @Override
            @Nullable
            public String call(@Nullable MatchResult matchResult) {
                assert (matchResult != null);
                Mapping v2 = Mappings.augment(variables, "m", matchResult);
                try {
                    return expression.evaluateTo(v2, String.class);
                }
                catch (EvaluationException ee) {
                    throw ExceptionUtil.wrap("Evaluating \"" + expression + "\"", ee, IllegalArgumentException.class);
                }
            }
        };
    }
}

