/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.http;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.PredicateWhichThrows;
import de.unkrig.commons.lang.protocol.ProducerUtil;
import de.unkrig.commons.text.parser.AbstractParser;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.text.scanner.AbstractScanner;
import de.unkrig.commons.text.scanner.ScanException;
import de.unkrig.commons.text.scanner.StatefulScanner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class AuthenticateHeaderParser {
    private static final StatefulScanner<TokenType, State> CHALLENGE_SCANNER;

    private AuthenticateHeaderParser() {
    }

    public static List<Challenge> parse(String input) throws ParseException {
        StatefulScanner<TokenType, State> ss = new StatefulScanner<TokenType, State>(CHALLENGE_SCANNER);
        ss.setInput(input);
        AbstractParser<TokenType> p = new AbstractParser<TokenType>(ProducerUtil.filter(ss, new PredicateWhichThrows<AbstractScanner.Token<TokenType>, ScanException>(){

            @Override
            public boolean evaluate(AbstractScanner.Token<TokenType> subject) {
                return subject.type != TokenType.SPACE;
            }
        }));
        ArrayList<Challenge> result = new ArrayList<Challenge>();
        while (true) {
            String authScheme = p.read(TokenType.TOKEN);
            if (p.peek() == null) {
                result.add(new Challenge(authScheme));
                return result;
            }
            String token68 = p.peekRead(TokenType.TOKEN68);
            if (token68 != null) {
                result.add(new Token68Challenge(authScheme, token68));
                if (p.peek() == null) {
                    return result;
                }
                p.read(TokenType.COMMA);
                continue;
            }
            if (p.peekRead(",")) {
                result.add(new Challenge(authScheme));
                continue;
            }
            ArrayList<AuthParam> aps = new ArrayList<AuthParam>();
            do {
                String value;
                AbstractScanner.Token<TokenType> t = p.read();
                if (t.type != TokenType.AUTH_PARAM) {
                    throw new ParseException((Object)((Object)TokenType.AUTH_PARAM) + " expected instead of " + t.type);
                }
                String name = t.captured[0];
                if (t.captured[1] != null && t.captured[2] == null) {
                    value = t.captured[1];
                } else if (t.captured[1] == null && t.captured[2] != null) {
                    value = t.captured[2].replaceAll("\\\\(.)", "$1");
                } else {
                    throw new AssertionError((Object)Arrays.toString(t.captured));
                }
                aps.add(new AuthParam(name, value));
                if (p.peek() == null) {
                    result.add(new ChallengeWithAuthParams(authScheme, aps));
                    return result;
                }
                p.read(TokenType.COMMA);
            } while (p.peek(TokenType.AUTH_PARAM) != null);
        }
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        CHALLENGE_SCANNER = new StatefulScanner(State.class);
        String token = "[A-Za-z0-9!#$%&'*+\\-.^_`|~]+";
        CHALLENGE_SCANNER.addRule(AuthenticateHeaderParser.CHALLENGE_SCANNER.ANY_STATE, "\\s+", TokenType.SPACE).goTo(AuthenticateHeaderParser.CHALLENGE_SCANNER.REMAIN);
        CHALLENGE_SCANNER.addRule(token, TokenType.TOKEN).goTo(State.CHALLENGE1);
        CHALLENGE_SCANNER.addRule(State.CHALLENGE1, "[A-Za-z0-9\\-._~+/]+=*+(?!\\s*[A-Za-z0-9!#$%&'*+\\-.^_`|~\"])", TokenType.TOKEN68);
        CHALLENGE_SCANNER.addRule(AuthenticateHeaderParser.CHALLENGE_SCANNER.ANY_STATE, "(" + token + ")\\s*+=\\s*+(?:(" + token + ")|\"((?:[^\"\\\\]|\\\\.)*)\")", TokenType.AUTH_PARAM);
        CHALLENGE_SCANNER.addRule(AuthenticateHeaderParser.CHALLENGE_SCANNER.ANY_STATE, ",", TokenType.COMMA);
    }

    static enum State {
        CHALLENGE1,
        CHALLENGE2;

    }

    static enum TokenType {
        TOKEN,
        TOKEN68,
        SPACE,
        AUTH_PARAM,
        COMMA;

    }

    public static final class AuthParam {
        public final String name;
        public final String value;

        private AuthParam(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static final class ChallengeWithAuthParams
    extends Challenge {
        public final List<AuthParam> authParams;

        private ChallengeWithAuthParams(String authScheme, List<AuthParam> authParams) {
            super(authScheme);
            this.authParams = authParams;
        }
    }

    public static final class Token68Challenge
    extends Challenge {
        public final String token68;

        private Token68Challenge(String authScheme, String token68) {
            super(authScheme);
            this.token68 = token68;
        }
    }

    public static class Challenge {
        public final String authScheme;

        Challenge(String authScheme) {
            this.authScheme = authScheme;
        }
    }
}

