/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.ftp;

import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.lang.protocol.Stoppable;
import de.unkrig.commons.net.TcpServer;
import de.unkrig.commons.net.ftp.FtpSession;
import de.unkrig.commons.net.ftp.ftplett.Ftplett;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;

public class FtpServer
implements RunnableWhichThrows<IOException>,
Stoppable {
    private TcpServer tcpServer;

    public FtpServer(InetSocketAddress endpoint, int backlog, final Ftplett ftplett) throws IOException {
        this.tcpServer = new TcpServer(endpoint, backlog, new TcpServer.ConnectionHandler(){

            @Override
            public void handleConnection(InputStream in, OutputStream out, InetSocketAddress localSocketAddress, InetSocketAddress remoteSocketAddress, Stoppable stoppable) throws IOException {
                new FtpSession(in, out, localSocketAddress, remoteSocketAddress.getAddress(), ftplett).run();
            }
        });
    }

    @Override
    public void run() throws IOException {
        this.tcpServer.run();
    }

    @Override
    public void stop() {
        this.tcpServer.stop();
    }

    static enum CommandCode {
        USER,
        PASS,
        NOOP,
        RETR,
        CWD,
        PWD,
        QUIT,
        PORT,
        LIST,
        NLST,
        SYST,
        TYPE,
        PASV,
        MODE,
        STOR,
        DELE,
        RNFR,
        RNTO,
        MDTM;

    }
}

