/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net;

import de.unkrig.commons.io.HexOutputStream;
import de.unkrig.commons.io.InputStreams;
import de.unkrig.commons.io.OutputStreams;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.ThreadUtil;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.lang.protocol.Stoppable;
import de.unkrig.commons.util.logging.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;

public class TcpServer
implements RunnableWhichThrows<IOException>,
Stoppable {
    private static final Logger LOGGER = Logger.getLogger(TcpServer.class.getName());
    private final ServerSocket serverSocket;
    private final ConnectionHandler clientConnectionHandler;
    private static final AtomicInteger CONNECTION_COUNT = new AtomicInteger();

    public TcpServer(InetSocketAddress endpoint, int backlog, ConnectionHandler clientConnectionHandler) throws IOException {
        this(TcpServer.serverSocket(endpoint, backlog), clientConnectionHandler);
    }

    public TcpServer(InetSocketAddress endpoint, int backlog, SSLContext sslContext, ConnectionHandler clientConnectionHandler) throws IOException {
        this(TcpServer.secureServerSocket(endpoint, backlog, sslContext), clientConnectionHandler);
    }

    private TcpServer(ServerSocket serverSocket, ConnectionHandler clientConnectionHandler) {
        this.serverSocket = serverSocket;
        this.clientConnectionHandler = clientConnectionHandler;
        LOGGER.log(Level.FINE, "{0} created", this.serverSocket);
    }

    private static ServerSocket serverSocket(InetSocketAddress endpoint, int backlog) throws IOException {
        LOGGER.log(Level.FINE, "Creating server on {0}", endpoint);
        try {
            return new ServerSocket(endpoint.getPort(), backlog, endpoint.getAddress());
        }
        catch (IOException ioe) {
            throw ExceptionUtil.wrap("Creating server socket for endpoint " + endpoint, ioe);
        }
    }

    private static SSLServerSocket secureServerSocket(InetSocketAddress endpoint, int backlog, SSLContext sslContext) throws IOException {
        LOGGER.log(Level.FINE, "Creating secure server socket on {0}", endpoint);
        SSLServerSocket sss = (SSLServerSocket)sslContext.getServerSocketFactory().createServerSocket(endpoint.getPort(), backlog, endpoint.getAddress());
        TcpServer.disableProblematicCipherSuites(sss);
        return sss;
    }

    private static void disableProblematicCipherSuites(SSLServerSocket sss) {
        HashSet<String> enabledCipherSuites = new HashSet<String>(Arrays.asList(sss.getEnabledCipherSuites()));
        enabledCipherSuites.remove("SSL_RSA_WITH_DES_CBC_SHA");
        enabledCipherSuites.remove("SSL_DHE_RSA_WITH_DES_CBC_SHA");
        enabledCipherSuites.remove("SSL_DHE_DSS_WITH_DES_CBC_SHA");
        enabledCipherSuites.remove("SSL_RSA_EXPORT_WITH_RC4_40_MD5");
        enabledCipherSuites.remove("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA");
        enabledCipherSuites.remove("SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA");
        enabledCipherSuites.remove("SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA");
        enabledCipherSuites.remove("SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA");
        enabledCipherSuites.remove("TLS_DHE_RSA_WITH_AES_256_CBC_SHA256");
        enabledCipherSuites.remove("TLS_DHE_DSS_WITH_AES_256_CBC_SHA256");
        enabledCipherSuites.remove("TLS_DHE_RSA_WITH_AES_256_CBC_SHA");
        enabledCipherSuites.remove("TLS_DHE_DSS_WITH_AES_256_CBC_SHA");
        enabledCipherSuites.remove("TLS_DHE_RSA_WITH_AES_128_CBC_SHA256");
        enabledCipherSuites.remove("TLS_DHE_DSS_WITH_AES_128_CBC_SHA256");
        enabledCipherSuites.remove("TLS_DHE_RSA_WITH_AES_128_CBC_SHA");
        enabledCipherSuites.remove("TLS_DHE_DSS_WITH_AES_128_CBC_SHA");
        sss.setEnabledCipherSuites(enabledCipherSuites.toArray(new String[enabledCipherSuites.size()]));
    }

    public InetSocketAddress getEndpointAddress() {
        return (InetSocketAddress)this.serverSocket.getLocalSocketAddress();
    }

    @Override
    public void run() throws IOException {
        while (true) {
            Socket clientSocket;
            LOGGER.log(Level.FINE, "Accepting connections on {0}", this.serverSocket);
            try {
                clientSocket = this.serverSocket.accept();
            }
            catch (SocketTimeoutException ste) {
                LOGGER.log(Level.FINE, "{0}: {1}", new Object[]{this.serverSocket, ste});
                continue;
            }
            catch (SocketException se) {
                if (TcpServer.isSocketClosedException(se)) {
                    LOGGER.log(Level.FINE, "{0}: {1}", new Object[]{this.serverSocket, se});
                    return;
                }
                throw se;
            }
            try {
                int connectionNumber = CONNECTION_COUNT.incrementAndGet();
                LOGGER.log(Level.FINE, "Client connection #{0} accepted: {1}", new Object[]{connectionNumber, clientSocket});
                InputStream in = clientSocket.getInputStream();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    in = InputStreams.wye(in, new HexOutputStream(LogUtil.logWriter(LOGGER, Level.FINEST, "<From Client< ")));
                }
                final InputStream clientIn = in;
                OutputStream out = clientSocket.getOutputStream();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    out = OutputStreams.tee(out, new HexOutputStream(LogUtil.logWriter(LOGGER, Level.FINEST, ">To   Client> ")));
                }
                final OutputStream clientOut = out;
                final InetSocketAddress clientLocalSocketAddress = (InetSocketAddress)clientSocket.getLocalSocketAddress();
                final InetSocketAddress clientRemoteSocketAddress = (InetSocketAddress)clientSocket.getRemoteSocketAddress();
                ThreadUtil.runInBackground(new Runnable(){

                    /*
                     * Exception decompiling
                     */
                    @Override
                    public void run() {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                }, "Connection #" + connectionNumber);
            }
            catch (IOException ioe) {
                try {
                    clientSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ioe;
            }
            catch (RuntimeException re) {
                try {
                    clientSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw re;
            }
        }
    }

    @Override
    public void stop() {
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isSocketClosedException(SocketException se) {
        String m = se.getMessage();
        return m.endsWith("socket closed") || m.endsWith("Socket closed") || m.endsWith("Socket is closed") || m.contains("Connection reset") || m.endsWith("Broken pipe") || m.endsWith("Software caused connection abort: recv failed") || m.endsWith("Software caused connection abort: socket write error");
    }

    static /* synthetic */ ConnectionHandler access$000(TcpServer x0) {
        return x0.clientConnectionHandler;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static /* synthetic */ boolean access$200(SocketException x0) {
        return TcpServer.isSocketClosedException(x0);
    }

    public static interface ConnectionHandler {
        public void handleConnection(InputStream var1, OutputStream var2, InetSocketAddress var3, InetSocketAddress var4, Stoppable var5) throws Exception;
    }
}

