/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang;

import de.unkrig.commons.nullanalysis.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class OptionalMethods {
    private OptionalMethods() {
    }

    public static <R> MethodWrapper0<Object, R, RuntimeException> get0(@Nullable ClassLoader declaringClassLoader, String declaringClassName, String methodName) {
        return OptionalMethods.get0(declaringClassLoader, declaringClassName, methodName, RuntimeException.class);
    }

    public static <R, EX extends Throwable> MethodWrapper0<Object, R, EX> get0(@Nullable ClassLoader declaringClassLoader, final String declaringClassName, String methodName, @Nullable Class<EX> checkedException) {
        Class<?> declaringClass;
        if (declaringClassLoader == null) {
            declaringClassLoader = Thread.currentThread().getContextClassLoader();
        }
        assert (declaringClassLoader != null);
        try {
            declaringClass = declaringClassLoader.loadClass(declaringClassName);
        }
        catch (ClassNotFoundException e) {
            return new MethodWrapper0<Object, R, EX>(){

                @Override
                public boolean isAvailable() {
                    return false;
                }

                @Override
                @Nullable
                public R invoke(@Nullable Object target) {
                    throw new UnsupportedOperationException(declaringClassName);
                }
            };
        }
        MethodWrapper0<?, R, EX> result = OptionalMethods.get0(declaringClass, methodName, checkedException);
        return result;
    }

    public static <DC, R> MethodWrapper0<DC, R, RuntimeException> get0(Class<DC> declaringClass, String methodName) {
        return OptionalMethods.get0(declaringClass, methodName, RuntimeException.class);
    }

    public static <DC, R, EX extends Throwable> MethodWrapper0<DC, R, EX> get0(final Class<DC> declaringClass, final String methodName, final @Nullable Class<EX> checkedException) {
        Method method;
        try {
            method = declaringClass.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        final Method finalMethod = method;
        return new MethodWrapper0<DC, R, EX>(){

            @Override
            public boolean isAvailable() {
                return finalMethod != null;
            }

            @Override
            @Nullable
            public R invoke(@Nullable DC target) throws Throwable {
                if (finalMethod == null) {
                    throw new UnsupportedOperationException(declaringClass.getName() + "." + methodName + "()");
                }
                try {
                    return finalMethod.invoke(target, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    Throwable te = e.getTargetException();
                    if (te instanceof RuntimeException) {
                        throw (RuntimeException)te;
                    }
                    if (te instanceof Error) {
                        throw (Error)te;
                    }
                    assert (checkedException != null) : "Caught undeclared checked exception " + te;
                    assert (checkedException.isAssignableFrom(te.getClass()));
                    throw te;
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            }
        };
    }

    public static <R, P> MethodWrapper1<?, R, P, RuntimeException> get1(@Nullable ClassLoader declaringClassLoader, String declaringClassName, String methodName, Class<P> parameterType) {
        return OptionalMethods.get1(declaringClassLoader, declaringClassName, methodName, parameterType, RuntimeException.class);
    }

    public static <R, P, EX extends Throwable> MethodWrapper1<?, R, P, EX> get1(@Nullable ClassLoader declaringClassLoader, final String declaringClassName, String methodName, Class<P> parameterType, @Nullable Class<EX> checkedException) {
        Class<?> declaringClass;
        if (declaringClassLoader == null) {
            declaringClassLoader = Thread.currentThread().getContextClassLoader();
        }
        assert (declaringClassLoader != null);
        try {
            declaringClass = declaringClassLoader.loadClass(declaringClassName);
        }
        catch (ClassNotFoundException e) {
            return new MethodWrapper1<Object, R, P, EX>(){

                @Override
                public boolean isAvailable() {
                    return false;
                }

                @Override
                @Nullable
                public R invoke(@Nullable Object target, @Nullable P parameter) {
                    throw new UnsupportedOperationException(declaringClassName);
                }
            };
        }
        return OptionalMethods.get1(declaringClass, methodName, parameterType, checkedException);
    }

    public static <DC, R, P> MethodWrapper1<DC, R, P, RuntimeException> get1(Class<DC> declaringClass, String methodName, Class<P> parameterType) {
        return OptionalMethods.get1(declaringClass, methodName, parameterType, RuntimeException.class);
    }

    public static <DC, R, P, EX extends Throwable> MethodWrapper1<DC, R, P, EX> get1(final Class<DC> declaringClass, final String methodName, final Class<P> parameterType, final @Nullable Class<EX> checkedException) {
        Method method;
        try {
            method = declaringClass.getMethod(methodName, parameterType);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        final Method finalMethod = method;
        return new MethodWrapper1<DC, R, P, EX>(){

            @Override
            public boolean isAvailable() {
                return finalMethod != null;
            }

            @Override
            @Nullable
            public R invoke(@Nullable DC target, @Nullable P parameter) throws Throwable {
                if (finalMethod == null) {
                    throw new UnsupportedOperationException(declaringClass.getName() + "." + methodName + "(" + parameterType.getName() + ")");
                }
                try {
                    return finalMethod.invoke(target, parameter);
                }
                catch (InvocationTargetException e) {
                    Throwable te = e.getTargetException();
                    if (te instanceof RuntimeException) {
                        throw (RuntimeException)te;
                    }
                    if (te instanceof Error) {
                        throw (Error)te;
                    }
                    assert (checkedException != null) : "Caught undeclared checked exception " + te;
                    assert (checkedException.isAssignableFrom(te.getClass()));
                    throw te;
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            }
        };
    }

    public static <R, P1, P2> MethodWrapper2<?, R, P1, P2, RuntimeException> get2(@Nullable ClassLoader declaringClassLoader, String declaringClassName, String methodName, Class<P1> parameterType1, Class<P2> parameterType2) {
        return OptionalMethods.get2(declaringClassLoader, declaringClassName, methodName, parameterType1, parameterType2, RuntimeException.class);
    }

    public static <R, P1, P2, EX extends Throwable> MethodWrapper2<?, R, P1, P2, EX> get2(@Nullable ClassLoader declaringClassLoader, final String declaringClassName, String methodName, Class<P1> parameterType1, Class<P2> parameterType2, @Nullable Class<EX> checkedException) {
        Class<?> declaringClass;
        if (declaringClassLoader == null) {
            declaringClassLoader = Thread.currentThread().getContextClassLoader();
        }
        assert (declaringClassLoader != null);
        try {
            declaringClass = declaringClassLoader.loadClass(declaringClassName);
        }
        catch (ClassNotFoundException e) {
            return new MethodWrapper2<Object, R, P1, P2, EX>(){

                @Override
                public boolean isAvailable() {
                    return false;
                }

                @Override
                @Nullable
                public R invoke(@Nullable Object target, @Nullable P1 parameter1, @Nullable P2 parameter2) {
                    throw new UnsupportedOperationException(declaringClassName);
                }
            };
        }
        return OptionalMethods.get2(declaringClass, methodName, parameterType1, parameterType2, checkedException);
    }

    public static <DC, R, P1, P2> MethodWrapper2<DC, R, P1, P2, RuntimeException> get2(Class<DC> declaringClass, String methodName, Class<P1> parameterType1, Class<P2> parameterType2) {
        return OptionalMethods.get2(declaringClass, methodName, parameterType1, parameterType2, RuntimeException.class);
    }

    public static <DC, R, P1, P2, EX extends Throwable> MethodWrapper2<DC, R, P1, P2, EX> get2(final Class<DC> declaringClass, final String methodName, Class<P1> parameterType1, Class<P2> parameterType2, final @Nullable Class<EX> checkedException) {
        Method method;
        try {
            method = declaringClass.getMethod(methodName, parameterType1, parameterType2);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        final Method finalMethod = method;
        return new MethodWrapper2<DC, R, P1, P2, EX>(){

            @Override
            public boolean isAvailable() {
                return finalMethod != null;
            }

            @Override
            @Nullable
            public R invoke(@Nullable DC target, @Nullable P1 parameter1, @Nullable P2 parameter2) throws Throwable {
                if (finalMethod == null) {
                    throw new UnsupportedOperationException(declaringClass.getName() + "." + methodName + "(" + parameter1 + ", " + parameter2 + ")");
                }
                try {
                    return finalMethod.invoke(target, parameter1, parameter2);
                }
                catch (InvocationTargetException e) {
                    Throwable te = e.getTargetException();
                    if (te instanceof RuntimeException) {
                        throw (RuntimeException)te;
                    }
                    if (te instanceof Error) {
                        throw (Error)te;
                    }
                    assert (checkedException != null) : "Caught undeclared checked exception " + te;
                    assert (checkedException.isAssignableFrom(te.getClass()));
                    throw te;
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            }
        };
    }

    public static interface MethodWrapper2<DC, R, P1, P2, EX extends Throwable> {
        public boolean isAvailable();

        @Nullable
        public R invoke(@Nullable DC var1, @Nullable P1 var2, @Nullable P2 var3) throws EX;
    }

    public static interface MethodWrapper1<DC, R, P, EX extends Throwable> {
        public boolean isAvailable();

        @Nullable
        public R invoke(@Nullable DC var1, @Nullable P var2) throws EX;
    }

    public static interface MethodWrapper0<DC, R, EX extends Throwable> {
        public boolean isAvailable();

        @Nullable
        public R invoke(@Nullable DC var1) throws EX;
    }
}

