/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.io.LineUtil;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public final class Readers {
    public static final Reader EMPTY_READER = new Reader(){

        @Override
        public int read() {
            return -1;
        }

        @Override
        public int read(@Nullable char[] buf, int off, int len) {
            return -1;
        }

        @Override
        public void close() {
        }
    };

    private Readers() {
    }

    public static String readAll(Reader reader) throws IOException {
        return Readers.readAll(reader, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAll(Reader reader, boolean closeReader) throws IOException {
        char[] buf = new char[4096];
        StringBuilder sb = new StringBuilder();
        try {
            int n;
            while ((n = reader.read(buf)) != -1) {
                sb.append(buf, 0, n);
            }
            if (closeReader) {
                reader.close();
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (closeReader) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Reader asReader(final CharSequence cs) {
        return new Reader(){
            int pos;

            @Override
            public int read() {
                return this.pos >= cs.length() ? -1 : (int)cs.charAt(this.pos++);
            }

            @Override
            public int read(@Nullable char[] cbuf, int off, int len) {
                assert (cbuf != null);
                if (len <= 0) {
                    return 0;
                }
                if (this.pos >= cs.length()) {
                    return -1;
                }
                int end = cs.length();
                if (this.pos + len > end) {
                    len = end - this.pos;
                } else {
                    end = this.pos + len;
                }
                int i = this.pos;
                while (i < end) {
                    cbuf[off++] = cs.charAt(i++);
                }
                return len;
            }

            @Override
            public void close() {
            }
        };
    }

    public static Reader singlingFilterReader(Reader delegate) {
        return new FilterReader(delegate){

            @Override
            @NotNullByDefault(value=false)
            public int read(char[] cbuf, int off, int len) throws IOException {
                return this.in.read(cbuf, off, len <= 0 ? 0 : 1);
            }

            @Override
            @NotNullByDefault(value=false)
            public int read(CharBuffer target) throws IOException {
                if (target.remaining() == 0) {
                    return 0;
                }
                int c = this.read();
                if (c == -1) {
                    return -1;
                }
                target.put((char)c);
                return 1;
            }
        };
    }

    public static Reader onFirstChar(Reader in, final Runnable runnable) {
        return new FilterReader(in){
            private boolean hadChars;

            @Override
            public int read() throws IOException {
                this.aboutToRead();
                return super.read();
            }

            @Override
            @NotNullByDefault(value=false)
            public int read(char[] cbuf, int off, int len) throws IOException {
                this.aboutToRead();
                return super.read(cbuf, off, len);
            }

            @Override
            public long skip(long n) throws IOException {
                this.aboutToRead();
                return super.skip(n);
            }

            private void aboutToRead() {
                if (!this.hadChars) {
                    runnable.run();
                    this.hadChars = true;
                }
            }
        };
    }

    public static Reader trackLineAndColumn(Reader in, final LineUtil.LineAndColumnTracker tracker) {
        return new FilterReader(in){

            @Override
            public int read() throws IOException {
                int c = super.read();
                if (c >= 0) {
                    tracker.consume((char)c);
                }
                return c;
            }

            @Override
            @NotNullByDefault(value=false)
            public int read(char[] cbuf, int off, int len) throws IOException {
                if (len <= 0) {
                    return 0;
                }
                int c = this.read();
                if (c < 0) {
                    return -1;
                }
                cbuf[off] = (char)c;
                return 1;
            }

            @Override
            public long skip(long n) throws IOException {
                if (n <= 0L) {
                    return 0L;
                }
                int c = this.read();
                if (c < 0) {
                    return 0L;
                }
                return 1L;
            }

            @Override
            public boolean markSupported() {
                return false;
            }

            @Override
            public void mark(int readAheadLimit) throws IOException {
                throw new IOException();
            }

            @Override
            public void reset() throws IOException {
                throw new IOException();
            }
        };
    }
}

