/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

@NotNullByDefault(value=false)
public class ReaderInputStream
extends InputStream {
    private final Reader delegate;
    private final CharsetEncoder encoder;
    private final CharBuffer in = CharBuffer.allocate(1024);
    private final ByteBuffer out = ByteBuffer.allocate(128);
    private CoderResult lastCoderResult;
    private boolean endOfInput;

    public ReaderInputStream(Reader delegate) {
        this(delegate, Charset.defaultCharset());
    }

    public ReaderInputStream(Reader delegate, String charsetName) {
        this(delegate, Charset.forName(charsetName));
    }

    public ReaderInputStream(Reader delegate, Charset charset) {
        this(delegate, charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
    }

    public ReaderInputStream(Reader delegate, CharsetEncoder encoder) {
        this.delegate = delegate;
        this.encoder = encoder;
        this.in.flip();
        this.out.flip();
    }

    @Override
    public int read() throws IOException {
        do {
            if (this.out.hasRemaining()) {
                return this.out.get() & 0xFF;
            }
            this.fillBuffer();
        } while (!this.endOfInput || this.out.hasRemaining());
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("buf");
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException("off");
        }
        if (len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("len");
        }
        if (len == 0) {
            return 0;
        }
        int count = 0;
        while (len > 0) {
            if (this.out.hasRemaining()) {
                int c = Math.min(this.out.remaining(), len);
                this.out.get(b, off, c);
                off += c;
                len -= c;
                count += c;
                continue;
            }
            this.fillBuffer();
            if (!this.endOfInput || this.out.hasRemaining()) continue;
        }
        return count == 0 && this.endOfInput ? -1 : count;
    }

    @Override
    public int available() throws IOException {
        return this.out.hasRemaining() || this.delegate.ready() ? 1 : 0;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private void fillBuffer() throws IOException {
        if (!this.endOfInput && (this.lastCoderResult == null || this.lastCoderResult.isUnderflow())) {
            this.in.compact();
            int count = this.delegate.read(this.in.array(), this.in.position(), this.in.remaining());
            if (count == -1) {
                this.endOfInput = true;
            } else {
                this.in.position(this.in.position() + count);
            }
            this.in.flip();
        }
        this.out.compact();
        this.lastCoderResult = this.encoder.encode(this.in, this.out, this.endOfInput);
        this.out.flip();
    }
}

