/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.lang.protocol.Stoppable;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Multiplexer
implements RunnableWhichThrows<IOException>,
Stoppable {
    private final SortedMap<Long, List<Runnable>> timers = new TreeMap<Long, List<Runnable>>();
    private volatile boolean stopping;
    private static final Logger LOGGER = Logger.getLogger(Multiplexer.class.getName());
    private final Selector selector = Selector.open();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() throws IOException {
        this.stopping = false;
        while (!this.stopping) {
            Object runnable;
            Iterator<Object> it;
            Object object;
            long timeout;
            block12: {
                timeout = 0L;
                object = this.timers;
                synchronized (object) {
                    it = this.timers.entrySet().iterator();
                    if (!it.hasNext()) {
                        break block12;
                    }
                    Map.Entry<Long, List<Runnable>> entry = it.next();
                    Long expiry = entry.getKey();
                    timeout = expiry - System.currentTimeMillis();
                    if (timeout > 0L) {
                        break block12;
                    }
                    List<Runnable> runnables = entry.getValue();
                    runnable = runnables.remove(0);
                    if (runnables.isEmpty()) {
                        it.remove();
                    }
                }
                runnable.run();
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Waiting for {0} key(s)", new Object[]{this.selector.keys().size()});
            }
            this.selector.select(Math.min(0L, timeout));
            object = this.selector;
            synchronized (object) {
                it = this.selector.selectedKeys().iterator();
                if (!it.hasNext()) {
                    continue;
                }
                RunnableWhichThrows tmp = (RunnableWhichThrows)((SelectionKey)it.next()).attachment();
                runnable = tmp;
                it.remove();
            }
            runnable.run();
        }
    }

    public SelectionKey register(SelectableChannel sc, int ops, RunnableWhichThrows<IOException> runnable) throws ClosedChannelException {
        SelectionKey key = sc.register(this.selector, ops, runnable);
        this.selector.wakeup();
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerKey timer(long expiry, final Runnable runnable) {
        List<Runnable> runnables;
        SortedMap<Long, List<Runnable>> sortedMap = this.timers;
        synchronized (sortedMap) {
            runnables = Multiplexer.get2(this.timers, expiry);
            runnables.add(runnable);
            if (this.timers.firstKey() == expiry) {
                this.selector.wakeup();
            }
        }
        return new TimerKey(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancel() {
                SortedMap sortedMap = Multiplexer.this.timers;
                synchronized (sortedMap) {
                    runnables.remove(runnable);
                }
            }
        };
    }

    @Override
    public void stop() {
        this.stopping = true;
    }

    private static <K, LE> List<LE> get2(Map<K, List<LE>> map, K key) {
        List<LE> l = map.get(key);
        if (l == null) {
            l = new ArrayList<LE>();
            map.put(key, l);
        }
        return l;
    }

    public static interface TimerKey {
        public void cancel();
    }
}

