/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.io.EventCounter;
import de.unkrig.commons.nullanalysis.Nullable;
import java.util.Formatter;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingEventCounter
extends EventCounter {
    private final String name;
    private final Logger logger;
    private final Level level;
    private final long start = System.currentTimeMillis();

    public LoggingEventCounter(String name, Logger logger, Level level) {
        this.name = name;
        this.logger = logger;
        this.level = level;
    }

    @Override
    public void countEvent(String eventName, @Nullable Object arg) {
        if (!this.logger.isLoggable(this.level)) {
            return;
        }
        super.countEvent(eventName, arg);
        this.log();
    }

    protected void log() {
        long interval = System.currentTimeMillis() - this.start;
        Formatter f = new Formatter();
        f.format("%s statistics:", this.name);
        for (Map.Entry e : this.sortedEvents) {
            String eventName = (String)e.getKey();
            long arg = ((AtomicLong)e.getValue()).get();
            f.format(" %s=%,d(%,d/sec)", eventName, arg, arg / interval);
        }
        this.logger.log(this.level, f.toString());
    }
}

