/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.task;

import de.unkrig.commons.nullanalysis.Nullable;
import java.net.InetAddress;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class NslookupTask
extends Task {
    @Nullable
    private String host;
    @Nullable
    private String addressProperty;
    @Nullable
    private String addressesProperty;
    @Nullable
    private String hostNameProperty;
    @Nullable
    private String canonicalHostNameProperty;
    private boolean failOnError = true;

    public void setHost(String host) {
        this.host = host;
    }

    public void setAddressProperty(String propertyName) {
        this.addressProperty = propertyName;
    }

    public void setAddressesProperty(String propertyName) {
        this.addressesProperty = propertyName;
    }

    public void setHostNameProperty(String propertyName) {
        this.hostNameProperty = propertyName;
    }

    public void setCanonicalHostNameProperty(String propertyName) {
        this.canonicalHostNameProperty = propertyName;
    }

    public void setFailOnError(boolean value) {
        this.failOnError = value;
    }

    public void execute() {
        try {
            this.execute2();
        }
        catch (BuildException be) {
            throw be;
        }
        catch (Exception e) {
            if (!this.failOnError) {
                return;
            }
            throw new BuildException((Throwable)e);
        }
    }

    private void execute2() throws Exception {
        String host = this.host;
        if (host == null) {
            throw new BuildException("Attribute 'host' missing");
        }
        if (this.addressProperty != null) {
            this.getProject().setProperty(this.addressProperty, InetAddress.getByName(host).getHostAddress());
        }
        if (this.addressesProperty != null) {
            InetAddress[] inetAddresses = InetAddress.getAllByName(host);
            StringBuilder sb = new StringBuilder(inetAddresses[0].getHostAddress());
            for (int i = 1; i < inetAddresses.length; ++i) {
                sb.append(",").append(inetAddresses[i].getHostAddress());
            }
            this.getProject().setProperty(this.addressesProperty, sb.toString());
        }
        if (this.hostNameProperty != null) {
            this.getProject().setProperty(this.hostNameProperty, InetAddress.getByName(host).getHostName());
        }
        if (this.canonicalHostNameProperty != null) {
            this.getProject().setProperty(this.canonicalHostNameProperty, InetAddress.getByName(host).getCanonicalHostName());
        }
    }
}

