/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util;

import de.unkrig.commons.util.Consumer;
import de.unkrig.commons.util.ConsumerWhichThrows;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerUtil {
    private ConsumerUtil() {
    }

    public static <T, EX extends Throwable> ConsumerWhichThrows<T, EX> tee(final ConsumerWhichThrows<T, EX> delegate1, final ConsumerWhichThrows<T, EX> delegate2) {
        return new ConsumerWhichThrows<T, EX>(){

            @Override
            public void consume(T subject) throws Throwable {
                delegate1.consume(subject);
                delegate2.consume(subject);
            }
        };
    }

    public static <T, EX extends Throwable> ConsumerWhichThrows<T, EX> tee(final Collection<ConsumerWhichThrows<T, EX>> delegates) {
        return new ConsumerWhichThrows<T, EX>(){

            @Override
            public void consume(T subject) throws Throwable {
                for (ConsumerWhichThrows delegate : delegates) {
                    delegate.consume(subject);
                }
            }
        };
    }

    public static <T, E2 extends Throwable, E1 extends E2> ConsumerWhichThrows<T, E2> cast(final ConsumerWhichThrows<T, E1> delegate) {
        return new ConsumerWhichThrows<T, E2>(){

            @Override
            public void consume(T subject) throws Throwable {
                delegate.consume(subject);
            }
        };
    }

    public static <T, E1 extends Throwable> ConsumerWhichThrows<T, E1> cast(final Consumer<T> delegate) {
        return new ConsumerWhichThrows<T, E1>(){

            @Override
            public void consume(T subject) {
                delegate.consume(subject);
            }
        };
    }

    public static Writer characterConsumerWriter(final ConsumerWhichThrows<Character, IOException> delegate) {
        return new Writer(){

            public void write(int c) throws IOException {
                delegate.consume(Character.valueOf((char)c));
            }

            public void write(char[] cbuf, int off, int len) throws IOException {
                while (len > 0) {
                    this.write(cbuf[off++]);
                    --len;
                }
            }

            public void flush() {
            }

            public void close() {
            }
        };
    }

    public static <E extends Throwable> ConsumerWhichThrows<Character, E> lines(final ConsumerWhichThrows<String, E> delegate) {
        return new ConsumerWhichThrows<Character, E>(){
            private final StringBuilder sb = new StringBuilder();
            private boolean crPending;

            @Override
            public void consume(Character c) throws Throwable {
                if (c.charValue() == '\r') {
                    delegate.consume(this.sb.toString());
                    this.sb.setLength(0);
                    this.crPending = true;
                } else if (c.charValue() == '\n') {
                    if (this.crPending) {
                        this.crPending = false;
                    } else {
                        delegate.consume(this.sb.toString());
                        this.sb.setLength(0);
                    }
                } else {
                    this.crPending = false;
                    this.sb.append(c);
                }
            }
        };
    }
}

