/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.ftp;

import de.unkrig.commons.lang.RunnableWhichThrows;
import de.unkrig.commons.lang.Stoppable;
import de.unkrig.commons.net.ReverseProxy;
import de.unkrig.commons.net.ftp.DataConnectionProxy;
import de.unkrig.commons.util.ConsumerUtil;
import de.unkrig.commons.util.ConsumerWhichThrows;
import de.unkrig.commons.util.ProducerWhichThrows;
import de.unkrig.commons.util.logging.LogUtil;
import de.unkrig.commons.util.stringstream.LineUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpReverseProxy
implements RunnableWhichThrows<IOException> {
    static final Logger LOGGER = Logger.getLogger(FtpReverseProxy.class.getName());
    private final ReverseProxy reverseProxy;
    static final Pattern RESPONSE = Pattern.compile("(\\d\\d\\d) (.*)");
    static final Pattern BRACKETED_RESPONSE = Pattern.compile("(\\d\\d\\d)-(.*)");
    static final Pattern RESPONSE_227 = Pattern.compile("227 .*\\((\\d+),(\\d+),(\\d+),(\\d+),(\\d+),(\\d+)\\).*");
    static final Pattern RESPONSE_229 = Pattern.compile("229 .*\\(\\|\\|\\|(\\d+)\\|\\).*");
    static final Pattern REQUEST_PORT = Pattern.compile("PORT (\\d+),(\\d+),(\\d+),(\\d+),(\\d+),(\\d+)");
    static final Pattern REQUEST_EPRT = Pattern.compile("EPRT \\|[12]\\|([^\\|]+)\\|(\\d+)\\|");

    public FtpReverseProxy(InetSocketAddress endpoint, int backlog, InetSocketAddress serverAddress, int serverConnectionTimeout) throws IOException {
        this.reverseProxy = new ReverseProxy(endpoint, backlog, serverAddress, Proxy.NO_PROXY, serverConnectionTimeout, new ReverseProxy.ProxyConnectionHandler(){

            public void handleConnection(InputStream clientIn, OutputStream clientOut, InputStream serverIn, OutputStream serverOut, InetSocketAddress clientLocalSocketAddress, InetSocketAddress clientRemoteSocketAddress, InetSocketAddress serverLocalSocketAddress, InetSocketAddress serverRemoteSocketAddress, Stoppable stoppable) throws IOException {
                Connection client = FtpReverseProxy.connection(LineUtil.lineProducerISO8859_1(clientIn), ConsumerUtil.tee(LineUtil.lineConsumerISO8859_1(clientOut), ConsumerUtil.cast(LogUtil.logConsumer(LOGGER, Level.FINE, "<<< "))));
                Connection server = FtpReverseProxy.connection(LineUtil.lineProducerISO8859_1(serverIn), ConsumerUtil.tee(LineUtil.lineConsumerISO8859_1(serverOut), ConsumerUtil.cast(LogUtil.logConsumer(LOGGER, Level.FINE, ">>> "))));
                DataConnectionProxy dataConnectionProxy = new DataConnectionProxy();
                while (true) {
                    int port2;
                    int port;
                    InetAddress address;
                    Matcher m;
                    String response = this.readResponse(server);
                    LOGGER.finer("Response ''" + response + "'' received");
                    if (response == null) {
                        LOGGER.fine("Connection closed by remote server");
                    } else {
                        m = RESPONSE_227.matcher(response);
                        if (m.matches()) {
                            address = InetAddress.getByAddress(new byte[]{(byte)Integer.parseInt(m.group(1)), (byte)Integer.parseInt(m.group(2)), (byte)Integer.parseInt(m.group(3)), (byte)Integer.parseInt(m.group(4))});
                            port = (Integer.parseInt(m.group(5)) << 8) + Integer.parseInt(m.group(6));
                            port2 = dataConnectionProxy.start(clientLocalSocketAddress.getAddress(), new InetSocketAddress(address, port));
                            response = "227 (" + clientLocalSocketAddress.getAddress().getHostAddress().replace('.', ',') + "," + (0xFF & port2 >> 8) + "," + (0xFF & port2) + ")";
                        } else {
                            m = RESPONSE_229.matcher(response);
                            if (m.matches()) {
                                int port3 = Integer.parseInt(m.group(1));
                                int port22 = dataConnectionProxy.start(clientLocalSocketAddress.getAddress(), new InetSocketAddress(serverRemoteSocketAddress.getAddress(), port3));
                                response = "229 Entering Extended Passive Mode (|||" + port22 + "|)";
                            }
                        }
                        client.writeLine(response);
                        if (response.startsWith("1")) continue;
                    }
                    String request = client.readLine();
                    LOGGER.finer("Request ''" + request + "'' received");
                    if (request == null) break;
                    m = REQUEST_PORT.matcher(request);
                    if (m.matches()) {
                        address = InetAddress.getByAddress(new byte[]{(byte)Integer.parseInt(m.group(1)), (byte)Integer.parseInt(m.group(2)), (byte)Integer.parseInt(m.group(3)), (byte)Integer.parseInt(m.group(4))});
                        port = (Integer.parseInt(m.group(5)) << 8) + Integer.parseInt(m.group(6));
                        port2 = dataConnectionProxy.start(serverLocalSocketAddress.getAddress(), new InetSocketAddress(address, port));
                        request = "PORT " + serverLocalSocketAddress.getAddress().getHostAddress().replace('.', ',') + "," + (0xFF & port2 >> 8) + "," + (0xFF & port2);
                    } else {
                        m = REQUEST_EPRT.matcher(request);
                        if (m.matches()) {
                            address = InetAddress.getByName(m.group(1));
                            port = Integer.parseInt(m.group(2));
                            port2 = dataConnectionProxy.start(serverLocalSocketAddress.getAddress(), new InetSocketAddress(address, port));
                            request = "PORT " + serverLocalSocketAddress.getAddress().getHostAddress().replace('.', ',') + "," + (0xFF & port2 >> 8) + "," + (0xFF & port2);
                        }
                    }
                    server.writeLine(request);
                }
            }

            private String readResponse(Connection server) throws IOException {
                String response = server.readLine();
                if (response == null) {
                    return null;
                }
                if (RESPONSE.matcher(response).matches()) {
                    return response;
                }
                if (BRACKETED_RESPONSE.matcher(response).matches()) {
                    String s;
                    do {
                        if ((s = server.readLine()) == null) {
                            throw new IOException("Incomplete bracketed response");
                        }
                        response = String.valueOf(response) + "\r\n" + s;
                    } while (!RESPONSE.matcher(s).matches());
                    return response;
                }
                throw new IOException("Invalid response '" + response + "' received");
            }
        });
    }

    @Override
    public void run() throws IOException {
        this.reverseProxy.run();
    }

    static Connection connection(final ProducerWhichThrows<String, IOException> producer, final ConsumerWhichThrows<String, IOException> consumer) {
        return new Connection(){

            public String readLine() throws IOException {
                return (String)producer.produce();
            }

            public void writeLine(String line) throws IOException {
                consumer.consume(line);
            }
        };
    }

    static interface Connection {
        public String readLine() throws IOException;

        public void writeLine(String var1) throws IOException;
    }
}

