// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package gamesparksiface provides an interface to enable mocking the GameSparks service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package gamesparksiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/gamesparks"
)

// GameSparksAPI provides an interface to enable mocking the
// gamesparks.GameSparks service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// GameSparks.
//	func myFunc(svc gamesparksiface.GameSparksAPI) bool {
//	    // Make svc.CreateGame request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := gamesparks.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockGameSparksClient struct {
//	    gamesparksiface.GameSparksAPI
//	}
//	func (m *mockGameSparksClient) CreateGame(input *gamesparks.CreateGameInput) (*gamesparks.CreateGameOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockGameSparksClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type GameSparksAPI interface {
	CreateGame(*gamesparks.CreateGameInput) (*gamesparks.CreateGameOutput, error)
	CreateGameWithContext(aws.Context, *gamesparks.CreateGameInput, ...request.Option) (*gamesparks.CreateGameOutput, error)
	CreateGameRequest(*gamesparks.CreateGameInput) (*request.Request, *gamesparks.CreateGameOutput)

	CreateSnapshot(*gamesparks.CreateSnapshotInput) (*gamesparks.CreateSnapshotOutput, error)
	CreateSnapshotWithContext(aws.Context, *gamesparks.CreateSnapshotInput, ...request.Option) (*gamesparks.CreateSnapshotOutput, error)
	CreateSnapshotRequest(*gamesparks.CreateSnapshotInput) (*request.Request, *gamesparks.CreateSnapshotOutput)

	CreateStage(*gamesparks.CreateStageInput) (*gamesparks.CreateStageOutput, error)
	CreateStageWithContext(aws.Context, *gamesparks.CreateStageInput, ...request.Option) (*gamesparks.CreateStageOutput, error)
	CreateStageRequest(*gamesparks.CreateStageInput) (*request.Request, *gamesparks.CreateStageOutput)

	DeleteGame(*gamesparks.DeleteGameInput) (*gamesparks.DeleteGameOutput, error)
	DeleteGameWithContext(aws.Context, *gamesparks.DeleteGameInput, ...request.Option) (*gamesparks.DeleteGameOutput, error)
	DeleteGameRequest(*gamesparks.DeleteGameInput) (*request.Request, *gamesparks.DeleteGameOutput)

	DeleteStage(*gamesparks.DeleteStageInput) (*gamesparks.DeleteStageOutput, error)
	DeleteStageWithContext(aws.Context, *gamesparks.DeleteStageInput, ...request.Option) (*gamesparks.DeleteStageOutput, error)
	DeleteStageRequest(*gamesparks.DeleteStageInput) (*request.Request, *gamesparks.DeleteStageOutput)

	DisconnectPlayer(*gamesparks.DisconnectPlayerInput) (*gamesparks.DisconnectPlayerOutput, error)
	DisconnectPlayerWithContext(aws.Context, *gamesparks.DisconnectPlayerInput, ...request.Option) (*gamesparks.DisconnectPlayerOutput, error)
	DisconnectPlayerRequest(*gamesparks.DisconnectPlayerInput) (*request.Request, *gamesparks.DisconnectPlayerOutput)

	ExportSnapshot(*gamesparks.ExportSnapshotInput) (*gamesparks.ExportSnapshotOutput, error)
	ExportSnapshotWithContext(aws.Context, *gamesparks.ExportSnapshotInput, ...request.Option) (*gamesparks.ExportSnapshotOutput, error)
	ExportSnapshotRequest(*gamesparks.ExportSnapshotInput) (*request.Request, *gamesparks.ExportSnapshotOutput)

	GetExtension(*gamesparks.GetExtensionInput) (*gamesparks.GetExtensionOutput, error)
	GetExtensionWithContext(aws.Context, *gamesparks.GetExtensionInput, ...request.Option) (*gamesparks.GetExtensionOutput, error)
	GetExtensionRequest(*gamesparks.GetExtensionInput) (*request.Request, *gamesparks.GetExtensionOutput)

	GetExtensionVersion(*gamesparks.GetExtensionVersionInput) (*gamesparks.GetExtensionVersionOutput, error)
	GetExtensionVersionWithContext(aws.Context, *gamesparks.GetExtensionVersionInput, ...request.Option) (*gamesparks.GetExtensionVersionOutput, error)
	GetExtensionVersionRequest(*gamesparks.GetExtensionVersionInput) (*request.Request, *gamesparks.GetExtensionVersionOutput)

	GetGame(*gamesparks.GetGameInput) (*gamesparks.GetGameOutput, error)
	GetGameWithContext(aws.Context, *gamesparks.GetGameInput, ...request.Option) (*gamesparks.GetGameOutput, error)
	GetGameRequest(*gamesparks.GetGameInput) (*request.Request, *gamesparks.GetGameOutput)

	GetGameConfiguration(*gamesparks.GetGameConfigurationInput) (*gamesparks.GetGameConfigurationOutput, error)
	GetGameConfigurationWithContext(aws.Context, *gamesparks.GetGameConfigurationInput, ...request.Option) (*gamesparks.GetGameConfigurationOutput, error)
	GetGameConfigurationRequest(*gamesparks.GetGameConfigurationInput) (*request.Request, *gamesparks.GetGameConfigurationOutput)

	GetGeneratedCodeJob(*gamesparks.GetGeneratedCodeJobInput) (*gamesparks.GetGeneratedCodeJobOutput, error)
	GetGeneratedCodeJobWithContext(aws.Context, *gamesparks.GetGeneratedCodeJobInput, ...request.Option) (*gamesparks.GetGeneratedCodeJobOutput, error)
	GetGeneratedCodeJobRequest(*gamesparks.GetGeneratedCodeJobInput) (*request.Request, *gamesparks.GetGeneratedCodeJobOutput)

	GetPlayerConnectionStatus(*gamesparks.GetPlayerConnectionStatusInput) (*gamesparks.GetPlayerConnectionStatusOutput, error)
	GetPlayerConnectionStatusWithContext(aws.Context, *gamesparks.GetPlayerConnectionStatusInput, ...request.Option) (*gamesparks.GetPlayerConnectionStatusOutput, error)
	GetPlayerConnectionStatusRequest(*gamesparks.GetPlayerConnectionStatusInput) (*request.Request, *gamesparks.GetPlayerConnectionStatusOutput)

	GetSnapshot(*gamesparks.GetSnapshotInput) (*gamesparks.GetSnapshotOutput, error)
	GetSnapshotWithContext(aws.Context, *gamesparks.GetSnapshotInput, ...request.Option) (*gamesparks.GetSnapshotOutput, error)
	GetSnapshotRequest(*gamesparks.GetSnapshotInput) (*request.Request, *gamesparks.GetSnapshotOutput)

	GetStage(*gamesparks.GetStageInput) (*gamesparks.GetStageOutput, error)
	GetStageWithContext(aws.Context, *gamesparks.GetStageInput, ...request.Option) (*gamesparks.GetStageOutput, error)
	GetStageRequest(*gamesparks.GetStageInput) (*request.Request, *gamesparks.GetStageOutput)

	GetStageDeployment(*gamesparks.GetStageDeploymentInput) (*gamesparks.GetStageDeploymentOutput, error)
	GetStageDeploymentWithContext(aws.Context, *gamesparks.GetStageDeploymentInput, ...request.Option) (*gamesparks.GetStageDeploymentOutput, error)
	GetStageDeploymentRequest(*gamesparks.GetStageDeploymentInput) (*request.Request, *gamesparks.GetStageDeploymentOutput)

	ImportGameConfiguration(*gamesparks.ImportGameConfigurationInput) (*gamesparks.ImportGameConfigurationOutput, error)
	ImportGameConfigurationWithContext(aws.Context, *gamesparks.ImportGameConfigurationInput, ...request.Option) (*gamesparks.ImportGameConfigurationOutput, error)
	ImportGameConfigurationRequest(*gamesparks.ImportGameConfigurationInput) (*request.Request, *gamesparks.ImportGameConfigurationOutput)

	ListExtensionVersions(*gamesparks.ListExtensionVersionsInput) (*gamesparks.ListExtensionVersionsOutput, error)
	ListExtensionVersionsWithContext(aws.Context, *gamesparks.ListExtensionVersionsInput, ...request.Option) (*gamesparks.ListExtensionVersionsOutput, error)
	ListExtensionVersionsRequest(*gamesparks.ListExtensionVersionsInput) (*request.Request, *gamesparks.ListExtensionVersionsOutput)

	ListExtensionVersionsPages(*gamesparks.ListExtensionVersionsInput, func(*gamesparks.ListExtensionVersionsOutput, bool) bool) error
	ListExtensionVersionsPagesWithContext(aws.Context, *gamesparks.ListExtensionVersionsInput, func(*gamesparks.ListExtensionVersionsOutput, bool) bool, ...request.Option) error

	ListExtensions(*gamesparks.ListExtensionsInput) (*gamesparks.ListExtensionsOutput, error)
	ListExtensionsWithContext(aws.Context, *gamesparks.ListExtensionsInput, ...request.Option) (*gamesparks.ListExtensionsOutput, error)
	ListExtensionsRequest(*gamesparks.ListExtensionsInput) (*request.Request, *gamesparks.ListExtensionsOutput)

	ListExtensionsPages(*gamesparks.ListExtensionsInput, func(*gamesparks.ListExtensionsOutput, bool) bool) error
	ListExtensionsPagesWithContext(aws.Context, *gamesparks.ListExtensionsInput, func(*gamesparks.ListExtensionsOutput, bool) bool, ...request.Option) error

	ListGames(*gamesparks.ListGamesInput) (*gamesparks.ListGamesOutput, error)
	ListGamesWithContext(aws.Context, *gamesparks.ListGamesInput, ...request.Option) (*gamesparks.ListGamesOutput, error)
	ListGamesRequest(*gamesparks.ListGamesInput) (*request.Request, *gamesparks.ListGamesOutput)

	ListGamesPages(*gamesparks.ListGamesInput, func(*gamesparks.ListGamesOutput, bool) bool) error
	ListGamesPagesWithContext(aws.Context, *gamesparks.ListGamesInput, func(*gamesparks.ListGamesOutput, bool) bool, ...request.Option) error

	ListGeneratedCodeJobs(*gamesparks.ListGeneratedCodeJobsInput) (*gamesparks.ListGeneratedCodeJobsOutput, error)
	ListGeneratedCodeJobsWithContext(aws.Context, *gamesparks.ListGeneratedCodeJobsInput, ...request.Option) (*gamesparks.ListGeneratedCodeJobsOutput, error)
	ListGeneratedCodeJobsRequest(*gamesparks.ListGeneratedCodeJobsInput) (*request.Request, *gamesparks.ListGeneratedCodeJobsOutput)

	ListGeneratedCodeJobsPages(*gamesparks.ListGeneratedCodeJobsInput, func(*gamesparks.ListGeneratedCodeJobsOutput, bool) bool) error
	ListGeneratedCodeJobsPagesWithContext(aws.Context, *gamesparks.ListGeneratedCodeJobsInput, func(*gamesparks.ListGeneratedCodeJobsOutput, bool) bool, ...request.Option) error

	ListSnapshots(*gamesparks.ListSnapshotsInput) (*gamesparks.ListSnapshotsOutput, error)
	ListSnapshotsWithContext(aws.Context, *gamesparks.ListSnapshotsInput, ...request.Option) (*gamesparks.ListSnapshotsOutput, error)
	ListSnapshotsRequest(*gamesparks.ListSnapshotsInput) (*request.Request, *gamesparks.ListSnapshotsOutput)

	ListSnapshotsPages(*gamesparks.ListSnapshotsInput, func(*gamesparks.ListSnapshotsOutput, bool) bool) error
	ListSnapshotsPagesWithContext(aws.Context, *gamesparks.ListSnapshotsInput, func(*gamesparks.ListSnapshotsOutput, bool) bool, ...request.Option) error

	ListStageDeployments(*gamesparks.ListStageDeploymentsInput) (*gamesparks.ListStageDeploymentsOutput, error)
	ListStageDeploymentsWithContext(aws.Context, *gamesparks.ListStageDeploymentsInput, ...request.Option) (*gamesparks.ListStageDeploymentsOutput, error)
	ListStageDeploymentsRequest(*gamesparks.ListStageDeploymentsInput) (*request.Request, *gamesparks.ListStageDeploymentsOutput)

	ListStageDeploymentsPages(*gamesparks.ListStageDeploymentsInput, func(*gamesparks.ListStageDeploymentsOutput, bool) bool) error
	ListStageDeploymentsPagesWithContext(aws.Context, *gamesparks.ListStageDeploymentsInput, func(*gamesparks.ListStageDeploymentsOutput, bool) bool, ...request.Option) error

	ListStages(*gamesparks.ListStagesInput) (*gamesparks.ListStagesOutput, error)
	ListStagesWithContext(aws.Context, *gamesparks.ListStagesInput, ...request.Option) (*gamesparks.ListStagesOutput, error)
	ListStagesRequest(*gamesparks.ListStagesInput) (*request.Request, *gamesparks.ListStagesOutput)

	ListStagesPages(*gamesparks.ListStagesInput, func(*gamesparks.ListStagesOutput, bool) bool) error
	ListStagesPagesWithContext(aws.Context, *gamesparks.ListStagesInput, func(*gamesparks.ListStagesOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*gamesparks.ListTagsForResourceInput) (*gamesparks.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *gamesparks.ListTagsForResourceInput, ...request.Option) (*gamesparks.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*gamesparks.ListTagsForResourceInput) (*request.Request, *gamesparks.ListTagsForResourceOutput)

	StartGeneratedCodeJob(*gamesparks.StartGeneratedCodeJobInput) (*gamesparks.StartGeneratedCodeJobOutput, error)
	StartGeneratedCodeJobWithContext(aws.Context, *gamesparks.StartGeneratedCodeJobInput, ...request.Option) (*gamesparks.StartGeneratedCodeJobOutput, error)
	StartGeneratedCodeJobRequest(*gamesparks.StartGeneratedCodeJobInput) (*request.Request, *gamesparks.StartGeneratedCodeJobOutput)

	StartStageDeployment(*gamesparks.StartStageDeploymentInput) (*gamesparks.StartStageDeploymentOutput, error)
	StartStageDeploymentWithContext(aws.Context, *gamesparks.StartStageDeploymentInput, ...request.Option) (*gamesparks.StartStageDeploymentOutput, error)
	StartStageDeploymentRequest(*gamesparks.StartStageDeploymentInput) (*request.Request, *gamesparks.StartStageDeploymentOutput)

	TagResource(*gamesparks.TagResourceInput) (*gamesparks.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *gamesparks.TagResourceInput, ...request.Option) (*gamesparks.TagResourceOutput, error)
	TagResourceRequest(*gamesparks.TagResourceInput) (*request.Request, *gamesparks.TagResourceOutput)

	UntagResource(*gamesparks.UntagResourceInput) (*gamesparks.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *gamesparks.UntagResourceInput, ...request.Option) (*gamesparks.UntagResourceOutput, error)
	UntagResourceRequest(*gamesparks.UntagResourceInput) (*request.Request, *gamesparks.UntagResourceOutput)

	UpdateGame(*gamesparks.UpdateGameInput) (*gamesparks.UpdateGameOutput, error)
	UpdateGameWithContext(aws.Context, *gamesparks.UpdateGameInput, ...request.Option) (*gamesparks.UpdateGameOutput, error)
	UpdateGameRequest(*gamesparks.UpdateGameInput) (*request.Request, *gamesparks.UpdateGameOutput)

	UpdateGameConfiguration(*gamesparks.UpdateGameConfigurationInput) (*gamesparks.UpdateGameConfigurationOutput, error)
	UpdateGameConfigurationWithContext(aws.Context, *gamesparks.UpdateGameConfigurationInput, ...request.Option) (*gamesparks.UpdateGameConfigurationOutput, error)
	UpdateGameConfigurationRequest(*gamesparks.UpdateGameConfigurationInput) (*request.Request, *gamesparks.UpdateGameConfigurationOutput)

	UpdateSnapshot(*gamesparks.UpdateSnapshotInput) (*gamesparks.UpdateSnapshotOutput, error)
	UpdateSnapshotWithContext(aws.Context, *gamesparks.UpdateSnapshotInput, ...request.Option) (*gamesparks.UpdateSnapshotOutput, error)
	UpdateSnapshotRequest(*gamesparks.UpdateSnapshotInput) (*request.Request, *gamesparks.UpdateSnapshotOutput)

	UpdateStage(*gamesparks.UpdateStageInput) (*gamesparks.UpdateStageOutput, error)
	UpdateStageWithContext(aws.Context, *gamesparks.UpdateStageInput, ...request.Option) (*gamesparks.UpdateStageOutput, error)
	UpdateStageRequest(*gamesparks.UpdateStageInput) (*request.Request, *gamesparks.UpdateStageOutput)
}

var _ GameSparksAPI = (*gamesparks.GameSparks)(nil)
