# frozen_string_literal: true

require_relative "lib/multipart/post/version"

Gem::Specification.new do |spec|
	spec.name = "multipart-post"
	spec.version = Multipart::Post::VERSION
	
	spec.summary = "A multipart form post accessory for Net::HTTP."
	spec.authors = ["Nick Sieger", "Samuel Williams", "Olle Jonsson", "McClain Looney", "Lewis Cowles", "Gustav Ernberg", "Patrick Davey", "Steven Davidovitz", "Alex Koppel", "Ethan Turkeltaub", "Jagtesh Chadha", "Jason York", "Tohru Hashimoto", "Vincent Pellé", "hexfet", "Christine Yen", "David Moles", "Eric Hutzelman", "Feuda Nan", "Gerrit Riessen", "Jan Piotrowski", "Jan-Joost Spanjers", "Jason Moore", "Jeff Hodges", "Johannes Wagener", "Jordi Massaguer Pla", "Lachlan Priest", "Leo Cassarani", "Lonre Wang", "Luke Redpath", "Masato Nakamura", "Matt Colyer", "Mislav Marohnić", "Peter Goldstein", "Socrates Vicente", "Steffen Grunwald", "Takuya Noguchi", "Tim Barkley"]
	spec.license = "MIT"
	
	spec.cert_chain  = ['release.cert']
	spec.signing_key = File.expand_path('~/.gem/release.pem')
	
	spec.homepage = "https://github.com/socketry/multipart-post"
	
	spec.metadata = {
		"documentation_uri" => "https://socketry.github.io/multipart-post/",
		"source_code_uri" => "https://github.com/socketry/multipart-post.git",
	}
	
	spec.files = Dir['{lib}/**/*', '*.md', base: __dir__]
	
	spec.required_ruby_version = ">= 2.5.0"
end
