/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.sql.Datum;
import oracle.sql.TypeDescriptor;

public abstract class DatumWithConnection
extends Datum {
    private oracle.jdbc.internal.OracleConnection physicalConnection = null;

    oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        if (this.physicalConnection == null) {
            try {
                this.physicalConnection = (oracle.jdbc.internal.OracleConnection)new OracleDriver().defaultConnection();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.physicalConnection;
    }

    public DatumWithConnection(byte[] byArray) throws SQLException {
        super(byArray);
    }

    public DatumWithConnection() {
    }

    public static void assertNotNull(Connection connection) throws SQLException {
        if (connection == null) {
            DBError.check_error(68, "Connection is null");
        }
    }

    public static void assertNotNull(TypeDescriptor typeDescriptor) throws SQLException {
        if (typeDescriptor == null) {
            DBError.check_error(61);
        }
    }

    public void setPhysicalConnectionOf(Connection connection) {
        this.physicalConnection = OracleConnection.physicalConnectionWithin(connection);
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return this.getPhysicalConnection().getWrapper();
    }

    public oracle.jdbc.OracleConnection getOracleConnection() throws SQLException {
        return this.getPhysicalConnection().getWrapper();
    }

    public oracle.jdbc.internal.OracleConnection getInternalConnection() throws SQLException {
        return this.getPhysicalConnection();
    }

    public OracleConnection getConnection() throws SQLException {
        OracleConnection oracleConnection = null;
        try {
            oracleConnection = (OracleConnection)this.physicalConnection;
        }
        catch (ClassCastException classCastException) {
            DBError.throwSqlException(103);
        }
        return oracleConnection;
    }
}

