/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.stat;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.properties.DoubleProperty;
import net.sourceforge.pmd.properties.IntegerProperty;
import net.sourceforge.pmd.stat.DataPoint;
import net.sourceforge.pmd.stat.Metric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StatisticalRule
extends AbstractRule {
    public static final double DELTA = 5.0E-6;
    private SortedSet<DataPoint> dataPoints = new TreeSet<DataPoint>();
    private int count = 0;
    private double total = 0.0;
    private static final PropertyDescriptor sigmaDescriptor = new DoubleProperty("sigma", "Sigma value", 0.0, 1.0f);
    private static final PropertyDescriptor minimumDescriptor = new DoubleProperty("minimum", "Minimum value", 0.0, 1.0f);
    private static final PropertyDescriptor topScoreDescriptor = new IntegerProperty("topscore", "Top score value", 0, 1.0f);
    private static final Map<String, PropertyDescriptor> propertyDescriptorsByName = StatisticalRule.asFixedMap(new PropertyDescriptor[]{sigmaDescriptor, minimumDescriptor, topScoreDescriptor});

    public void addDataPoint(DataPoint point) {
        ++this.count;
        this.total += point.getScore();
        this.dataPoints.add(point);
    }

    @Override
    public void apply(List acus, RuleContext ctx) {
        double mMin;
        this.visitAll(acus, ctx);
        double minimum = 0.0;
        if (this.hasProperty("sigma")) {
            double deviation = this.getStdDev();
            double sigma = this.getDoubleProperty(sigmaDescriptor);
            minimum = this.getMean() + sigma * deviation;
        }
        if (this.hasProperty("minimum") && (mMin = this.getDoubleProperty(minimumDescriptor)) > minimum) {
            minimum = mMin;
        }
        SortedSet<DataPoint> newPoints = this.applyMinimumValue(this.dataPoints, minimum);
        if (this.hasProperty("topscore")) {
            int topScore = this.getIntProperty(topScoreDescriptor);
            if (newPoints.size() >= topScore) {
                newPoints = this.applyTopScore(newPoints, topScore);
            }
        }
        this.makeViolations(ctx, newPoints);
        double low = 0.0;
        double high = 0.0;
        if (!this.dataPoints.isEmpty()) {
            low = this.dataPoints.first().getScore();
            high = this.dataPoints.last().getScore();
        }
        ctx.getReport().addMetric(new Metric(this.getName(), this.count, this.total, low, high, this.getMean(), this.getStdDev()));
        this.dataPoints.clear();
    }

    protected double getMean() {
        return this.total / (double)this.count;
    }

    protected double getStdDev() {
        if (this.dataPoints.size() < 2) {
            return Double.NaN;
        }
        double mean = this.getMean();
        double deltaSq = 0.0;
        for (DataPoint point : this.dataPoints) {
            double scoreMinusMean = point.getScore() - mean;
            deltaSq += scoreMinusMean * scoreMinusMean;
        }
        return Math.sqrt(deltaSq / (double)(this.dataPoints.size() - 1));
    }

    protected SortedSet<DataPoint> applyMinimumValue(SortedSet<DataPoint> pointSet, double minValue) {
        TreeSet<DataPoint> RC = new TreeSet<DataPoint>();
        double threshold = minValue - 5.0E-6;
        for (DataPoint point : pointSet) {
            if (!(point.getScore() > threshold)) continue;
            RC.add(point);
        }
        return RC;
    }

    protected SortedSet<DataPoint> applyTopScore(SortedSet<DataPoint> points, int topScore) {
        TreeSet<DataPoint> s = new TreeSet<DataPoint>();
        DataPoint[] arr = points.toArray(new DataPoint[0]);
        for (int i = arr.length - 1; i >= arr.length - topScore; --i) {
            s.add(arr[i]);
        }
        return s;
    }

    protected void makeViolations(RuleContext ctx, Set<DataPoint> p) {
        for (DataPoint point : p) {
            this.addViolationWithMessage(ctx, point.getNode(), point.getMessage());
        }
    }

    @Override
    protected Map<String, PropertyDescriptor> propertiesByName() {
        return propertyDescriptorsByName;
    }
}

