/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.strings;

import java.util.List;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.ast.ASTAllocationExpression;
import net.sourceforge.pmd.ast.ASTArgumentList;
import net.sourceforge.pmd.ast.ASTBlockStatement;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTStatementExpression;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;

public class InefficientStringBuffering
extends AbstractRule {
    public Object visit(ASTAdditiveExpression node, Object data) {
        ASTBlockStatement bs = node.getFirstParentOfType(ASTBlockStatement.class);
        if (bs == null) {
            return data;
        }
        int immediateLiterals = 0;
        List<ASTLiteral> nodes = node.findChildrenOfType(ASTLiteral.class);
        for (ASTLiteral literal : nodes) {
            if (literal.jjtGetParent().jjtGetParent().jjtGetParent() instanceof ASTAdditiveExpression) {
                ++immediateLiterals;
            }
            try {
                Integer.parseInt(literal.getImage());
                return data;
            }
            catch (NumberFormatException nfe) {
            }
        }
        if (immediateLiterals > 1) {
            return data;
        }
        List<ASTName> nameNodes = node.findChildrenOfType(ASTName.class);
        for (ASTName name : nameNodes) {
            VariableNameDeclaration vnd;
            if (!(name.getNameDeclaration() instanceof VariableNameDeclaration) || !(vnd = (VariableNameDeclaration)name.getNameDeclaration()).getAccessNodeParent().isFinal() || !vnd.getAccessNodeParent().isStatic()) continue;
            return data;
        }
        if (bs.isAllocation()) {
            if (this.isAllocatedStringBuffer(node)) {
                this.addViolation(data, node);
            }
        } else if (InefficientStringBuffering.isInStringBufferOperation(node, 6, "append")) {
            this.addViolation(data, node);
        }
        return data;
    }

    protected static boolean isInStringBufferOperation(SimpleNode node, int length, String methodName) {
        if (!InefficientStringBuffering.xParentIsStatementExpression(node, length)) {
            return false;
        }
        ASTStatementExpression s = node.getFirstParentOfType(ASTStatementExpression.class);
        if (s == null) {
            return false;
        }
        ASTName n = s.getFirstChildOfType(ASTName.class);
        if (n == null || n.getImage().indexOf(methodName) == -1 || !(n.getNameDeclaration() instanceof VariableNameDeclaration)) {
            return false;
        }
        ASTArgumentList argList = s.getFirstChildOfType(ASTArgumentList.class);
        if (argList == null || argList.jjtGetNumChildren() > 1) {
            return false;
        }
        return ((VariableNameDeclaration)n.getNameDeclaration()).getTypeImage().equals("StringBuffer");
    }

    private static boolean xParentIsStatementExpression(SimpleNode node, int length) {
        Node curr = node;
        for (int i = 0; i < length; ++i) {
            if (node.jjtGetParent() == null) {
                return false;
            }
            curr = curr.jjtGetParent();
        }
        return curr instanceof ASTStatementExpression;
    }

    private boolean isAllocatedStringBuffer(ASTAdditiveExpression node) {
        ASTAllocationExpression ao = node.getFirstParentOfType(ASTAllocationExpression.class);
        if (ao == null) {
            return false;
        }
        ASTClassOrInterfaceType an = ao.getFirstChildOfType(ASTClassOrInterfaceType.class);
        return an != null && (an.getImage().endsWith("StringBuffer") || an.getImage().endsWith("StringBuilder"));
    }
}

