/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.junit;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTArguments;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;

public class JUnitAssertionsShouldIncludeMessage
extends AbstractRule {
    private List<AssertionCall> checks = new ArrayList<AssertionCall>();

    public JUnitAssertionsShouldIncludeMessage() {
        this.checks.add(new AssertionCall(2, "assertEquals"));
        this.checks.add(new AssertionCall(1, "assertTrue"));
        this.checks.add(new AssertionCall(1, "assertNull"));
        this.checks.add(new AssertionCall(2, "assertSame"));
        this.checks.add(new AssertionCall(1, "assertNotNull"));
        this.checks.add(new AssertionCall(1, "assertFalse"));
    }

    public Object visit(ASTArguments node, Object data) {
        for (AssertionCall call : this.checks) {
            this.check(data, node, call.args, call.name);
        }
        return super.visit(node, data);
    }

    private void check(Object ctx, ASTArguments node, int args, String targetMethodName) {
        ASTName name;
        ASTPrimaryExpression primary;
        if (node.getArgumentCount() == args && node.jjtGetParent().jjtGetParent() instanceof ASTPrimaryExpression && (primary = (ASTPrimaryExpression)node.jjtGetParent().jjtGetParent()).jjtGetChild(0) instanceof ASTPrimaryPrefix && primary.jjtGetChild(0).jjtGetNumChildren() > 0 && primary.jjtGetChild(0).jjtGetChild(0) instanceof ASTName && (name = (ASTName)primary.jjtGetChild(0).jjtGetChild(0)).hasImageEqualTo(targetMethodName)) {
            this.addViolation(ctx, name);
        }
    }

    private static class AssertionCall {
        public int args;
        public String name;

        public AssertionCall(int args, String name) {
            this.args = args;
            this.name = name;
        }
    }
}

