/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.base.transform;

import java.sql.SQLException;
import org.dbuml.base.database.DBMetadata;
import org.dbuml.base.model.DBModelFacade;
import org.dbuml.base.model.Database;
import org.dbuml.base.model.Schema;
import org.dbuml.base.model.Table;
import org.dbuml.base.model.View;
import org.dbuml.base.transform.DBMetadataToDBUML;

public class GenericDBMetadataToDBUML
extends DBMetadataToDBUML {
    public Table table(String name, Schema schema, DBMetadata dbmd) throws SQLException {
        Table table = dbmd.getTable(name, schema.getName());
        DBModelFacade.getInstance().addTable(table, schema.getModelElement());
        return table;
    }

    public View view(String name, Schema schema, DBMetadata dbmd) throws SQLException {
        View view = dbmd.getView(name, schema.getName());
        DBModelFacade.getInstance().addView(view, schema.getModelElement());
        return view;
    }

    public void updateTable(Object objTable, String schemaName, DBMetadata dbmd) throws SQLException {
        Table table = dbmd.getTable(DBModelFacade.getInstance().getName(objTable), schemaName);
        table.setModelElement(objTable);
        DBModelFacade.getInstance().updateTable(table);
    }

    public void updateView(Object objTable, String schemaName, DBMetadata dbmd) throws SQLException {
        View view = dbmd.getView(DBModelFacade.getInstance().getName(objTable), schemaName);
        view.setModelElement(objTable);
        DBModelFacade.getInstance().updateView(view);
    }

    public Schema schema(Object owner, String name, DBMetadata dbmd) {
        Schema schema = new Schema(name);
        DBModelFacade.getInstance().addSchema(schema, owner);
        return schema;
    }

    public void updateSchema(Object model) {
        Schema schema = new Schema(DBModelFacade.getInstance().getName(model));
        schema.setModelElement(model);
        DBModelFacade.getInstance().updateSchema(schema);
    }

    public Database database(Object owner, String name, DBMetadata dbmd) throws Exception {
        Database database = dbmd.getDatabase(name);
        DBModelFacade.getInstance().addDatabase(database, owner);
        return database;
    }

    public void updateDatabase(Object model, DBMetadata dbmd) throws Exception {
        Database database = dbmd.getDatabase(DBModelFacade.getInstance().getName(model));
        database.setModelElement(model);
        DBModelFacade.getInstance().updateDatabase(database);
    }
}

