/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.argo.ui.explorer;

import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.argouml.ui.ProjectBrowser;
import org.argouml.ui.explorer.DnDExplorerTree;
import org.argouml.ui.targetmanager.TargetManager;
import org.dbuml.argo.ui.explorer.DBExplorerPopup;
import org.dbuml.argo.uml.ui.DBUMLTreeCellRenderer;

public class ExplorerTree
extends DnDExplorerTree {
    public ExplorerTree() {
        this.addMouseListener(new ExplorerMouseListener((JTree)((Object)this)));
        this.setCellRenderer((TreeCellRenderer)((Object)new DBUMLTreeCellRenderer()));
    }

    class ExplorerMouseListener
    extends MouseAdapter {
        private JTree mLTree;

        public ExplorerMouseListener(JTree newtree) {
            this.mLTree = newtree;
        }

        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                me.consume();
                this.showPopupMenu(me);
            }
        }

        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                me.consume();
                this.showPopupMenu(me);
            }
        }

        public void mouseClicked(MouseEvent me) {
            if (me.isPopupTrigger()) {
                me.consume();
                this.showPopupMenu(me);
            }
            if (me.getClickCount() >= 2) {
                this.myDoubleClick();
            }
        }

        private void myDoubleClick() {
            Object target = TargetManager.getInstance().getTarget();
            if (target != null) {
                Vector<Object> show = new Vector<Object>();
                show.add(target);
                ProjectBrowser.getInstance().jumpToDiagramShowing(show);
            }
        }

        public void showPopupMenu(MouseEvent me) {
            Object selectedItem;
            DBExplorerPopup popup;
            TreePath path = ExplorerTree.this.getPathForLocation(me.getX(), me.getY());
            if (path == null) {
                return;
            }
            if (!ExplorerTree.this.isPathSelected(path)) {
                ExplorerTree.this.getSelectionModel().setSelectionPath(path);
            }
            if (((Container)((Object)(popup = new DBExplorerPopup(selectedItem = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject(), me)))).getComponentCount() > 0) {
                ((JPopupMenu)((Object)popup)).show(this.mLTree, me.getX(), me.getY());
            }
        }
    }
}

