package waf_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeProtectionModuleCodeConfig invokes the waf_openapi.DescribeProtectionModuleCodeConfig API synchronously
func (client *Client) DescribeProtectionModuleCodeConfig(request *DescribeProtectionModuleCodeConfigRequest) (response *DescribeProtectionModuleCodeConfigResponse, err error) {
	response = CreateDescribeProtectionModuleCodeConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeProtectionModuleCodeConfigWithChan invokes the waf_openapi.DescribeProtectionModuleCodeConfig API asynchronously
func (client *Client) DescribeProtectionModuleCodeConfigWithChan(request *DescribeProtectionModuleCodeConfigRequest) (<-chan *DescribeProtectionModuleCodeConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeProtectionModuleCodeConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeProtectionModuleCodeConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeProtectionModuleCodeConfigWithCallback invokes the waf_openapi.DescribeProtectionModuleCodeConfig API asynchronously
func (client *Client) DescribeProtectionModuleCodeConfigWithCallback(request *DescribeProtectionModuleCodeConfigRequest, callback func(response *DescribeProtectionModuleCodeConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeProtectionModuleCodeConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeProtectionModuleCodeConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeProtectionModuleCodeConfigRequest is the request struct for api DescribeProtectionModuleCodeConfig
type DescribeProtectionModuleCodeConfigRequest struct {
	*requests.RpcRequest
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	Lang            string           `position:"Query" name:"Lang"`
	CodeValue       requests.Integer `position:"Query" name:"CodeValue"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	CodeType        requests.Integer `position:"Query" name:"CodeType"`
}

// DescribeProtectionModuleCodeConfigResponse is the response struct for api DescribeProtectionModuleCodeConfig
type DescribeProtectionModuleCodeConfigResponse struct {
	*responses.BaseResponse
	CodeConfigs string `json:"CodeConfigs" xml:"CodeConfigs"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeProtectionModuleCodeConfigRequest creates a request to invoke DescribeProtectionModuleCodeConfig API
func CreateDescribeProtectionModuleCodeConfigRequest() (request *DescribeProtectionModuleCodeConfigRequest) {
	request = &DescribeProtectionModuleCodeConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("waf-openapi", "2019-09-10", "DescribeProtectionModuleCodeConfig", "waf", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeProtectionModuleCodeConfigResponse creates a response to parse from DescribeProtectionModuleCodeConfig response
func CreateDescribeProtectionModuleCodeConfigResponse() (response *DescribeProtectionModuleCodeConfigResponse) {
	response = &DescribeProtectionModuleCodeConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
