package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloneFlowJob invokes the emr.CloneFlowJob API synchronously
func (client *Client) CloneFlowJob(request *CloneFlowJobRequest) (response *CloneFlowJobResponse, err error) {
	response = CreateCloneFlowJobResponse()
	err = client.DoAction(request, response)
	return
}

// CloneFlowJobWithChan invokes the emr.CloneFlowJob API asynchronously
func (client *Client) CloneFlowJobWithChan(request *CloneFlowJobRequest) (<-chan *CloneFlowJobResponse, <-chan error) {
	responseChan := make(chan *CloneFlowJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloneFlowJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloneFlowJobWithCallback invokes the emr.CloneFlowJob API asynchronously
func (client *Client) CloneFlowJobWithCallback(request *CloneFlowJobRequest, callback func(response *CloneFlowJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloneFlowJobResponse
		var err error
		defer close(result)
		response, err = client.CloneFlowJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloneFlowJobRequest is the request struct for api CloneFlowJob
type CloneFlowJobRequest struct {
	*requests.RpcRequest
	Name      string `position:"Query" name:"Name"`
	Id        string `position:"Query" name:"Id"`
	ProjectId string `position:"Query" name:"ProjectId"`
}

// CloneFlowJobResponse is the response struct for api CloneFlowJob
type CloneFlowJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateCloneFlowJobRequest creates a request to invoke CloneFlowJob API
func CreateCloneFlowJobRequest() (request *CloneFlowJobRequest) {
	request = &CloneFlowJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CloneFlowJob", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCloneFlowJobResponse creates a response to parse from CloneFlowJob response
func CreateCloneFlowJobResponse() (response *CloneFlowJobResponse) {
	response = &CloneFlowJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
