package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveWebRtcInfo invokes the ccc.SaveWebRtcInfo API synchronously
func (client *Client) SaveWebRtcInfo(request *SaveWebRtcInfoRequest) (response *SaveWebRtcInfoResponse, err error) {
	response = CreateSaveWebRtcInfoResponse()
	err = client.DoAction(request, response)
	return
}

// SaveWebRtcInfoWithChan invokes the ccc.SaveWebRtcInfo API asynchronously
func (client *Client) SaveWebRtcInfoWithChan(request *SaveWebRtcInfoRequest) (<-chan *SaveWebRtcInfoResponse, <-chan error) {
	responseChan := make(chan *SaveWebRtcInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveWebRtcInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveWebRtcInfoWithCallback invokes the ccc.SaveWebRtcInfo API asynchronously
func (client *Client) SaveWebRtcInfoWithCallback(request *SaveWebRtcInfoRequest, callback func(response *SaveWebRtcInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveWebRtcInfoResponse
		var err error
		defer close(result)
		response, err = client.SaveWebRtcInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveWebRtcInfoRequest is the request struct for api SaveWebRtcInfo
type SaveWebRtcInfoRequest struct {
	*requests.RpcRequest
	CallId      string `position:"Query" name:"CallId"`
	Content     string `position:"Query" name:"Content"`
	ContentType string `position:"Query" name:"ContentType"`
	JobId       string `position:"Query" name:"JobId"`
	InstanceId  string `position:"Query" name:"InstanceId"`
}

// SaveWebRtcInfoResponse is the response struct for api SaveWebRtcInfo
type SaveWebRtcInfoResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int64  `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	RowCount       int64  `json:"RowCount" xml:"RowCount"`
	Success        bool   `json:"Success" xml:"Success"`
	TimeStamp      int64  `json:"TimeStamp" xml:"TimeStamp"`
}

// CreateSaveWebRtcInfoRequest creates a request to invoke SaveWebRtcInfo API
func CreateSaveWebRtcInfoRequest() (request *SaveWebRtcInfoRequest) {
	request = &SaveWebRtcInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "SaveWebRtcInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateSaveWebRtcInfoResponse creates a response to parse from SaveWebRtcInfo response
func CreateSaveWebRtcInfoResponse() (response *SaveWebRtcInfoResponse) {
	response = &SaveWebRtcInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
