package softwareplanapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/softwareplan/mgmt/2019-06-01-preview/softwareplan"
	"github.com/Azure/go-autorest/autorest"
)

// ClientAPI contains the set of methods on the Client type.
type ClientAPI interface {
	Register(ctx context.Context) (result autorest.Response, err error)
}

var _ ClientAPI = (*softwareplan.Client)(nil)

// HybridUseBenefitClientAPI contains the set of methods on the HybridUseBenefitClient type.
type HybridUseBenefitClientAPI interface {
	Create(ctx context.Context, scope string, planID string, body softwareplan.HybridUseBenefitModel) (result softwareplan.HybridUseBenefitModel, err error)
	Delete(ctx context.Context, scope string, planID string) (result autorest.Response, err error)
	Get(ctx context.Context, scope string, planID string) (result softwareplan.HybridUseBenefitModel, err error)
	List(ctx context.Context, scope string, filter string) (result softwareplan.HybridUseBenefitListResultPage, err error)
	ListComplete(ctx context.Context, scope string, filter string) (result softwareplan.HybridUseBenefitListResultIterator, err error)
	Update(ctx context.Context, scope string, planID string, body softwareplan.HybridUseBenefitModel) (result softwareplan.HybridUseBenefitModel, err error)
}

var _ HybridUseBenefitClientAPI = (*softwareplan.HybridUseBenefitClient)(nil)

// HybridUseBenefitRevisionClientAPI contains the set of methods on the HybridUseBenefitRevisionClient type.
type HybridUseBenefitRevisionClientAPI interface {
	List(ctx context.Context, scope string, planID string) (result softwareplan.HybridUseBenefitListResultPage, err error)
	ListComplete(ctx context.Context, scope string, planID string) (result softwareplan.HybridUseBenefitListResultIterator, err error)
}

var _ HybridUseBenefitRevisionClientAPI = (*softwareplan.HybridUseBenefitRevisionClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context, scope string) (result softwareplan.OperationListPage, err error)
	ListComplete(ctx context.Context, scope string) (result softwareplan.OperationListIterator, err error)
}

var _ OperationsClientAPI = (*softwareplan.OperationsClient)(nil)
