/*
 * Decompiled with CFR 0.152.
 */
package jrm.xml;

import java.util.ArrayDeque;
import java.util.Deque;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jrm.xml.SimpleAttribute;

public final class EnhancedXMLStreamWriter
implements XMLStreamWriter {
    private final XMLStreamWriter writer;
    private final String indentStep;
    private final Deque<Seen> stateStack = new ArrayDeque<Seen>();
    private Seen state = Seen.NOTHING;
    private int depth = 0;

    public EnhancedXMLStreamWriter(XMLStreamWriter writer) {
        this(writer, "\t");
    }

    public EnhancedXMLStreamWriter(XMLStreamWriter writer, String indentStep) {
        this.writer = writer;
        this.indentStep = indentStep;
    }

    @Override
    public void close() throws XMLStreamException {
        this.writer.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.writer.getPrefix(uri);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.writer.getProperty(name);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.writer.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.writer.setNamespaceContext(context);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.writer.setPrefix(prefix, uri);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.state = Seen.DATA;
        this.writer.writeCData(data);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.state = Seen.DATA;
        this.writer.writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.state = Seen.DATA;
        this.writer.writeCharacters(text, start, len);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.writer.writeComment(data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.writer.writeDTD(dtd);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.writer.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.onEmptyElement();
        this.writer.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.onEmptyElement();
        this.writer.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.onEmptyElement();
        this.writer.writeEmptyElement(localName);
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.writer.writeEndDocument();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.onEndElement();
        this.writer.writeEndElement();
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.writer.writeEntityRef(name);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.writer.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writer.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.writer.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writer.writeStartDocument();
        if (this.indentStep != null) {
            this.doNewline();
        }
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.writer.writeStartDocument(version);
        if (this.indentStep != null) {
            this.doNewline();
        }
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.writer.writeStartDocument(encoding, version);
        if (this.indentStep != null) {
            this.doNewline();
        }
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.onStartElement();
        this.writer.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.onStartElement();
        this.writer.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.onStartElement();
        this.writer.writeStartElement(prefix, localName, namespaceURI);
    }

    private void doIndent() throws XMLStreamException {
        if (this.indentStep != null) {
            for (int i = 0; i < this.depth; ++i) {
                this.writer.writeCharacters(this.indentStep);
            }
        }
    }

    private void doNewline() throws XMLStreamException {
        this.writer.writeCharacters("\n");
    }

    private void onEmptyElement() throws XMLStreamException {
        this.state = Seen.ELEMENT;
        if (this.indentStep != null && this.depth > 0) {
            this.doNewline();
            this.doIndent();
        }
    }

    private void onEndElement() throws XMLStreamException {
        --this.depth;
        if (this.indentStep != null && this.state == Seen.ELEMENT) {
            this.doNewline();
            this.doIndent();
        }
        this.state = this.stateStack.removeFirst();
    }

    private void onStartElement() throws XMLStreamException {
        this.stateStack.addFirst(Seen.ELEMENT);
        this.state = Seen.NOTHING;
        if (this.indentStep != null && this.depth > 0) {
            this.doNewline();
            this.doIndent();
        }
        ++this.depth;
    }

    public void writeElement(String localName, SimpleAttribute ... attributes) throws XMLStreamException {
        this.writeEmptyElement(localName);
        if (attributes != null) {
            for (SimpleAttribute attr : attributes) {
                if (attr.name == null || attr.name.isEmpty() || attr.value == null) continue;
                this.writeAttribute(attr.name, attr.value.toString());
            }
        }
    }

    public void writeStartElement(String localName, SimpleAttribute ... attributes) throws XMLStreamException {
        this.writeStartElement(localName);
        if (attributes != null) {
            for (SimpleAttribute attr : attributes) {
                if (attr.name == null || attr.name.isEmpty() || attr.value == null) continue;
                this.writeAttribute(attr.name, attr.value.toString());
            }
        }
    }

    public void writeElement(String localName, CharSequence text, SimpleAttribute ... attributes) throws XMLStreamException {
        this.writeStartElement(localName, attributes);
        if (text != null) {
            this.writeCharacters(text.toString());
        }
        this.writeEndElement();
    }

    private static enum Seen {
        NOTHING,
        ELEMENT,
        DATA;

    }
}

