/*
 * Decompiled with CFR 0.152.
 */
package JTrrntzip;

import JTrrntzip.LogCallback;
import JTrrntzip.Messages;
import JTrrntzip.TrrntZipStatus;
import JTrrntzip.ZippedFile;
import java.util.EnumSet;
import java.util.List;

public class TorrentZipCheck {
    public static EnumSet<TrrntZipStatus> CheckZipFiles(List<ZippedFile> zippedFiles, LogCallback StatusLogCallBack) {
        EnumSet<TrrntZipStatus> tzStatus = EnumSet.noneOf(TrrntZipStatus.class);
        boolean error1 = false;
        for (ZippedFile t : zippedFiles) {
            char[] bytes = t.Name.toCharArray();
            boolean fixDir = false;
            for (int j = 0; j < bytes.length; ++j) {
                if (bytes[j] != '\\') continue;
                fixDir = true;
                bytes[j] = 47;
                tzStatus.add(TrrntZipStatus.BadDirectorySeparator);
                if (error1 || !StatusLogCallBack.isVerboseLogging()) continue;
                error1 = true;
                StatusLogCallBack.StatusLogCallBack(Messages.getString("TorrentZipCheck.IncorrectDirectorySeparatoreFound"));
            }
            if (!fixDir) continue;
            t.Name = new String(bytes);
        }
        boolean error2 = false;
        boolean thisSortFound = true;
        while (thisSortFound) {
            thisSortFound = false;
            for (int i = 0; i < zippedFiles.size() - 1; ++i) {
                int c = zippedFiles.get((int)i).Name.compareToIgnoreCase(zippedFiles.get((int)(i + 1)).Name);
                if (c <= 0) continue;
                ZippedFile T = zippedFiles.get(i);
                zippedFiles.set(i, zippedFiles.get(i + 1));
                zippedFiles.set(i + 1, T);
                tzStatus.add(TrrntZipStatus.Unsorted);
                thisSortFound = true;
                if (error2 || !StatusLogCallBack.isVerboseLogging()) continue;
                error2 = true;
                StatusLogCallBack.StatusLogCallBack(Messages.getString("TorrentZipCheck.IncorrectFileOrderFound"));
            }
        }
        boolean error3 = false;
        for (int i = 0; i < zippedFiles.size() - 1; ++i) {
            if (zippedFiles.get((int)i).Name.charAt(zippedFiles.get((int)i).Name.length() - 1) != '/' || zippedFiles.get((int)(i + 1)).Name.length() <= zippedFiles.get((int)i).Name.length()) continue;
            boolean delete = true;
            for (int j = 0; j < zippedFiles.get((int)i).Name.length(); ++j) {
                if (zippedFiles.get((int)i).Name.charAt(j) == zippedFiles.get((int)(i + 1)).Name.charAt(j)) continue;
                delete = false;
                break;
            }
            if (!delete) continue;
            zippedFiles.remove(i);
            tzStatus.add(TrrntZipStatus.ExtraDirectoryEntries);
            if (!error3 && StatusLogCallBack.isVerboseLogging()) {
                error3 = true;
                StatusLogCallBack.StatusLogCallBack(Messages.getString("TorrentZipCheck.UnneededDirectoryRecordsFound"));
            }
            --i;
        }
        boolean error4 = false;
        for (int i = 0; i < zippedFiles.size() - 1; ++i) {
            if (!zippedFiles.get((int)i).Name.equals(zippedFiles.get((int)(i + 1)).Name)) continue;
            tzStatus.add(TrrntZipStatus.RepeatFilesFound);
            if (error4 || !StatusLogCallBack.isVerboseLogging()) continue;
            error4 = true;
            StatusLogCallBack.StatusLogCallBack(Messages.getString("TorrentZipCheck.DuplicateFileEntriesFound"));
        }
        return tzStatus;
    }
}

