/*
 * Decompiled with CFR 0.152.
 */
package JTrrntzip;

import JTrrntzip.AbstractTorrentZipOptions;
import JTrrntzip.LogCallback;
import JTrrntzip.Messages;
import JTrrntzip.TorrentZip;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Scanner;
import org.apache.commons.io.FilenameUtils;

public final class Program
extends AbstractTorrentZipOptions
implements LogCallback {
    private TorrentZip tz;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("");
            System.out.println(Messages.getString("Program.MissingPath"));
            System.out.println(Messages.getString("Program.Usage"));
            return;
        }
        new Program(args);
    }

    public Program(String[] args) {
        super(args);
        if (this.argfiles != null && this.argfiles.size() > 0) {
            this.tz = new TorrentZip(this, this);
            for (File argfile : this.argfiles) {
                if (argfile.isDirectory()) {
                    try {
                        this.ProcessDir(argfile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                String dir = argfile.getParent();
                if (dir == null) {
                    dir = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
                }
                String filename = argfile.getName();
                try {
                    DirectoryStream<Path> dirStream = Files.newDirectoryStream(Paths.get(dir, new String[0]), filename);
                    Throwable throwable = null;
                    try {
                        dirStream.forEach(path -> {
                            String ext = FilenameUtils.getExtension(path.getFileName().toString());
                            if (ext != null && ext.equalsIgnoreCase("zip")) {
                                try {
                                    this.ProcessFile(path.toFile());
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dirStream == null) continue;
                        if (throwable != null) {
                            try {
                                dirStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        dirStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this._guiLaunch) {
            System.out.format(Messages.getString("Program.Complete"), new Object[0]);
            new Scanner(System.in).nextLine();
        }
    }

    private void ProcessDir(File dir) throws IOException {
        if (this.isVerboseLogging()) {
            System.out.println(Messages.getString("Program.CheckingDir") + dir);
        }
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                if (this.NoRecursion) continue;
                this.ProcessDir(f);
                continue;
            }
            String ext = FilenameUtils.getExtension(f.getName());
            if (ext == null || !ext.equalsIgnoreCase("zip")) continue;
            this.tz.Process(f);
        }
    }

    private void ProcessFile(File file) throws IOException {
        this.tz.Process(file);
    }

    @Override
    public final void StatusLogCallBack(String log) {
        System.out.format("%s\n", log);
    }

    @Override
    public final void StatusCallBack(int percent) {
        System.out.format("%03d%% ", percent);
    }

    @Override
    public final boolean isVerboseLogging() {
        return this.VerboseLogging;
    }
}

