#ifndef CRASHWORLD_H
#define CRASHWORLD_H

#include <plib/ssg.h>
#include <plib/ssgaBillboards.h>


#include "brickwall.h"



class CrashWorld
{
  public :

    CrashWorld(dWorldID world, dSpaceID bigspace, dSpaceID staticspace, ssgRoot *scene, ModelMap *modelmap, const std::string &prefix)
    {
      sgVec3 gridpos={0,0,0};
      grid = new StaticWorldObject(modelmap->Get("testground.3ds"), staticspace, gridpos);
      grid->name = "ground";
      scene->addKid(grid->GetEntity());

      sgVec3 wallpos = {13, 0, 0.25};
      brickwall = new BrickWall(wallpos, 4, 3, world, bigspace, modelmap->Get("brick_full.3ds"), modelmap->Get("brick_half.3ds"));
      brickwall->SetMass(1.0);
      scene->addKid(brickwall->GetEntity());
    }

    ~CrashWorld()
    {
      if (brickwall) delete brickwall;
      if (grid) delete grid;
    }

    bool Sustain(float dt)
    {
      if (brickwall) brickwall->Sustain(dt);
      return false;
    }

    BrickWall *brickwall;

  protected :

    StaticWorldObject *grid;
};

#endif

