/*
 * DVIlib - a library for handling DVI files
 * 
 * Copyright (c) 2000 Evgeny Stambulchik
 * 
 * 
 *                           All Rights Reserved
 * 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 * 
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 * 
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __DVILIBP_H_
#define __DVILIBP_H_

#include "dvilib.h"

typedef struct _dvi_hooks {
    DVI_S32 (*write_char)(DVI *dvip, int c, int advance);
    void (*draw_rule)(DVI *dvip, DVI_S32 a, DVI_S32 b);
} dvi_hooks;

#define sget1(dvip)   sgetn(dvip, 1)
#define sget2(dvip)   sgetn(dvip, 2)
#define sget3(dvip)   sgetn(dvip, 3)
#define sget4(dvip)   sgetn(dvip, 4)

#define uget1(dvip)   ugetn(dvip, 1)
#define uget2(dvip)   ugetn(dvip, 2)
#define uget3(dvip)   ugetn(dvip, 3)
#define uget4(dvip)   ugetn(dvip, 4)

int fgetn(DVI *dvip, int n);

void bop(DVI *dvip);
void eop(DVI *dvip);

int dvi_cmd(DVI *dvip);

void push(DVI *dvip);
void pop(DVI *dvip);

void rightn(DVI *dvip, int n);
void wn(DVI *dvip, int n);
void xn(DVI *dvip, int n);
void downn(DVI *dvip, int n);
void yn(DVI *dvip, int n);
void zn(DVI *dvip, int n);
void fnt_num(DVI *dvip, int fn);
void fntn(DVI *dvip, int n);
void fnt_defn(DVI *dvip, int n);
void xxxn(DVI *dvip, int n);
void pre(DVI *dvip);
void post(DVI *dvip);
void post_post(DVI *dvip);

void load_font(DVI *dvip, DVI_finfo *finfo);

void setput_charn(DVI *dvip, int n, int advance);
void setput_char(DVI *dvip, int c, int advance);
void setput_rule(DVI *dvip, int advance);

void dvi_errmsg(const char *msg);

void *dvi_malloc(size_t size);
void *dvi_realloc(void *p, size_t size);
void  dvi_free(void *p);

#endif /* __DVILIBP_H_ */
