close all
clear

data = {
'F',0.0320000648499,0.233999967575,0.233999967575,0.0160000324249,0.203000068665,0.0939998626709,3.28100013733,5.59399986267,4.0
'G',0.0310001373291,0.593999862671,0.297000169754,0.0149998664856,0.53200006485,0.155999898911,3.98400020599,8.71899986267,5.0
'H',0.0150001049042,1.14099979401,3.375,0.0310001373291,1.09399986267,0.31299996376,24.0780000687,22.6879999638,5.0
'I',0.0309998989105,2.54699993134,14.0629999638,0.0310001373291,2.42199993134,0.344000101089,7.54700016975,18.3599998951,6.0
'J',0.0159997940063,5.42200016975,17.0469999313,0.0309998989105,5.34400010109,0.405999898911,35.25,33.8280000687,7.0
'K',0.0150001049042,10.75,25.9219999313,0.0160000324249,10.5779998302,0.546999931335,64.5160000324,59.3120000362,8.0
'L',0.0309998989105,20.125,148.937999964,0.0160000324249,20.1559998989,1.54699993134,60.6870000362,87.1570000648,8.0
'M',0.0309998989105,37.25,396.141000032,0.0309998989105,37.4220001698,1.8900001049,80.0789999962,114.515000105,9.0
'N',0.0310001373291,66.2809998989,398.858999968,0.0320000648499,65.6559998989,1.29699993134,142.937000036,142.921999931,10.0
'O',0.0309998989105,111.703000069,421.984999895,0.0309998989105,112.765000105,1.73399996758,162.389999866,226.79700017,11.0
'P',0.0310001373291,184.016000032,14768.6760001,0.0469999313354,184.733999968,387.641000032,311.218000174,226.875,11.0
'Q',0.047000169754,297.343999863,'--',0.0469999313354,296.405999899,525.687999964,205.968000174,311.796999931,12.0
'R',0.0469999313354,463.453000069,'--',0.108999967575,464.453000069,347.406999826,276.437000036,364.344000101,13.0
'S',0.0629999637604,714.5,'--',0.047000169754,725.718999863,501.891000032,551.671999931,408.171000004,14.0
'T',0.0629999637604,1077.81200004,'--',0.0620000362396,1086.2809999,'--',395.796999931,431.016000032,14.0
'U',0.0629999637604,'--','--',0.0620000362396,1611.06299996,'--',392.703000069,929.530999899,15.0
};

xticks = {};
x1 = [];
y1 = [];
x2 = [];
y2 = [];
x3 = [];
y3 = [];
x4 = [];
y4 = [];
x5 = [];
y5 = [];
x6 = [];
y6 = [];
x7 = [];
y7 = [];
x8 = [];
y8 = [];
for i = 1:size(data, 1),
    xticks{i} = data{i, 1};
    if data{i, 2} ~= '--',
        x1 = [x1, i];
        y1 = [y1, data{i, 2}];
    end;
    if data{i, 3} ~= '--',
        x2 = [x2, i];
        y2 = [y2, data{i, 3}];
    end;
    if data{i, 4} ~= '--',
        x3 = [x3, i];
        y3 = [y3, data{i, 4}];
    end;
    if data{i, 5} ~= '--',
        x4 = [x4, i];
        y4 = [y4, data{i, 5}];
    end;
    if data{i, 6} ~= '--',
        x5 = [x5, i];
        y5 = [y5, data{i, 6}];
    end;
    if data{i, 7} ~= '--',
        x6 = [x6, i];
        y6 = [y6, data{i, 7}];
    end;
    if data{i, 8} ~= '--',
        x7 = [x7, i];
        y7 = [y7, data{i, 8}];
    end;
    if data{i, 9} ~= '--',
        x8 = [x8, i];
        y8 = [y8, data{i, 9}];
    end;
end;

x6 = [x6, 22];
y6 = [y6, 10000];

plot(x3, y3, 'b+-')
hold on
plot(x2, y2, 'c+-')
plot(x6, y6, 'ro-')
plot(x5, y5, 'mo-')
plot(x7, y7, 'g^-')
plot(x8, y8, 'kv-')

axis([1 size(data, 1), 0, 1000])

set(gca, 'XTick', 1:size(data, 1), 'XTickLabel', xticks)    

title('Comparison of solver performance')
xlabel('Last guest in guest list')
ylabel('Solution time (s)')
legend('Cbc', 'Cbc with columns (solve only)', 'Gurobi', 'Gurobi with columns (solve only)', 'DIP', 'Customised DIP', 'Location', 'Northwest')

print -dpng compare.png