/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.sudoku;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import net.sf.clipsrules.jni.CLIPSException;
import net.sf.clipsrules.jni.Environment;
import net.sf.clipsrules.jni.FactAddressValue;
import net.sf.clipsrules.jni.LexemeValue;
import net.sf.clipsrules.jni.NumberValue;

class SudokuDemo
implements ActionListener,
FocusListener,
KeyListener {
    JFrame jfrm;
    JPanel mainGrid;
    JButton clearButton;
    JButton resetButton;
    JButton solveButton;
    JButton techniquesButton;
    Object[][][] resetValues = new Object[9][3][3];
    boolean solved = false;
    ResourceBundle sudokuResources;
    Environment clips;
    boolean isExecuting = false;
    Thread executionThread;

    SudokuDemo() {
        Serializable serializable;
        try {
            this.sudokuResources = ResourceBundle.getBundle("net.sf.clipsrules.jni.examples.sudoku.resources.SudokuResources", Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            return;
        }
        this.jfrm = new JFrame(this.sudokuResources.getString("SudokuDemo"));
        this.jfrm.getContentPane().setLayout(new BorderLayout());
        this.jfrm.setDefaultCloseOperation(3);
        this.mainGrid = new JPanel();
        GridLayout gridLayout = new GridLayout(3, 3);
        gridLayout.setHgap(-1);
        gridLayout.setVgap(-1);
        this.mainGrid.setLayout(gridLayout);
        this.mainGrid.setOpaque(true);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component instanceof JLabel) {
                    ((JLabel)component).setHorizontalAlignment(0);
                    if (object instanceof String) {
                        if ("?".equals(object)) {
                            ((JLabel)component).setForeground(Color.red);
                        } else if (((String)object).length() > 1) {
                            ((JLabel)component).setForeground(Color.green.darker());
                        } else {
                            ((JLabel)component).setForeground(Color.black);
                        }
                    }
                }
                return component;
            }
        };
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                JTable jTable = new JTable(3, 3){

                    @Override
                    public boolean isCellEditable(int n, int n2) {
                        return false;
                    }
                };
                jTable.setRowSelectionAllowed(false);
                jTable.setShowGrid(true);
                jTable.setRowHeight(25);
                jTable.setGridColor(Color.black);
                jTable.setBorder(BorderFactory.createLineBorder(Color.black, 2));
                jTable.setDefaultRenderer(Object.class, defaultTableCellRenderer);
                jTable.addFocusListener(this);
                jTable.addKeyListener(this);
                serializable = null;
                for (int k = 0; k < 3; ++k) {
                    serializable = jTable.getColumnModel().getColumn(k);
                    ((TableColumn)serializable).setMaxWidth(25);
                }
                this.mainGrid.add(jTable);
            }
        }
        serializable = new JPanel();
        gridLayout = new GridLayout(4, 1);
        ((Container)serializable).setLayout(gridLayout);
        ((JComponent)serializable).setOpaque(true);
        this.clearButton = new JButton(this.sudokuResources.getString("Clear"));
        this.clearButton.setActionCommand("Clear");
        ((Container)serializable).add(this.clearButton);
        this.clearButton.addActionListener(this);
        this.clearButton.setToolTipText(this.sudokuResources.getString("ClearTip"));
        this.resetButton = new JButton(this.sudokuResources.getString("Reset"));
        this.resetButton.setActionCommand("Reset");
        this.resetButton.setEnabled(false);
        ((Container)serializable).add(this.resetButton);
        this.resetButton.addActionListener(this);
        this.resetButton.setToolTipText(this.sudokuResources.getString("ResetTip"));
        this.solveButton = new JButton(this.sudokuResources.getString("Solve"));
        this.solveButton.setActionCommand("Solve");
        ((Container)serializable).add(this.solveButton);
        this.solveButton.addActionListener(this);
        this.solveButton.setToolTipText(this.sudokuResources.getString("SolveTip"));
        this.techniquesButton = new JButton(this.sudokuResources.getString("Techniques"));
        this.techniquesButton.setActionCommand("Techniques");
        this.techniquesButton.setEnabled(false);
        ((Container)serializable).add(this.techniquesButton);
        this.techniquesButton.addActionListener(this);
        this.techniquesButton.setToolTipText(this.sudokuResources.getString("TechniquesTip"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.mainGrid);
        jPanel.add((Component)serializable);
        this.jfrm.getContentPane().add((Component)jPanel, "North");
        JLabel jLabel = new JLabel("<html><p style=\"font-size:95%\">" + this.sudokuResources.getString("Instructions") + "</p><br>");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(jLabel);
        this.jfrm.getContentPane().add((Component)jPanel2, "South");
        this.clips = new Environment();
        try {
            this.clips.loadFromResource("/net/sf/clipsrules/jni/examples/sudoku/resources/sudoku.clp");
            this.clips.loadFromResource("/net/sf/clipsrules/jni/examples/sudoku/resources/solve.clp");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        this.jfrm.pack();
        this.jfrm.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SudokuDemo();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.onActionPerformed(actionEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void runSudoku() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    SudokuDemo.this.clips.run();
                }
                catch (CLIPSException cLIPSException) {
                    cLIPSException.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SudokuDemo.this.updateGrid();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
            }
        };
        this.isExecuting = true;
        this.executionThread = new Thread(runnable);
        this.jfrm.setCursor(Cursor.getPredefinedCursor(3));
        this.executionThread.start();
    }

    public void onActionPerformed(ActionEvent actionEvent) throws Exception {
        if (this.isExecuting) {
            return;
        }
        if (actionEvent.getActionCommand().equals("Clear")) {
            this.solved = false;
            this.solveButton.setEnabled(true);
            this.techniquesButton.setEnabled(false);
            for (int i = 0; i < 9; ++i) {
                JTable jTable = (JTable)this.mainGrid.getComponent(i);
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        jTable.setValueAt("", j, k);
                    }
                }
            }
        } else if (actionEvent.getActionCommand().equals("Reset")) {
            this.solved = false;
            this.solveButton.setEnabled(true);
            this.techniquesButton.setEnabled(false);
            for (int i = 0; i < 9; ++i) {
                JTable jTable = (JTable)this.mainGrid.getComponent(i);
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        jTable.setValueAt(this.resetValues[i][j][k], j, k);
                    }
                }
            }
        } else if (actionEvent.getActionCommand().equals("Solve")) {
            this.clips.reset();
            this.clips.assertString("(phase expand-any)");
            this.clips.assertString("(size 3)");
            for (int i = 0; i < 9; ++i) {
                JTable jTable = (JTable)this.mainGrid.getComponent(i);
                int n = i / 3;
                int n2 = i % 3;
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        this.resetValues[i][j][k] = jTable.getValueAt(j, k);
                        String string = "(possible (row " + (j + n * 3 + 1) + ") (column " + (k + n2 * 3 + 1) + ") (group " + (i + 1) + ") (id " + (i * 9 + j * 3 + k + 1) + ") ";
                        string = this.resetValues[i][j][k] == null || this.resetValues[i][j][k].equals("") ? string + "(value any))" : string + "(value " + this.resetValues[i][j][k] + "))";
                        this.clips.assertString(string);
                    }
                }
            }
            this.clearButton.setEnabled(false);
            this.resetButton.setEnabled(false);
            this.solveButton.setEnabled(false);
            this.techniquesButton.setEnabled(false);
            this.runSudoku();
        } else if (actionEvent.getActionCommand().equals("Techniques")) {
            String string = "<html><p style=\"font-size:95%\">";
            List<FactAddressValue> list = this.clips.findAllFacts("technique");
            int n = list.size();
            for (int i = 1; i <= n; ++i) {
                FactAddressValue factAddressValue = this.clips.findFact("?f", "technique-employed", "(eq ?f:priority " + i + ")");
                if (factAddressValue == null) continue;
                string = string + ((NumberValue)factAddressValue.getSlotValue("priority")).intValue() + ". " + ((LexemeValue)factAddressValue.getSlotValue("reason")).getValue() + "<br>";
            }
            JOptionPane.showMessageDialog(this.jfrm, string, this.sudokuResources.getString("SolutionTechniques"), -1);
        }
    }

    private void updateGrid() throws Exception {
        int n;
        int n2;
        JTable jTable;
        int n3;
        for (n3 = 0; n3 < 9; ++n3) {
            jTable = (JTable)this.mainGrid.getComponent(n3);
            n2 = n3 / 3;
            n = n3 % 3;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    String string;
                    List<FactAddressValue> list;
                    this.resetValues[n3][i][j] = jTable.getValueAt(i, j);
                    if (this.resetValues[n3][i][j] != null && !this.resetValues[n3][i][j].equals("") || (list = this.clips.findAllFacts("?f", "possible", string = "(and (eq ?f:row " + (i + n2 * 3 + 1) + ") (eq ?f:column " + (j + n * 3 + 1) + "))")).size() != 1) continue;
                    FactAddressValue factAddressValue = list.get(0);
                    jTable.setValueAt(" " + factAddressValue.getSlotValue("value") + " ", i, j);
                }
            }
        }
        for (n3 = 0; n3 < 9; ++n3) {
            jTable = (JTable)this.mainGrid.getComponent(n3);
            for (n2 = 0; n2 < 3; ++n2) {
                for (n = 0; n < 3; ++n) {
                    if (jTable.getValueAt(n2, n) != null && !jTable.getValueAt(n2, n).equals("")) continue;
                    jTable.setValueAt("?", n2, n);
                }
            }
        }
        this.jfrm.setCursor(Cursor.getPredefinedCursor(0));
        this.solved = true;
        this.clearButton.setEnabled(true);
        this.resetButton.setEnabled(true);
        this.solveButton.setEnabled(false);
        this.techniquesButton.setEnabled(true);
        this.executionThread = null;
        this.isExecuting = false;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        JTable jTable = (JTable)focusEvent.getComponent();
        int n = jTable.getEditingRow();
        int n2 = jTable.getEditingColumn();
        if (n == -1 || n2 == -1) {
            return;
        }
        TableCellEditor tableCellEditor = jTable.getCellEditor(n, n2);
        tableCellEditor.stopCellEditing();
        jTable.clearSelection();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        JTable jTable = (JTable)keyEvent.getComponent();
        int n = jTable.getSelectedRow();
        int n2 = jTable.getSelectedColumn();
        if (this.solved || this.isExecuting) {
            return;
        }
        if (n == -1 || n2 == -1) {
            return;
        }
        char c = keyEvent.getKeyChar();
        if (c == '\b') {
            jTable.setValueAt("", n, n2);
            return;
        }
        if (c != '1' && c != '2' && c != '3' && c != '4' && c != '5' && c != '6' && c != '7' && c != '8' && c != '9') {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        String string = Character.toString(c);
        jTable.setValueAt(string, n, n2);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (i == n && j == n2 || !string.equals(jTable.getValueAt(i, j))) continue;
                jTable.setValueAt("", i, j);
            }
        }
    }
}

