/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.crypto;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import okio.ByteString;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.ecc.ECKeyPair;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.kdf.HKDF;
import org.signal.registration.proto.RegistrationProvisionEnvelope;
import org.signal.registration.proto.RegistrationProvisionMessage;
import org.whispersystems.signalservice.internal.push.ProvisionEnvelope;
import org.whispersystems.signalservice.internal.push.ProvisionMessage;
import org.whispersystems.signalservice.internal.util.Util;

public class PrimaryProvisioningCipher {
    public static final String PROVISIONING_MESSAGE = "TextSecure Provisioning Message";
    private final ECPublicKey theirPublicKey;

    public PrimaryProvisioningCipher(ECPublicKey theirPublicKey) {
        this.theirPublicKey = theirPublicKey;
    }

    public byte[] encrypt(ProvisionMessage message) throws org.signal.libsignal.protocol.InvalidKeyException {
        ECKeyPair ourKeyPair = ECKeyPair.generate();
        byte[] sharedSecret = ourKeyPair.getPrivateKey().calculateAgreement(this.theirPublicKey);
        byte[] derivedSecret = HKDF.deriveSecrets((byte[])sharedSecret, (byte[])PROVISIONING_MESSAGE.getBytes(), (int)64);
        byte[][] parts = Util.split(derivedSecret, 32, 32);
        byte[] version = new byte[]{1};
        byte[] ciphertext = this.getCiphertext(parts[0], message.encode());
        byte[] mac = this.getMac(parts[1], Util.join(version, ciphertext));
        byte[] body = Util.join(version, ciphertext, mac);
        return new ProvisionEnvelope.Builder().publicKey(ByteString.of((byte[])ourKeyPair.getPublicKey().serialize())).body(ByteString.of((byte[])body)).build().encode();
    }

    public byte[] encrypt(RegistrationProvisionMessage message) throws org.signal.libsignal.protocol.InvalidKeyException {
        ECKeyPair ourKeyPair = ECKeyPair.generate();
        byte[] sharedSecret = ourKeyPair.getPrivateKey().calculateAgreement(this.theirPublicKey);
        byte[] derivedSecret = HKDF.deriveSecrets((byte[])sharedSecret, (byte[])PROVISIONING_MESSAGE.getBytes(), (int)64);
        byte[][] parts = Util.split(derivedSecret, 32, 32);
        byte[] version = new byte[]{1};
        byte[] ciphertext = this.getCiphertext(parts[0], message.encode());
        byte[] mac = this.getMac(parts[1], Util.join(version, ciphertext));
        byte[] body = Util.join(version, ciphertext, mac);
        return new RegistrationProvisionEnvelope.Builder().publicKey(ByteString.of((byte[])ourKeyPair.getPublicKey().serialize())).body(ByteString.of((byte[])body)).build().encode();
    }

    private byte[] getCiphertext(byte[] key, byte[] message) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, new SecretKeySpec(key, "AES"));
            return Util.join(cipher.getIV(), cipher.doFinal(message));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private byte[] getMac(byte[] key, byte[] message) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            return mac.doFinal(message);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ProvisionMessage decrypt(IdentityKeyPair tempIdentity, byte[] bytes) throws org.signal.libsignal.protocol.InvalidKeyException, IOException {
        ProvisionEnvelope envelope = (ProvisionEnvelope)((Object)ProvisionEnvelope.ADAPTER.decode(bytes));
        ECPublicKey publicKey = new ECPublicKey(envelope.publicKey.toByteArray());
        byte[] sharedSecret = tempIdentity.getPrivateKey().calculateAgreement(publicKey);
        byte[] derivedSecret = HKDF.deriveSecrets((byte[])sharedSecret, (byte[])PROVISIONING_MESSAGE.getBytes(), (int)64);
        byte[][] parts = Util.split(derivedSecret, 32, 32);
        ByteString joined = envelope.body;
        if (joined.getByte(0) != 1) {
            throw new RuntimeException("Bad version number on provision message!");
        }
        byte[] iv = joined.substring(1, 17).toByteArray();
        byte[] ciphertext = joined.substring(17, joined.size() - 32).toByteArray();
        byte[] ivAndCiphertext = joined.substring(0, joined.size() - 32).toByteArray();
        byte[] mac = joined.substring(joined.size() - 32).toByteArray();
        this.verifyMac(parts[1], ivAndCiphertext, mac);
        return (ProvisionMessage)((Object)ProvisionMessage.ADAPTER.decode(this.decrypt(parts[0], iv, ciphertext)));
    }

    private void verifyMac(byte[] key, byte[] message, byte[] theirMac) {
        byte[] ourMac = this.getMac(key, message);
        if (!Arrays.equals(ourMac, theirMac)) {
            throw new RuntimeException("Invalid MAC on provision message!");
        }
    }

    private byte[] decrypt(byte[] key, byte[] iv, byte[] ciphertext) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
            return cipher.doFinal(ciphertext);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

