/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol;

import org.signal.libsignal.internal.CalledFromNative;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.ServiceId;

public class SignalProtocolAddress
extends NativeHandleGuard.SimpleOwner {
    public SignalProtocolAddress(String name, int deviceId) {
        super(FilterExceptions.filterExceptions(() -> Native.ProtocolAddress_New(name, deviceId)));
    }

    public SignalProtocolAddress(ServiceId serviceId, int deviceId) {
        this(serviceId.toServiceIdString(), deviceId);
    }

    @CalledFromNative
    public SignalProtocolAddress(long nativeHandle) {
        super(nativeHandle);
    }

    @Override
    protected void release(long nativeHandle) {
        Native.ProtocolAddress_Destroy(nativeHandle);
    }

    public String getName() {
        return this.guardedMap(Native::ProtocolAddress_Name);
    }

    public ServiceId getServiceId() {
        try {
            return ServiceId.parseFromString(this.getName());
        }
        catch (ServiceId.InvalidServiceIdException e) {
            return null;
        }
    }

    public int getDeviceId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = Native.ProtocolAddress_DeviceId(guard.nativeHandle());
            return n;
        }
    }

    public String toString() {
        return this.getName() + "." + this.getDeviceId();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof SignalProtocolAddress)) {
            return false;
        }
        SignalProtocolAddress that = (SignalProtocolAddress)other;
        return this.getName().equals(that.getName()) && this.getDeviceId() == that.getDeviceId();
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getDeviceId();
    }
}

