# - Try to find the libunibreak
# Once done this will define
#
#  LIBUNIBREAK_FOUND - system has libunibreak
#  LIBUNIBREAK_INCLUDE_DIR - The include directory to use for the libunibreak headers
#  LIBUNIBREAK_INCLUDE_DIRS - The same
#  LIBUNIBREAK_LIBRARIES - Link these to use libunibreak
#  LIBUNIBREAK_DEFINITIONS - Compiler switches required for using libunibreak
#  LIBUNIBREAK_VERSION - The version of the libunibreak library which was found.

# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

mark_as_advanced(LIBUNIBREAK_LIBRARY LIBUNIBREAK_INCLUDE_DIR)

if (LIBUNIBREAK_LIBRARY AND LIBUNIBREAK_INCLUDE_DIR)

  # in cache already
  set(LIBUNIBREAK_FOUND TRUE)

else (LIBUNIBREAK_LIBRARY AND LIBUNIBREAK_INCLUDE_DIR)

  if (NOT MSVC)
    # use pkg-config to get the directories and then use these values
    # in the FIND_PATH() and FIND_LIBRARY() calls
    find_package(PkgConfig QUIET)
    pkg_check_modules(PC_LIBUNIBREAK QUIET libunibreak)

    set(LIBUNIBREAK_DEFINITIONS ${PC_LIBUNIBREAK_CFLAGS_OTHER})
    set(LIBUNIBREAK_VERSION ${PC_LIBUNIBREAK_VERSION})
  endif (NOT MSVC)

  find_path(LIBUNIBREAK_INCLUDE_DIR linebreak.h
    PATHS
    ${PC_LIBUNIBREAK_INCLUDEDIR}
    ${PC_LIBUNIBREAK_INCLUDE_DIRS}
  )

  find_library(LIBUNIBREAK_LIBRARY NAMES unibreak
    PATHS
    ${PC_LIBUNIBREAK_LIBDIR}
    ${PC_LIBUNIBREAK_LIBRARY_DIRS}
  )

  if (NOT LIBUNIBREAK_VERSION)
    if(EXISTS "${LIBUNIBREAK_INCLUDE_DIR}/unibreakbase.h")
      file(STRINGS "${LIBUNIBREAK_INCLUDE_DIR}/unibreakbase.h"
        _LIBUNIBREAK_VERSION_MAJOR REGEX "^#define UNIBREAK_VERSION")
      string(REGEX MATCH "0x[0-9]+" _LIBUNIBREAK_VERSION_MAJOR "${_LIBUNIBREAK_VERSION_MAJOR}")
      string(REGEX REPLACE "0x([0-9][0-9])[0-9]+" "\\1" LIBUNIBREAK_VERSION_MAJOR "${_LIBUNIBREAK_VERSION_MAJOR}")
      string(REGEX REPLACE "0([0-9])" "\\1" LIBUNIBREAK_VERSION_MAJOR "${LIBUNIBREAK_VERSION_MAJOR}")
      file(STRINGS "${LIBUNIBREAK_INCLUDE_DIR}/unibreakbase.h"
        _LIBUNIBREAK_VERSION_MINOR REGEX "^#define UNIBREAK_VERSION")
      string(REGEX MATCH "0x[0-9]+" _LIBUNIBREAK_VERSION_MINOR "${_LIBUNIBREAK_VERSION_MINOR}")
      string(REGEX REPLACE "0x[0-9][0-9]([0-9][0-9])" "\\1" LIBUNIBREAK_VERSION_MINOR "${_LIBUNIBREAK_VERSION_MINOR}")
      string(REGEX REPLACE "0([0-9])" "\\1" LIBUNIBREAK_VERSION_MINOR "${LIBUNIBREAK_VERSION_MINOR}")
      set(LIBUNIBREAK_VERSION ${LIBUNIBREAK_VERSION_MAJOR}.${LIBUNIBREAK_VERSION_MINOR})
    endif()
  endif()

  include(FindPackageHandleStandardArgs)
  find_package_handle_standard_args(libunibreak
    FOUND_VAR LIBUNIBREAK_FOUND
    REQUIRED_VARS
      LIBUNIBREAK_LIBRARY
      LIBUNIBREAK_INCLUDE_DIR
    VERSION_VAR LIBUNIBREAK_VERSION
  )

endif (LIBUNIBREAK_LIBRARY AND LIBUNIBREAK_INCLUDE_DIR)

if(LIBUNIBREAK_FOUND)
  set(LIBUNIBREAK_LIBRARIES ${LIBUNIBREAK_LIBRARY})
  set(LIBUNIBREAK_INCLUDE_DIRS ${LIBUNIBREAK_INCLUDE_DIR})
  if(NOT TARGET LIBUNIBREAK::libunibreak)
    add_library(LIBUNIBREAK::libunibreak UNKNOWN IMPORTED)
    set_target_properties(LIBUNIBREAK::libunibreak PROPERTIES
      IMPORTED_LOCATION "${LIBUNIBREAK_LIBRARIES}"
      INTERFACE_COMPILE_DEFINITIONS "${LIBUNIBREAK_DEFINITIONS}"
      INTERFACE_INCLUDE_DIRECTORIES "${LIBUNIBREAK_INCLUDE_DIRS}"
    )
  endif()
endif(LIBUNIBREAK_FOUND)
