/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.Security;
import org.jruby.Ruby;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public abstract class SecurityHelper {
    private static final Logger LOG;
    private static boolean attempted;
    private static final boolean JAVA9;

    public static void checkCryptoRestrictions(Ruby runtime2) {
        if (!attempted) {
            attempted = true;
            if (JAVA9) {
                SecurityHelper.setNonRestrictedJava9();
            } else {
                SecurityHelper.setNonRestrictedJava8();
            }
        }
    }

    private static boolean setNonRestrictedJava9() {
        try {
            if (Security.getProperty("crypto.policy") == null) {
                Security.setProperty("crypto.policy", "unlimited");
            }
            return true;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("unable un-restrict jce security: ", e);
            }
            return false;
        }
    }

    private static boolean setNonRestrictedJava8() {
        block5: {
            try {
                Class<?> jceSecurity = Class.forName("javax.crypto.JceSecurity");
                Field isRestricted = jceSecurity.getDeclaredField("isRestricted");
                if (Modifier.isFinal(isRestricted.getModifiers())) {
                    Field modifiers = Field.class.getDeclaredField("modifiers");
                    modifiers.setAccessible(true);
                    modifiers.setInt(isRestricted, isRestricted.getModifiers() & 0xFFFFFFEF);
                }
                isRestricted.setAccessible(true);
                isRestricted.setBoolean(null, false);
                isRestricted.setAccessible(false);
                return true;
            }
            catch (ClassNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unable un-restrict jce security: " + e, new Object[0]);
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug("unable un-restrict jce security: ", e);
            }
        }
        return false;
    }

    static {
        boolean moduleClassFound;
        LOG = LoggerFactory.getLogger(SecurityHelper.class);
        attempted = false;
        try {
            Class.forName("java.lang.Module");
            moduleClassFound = true;
        }
        catch (Exception notFound) {
            moduleClassFound = false;
        }
        JAVA9 = moduleClassFound;
    }
}

