// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "Collisions.h"




// ************************
// *** MEMBER FUNCTIONS ***
// ************************

// **************************************************

bool Collisions::intersects( const SDL_Rect& s1, const SDL_Rect& s2 )
{
    return ( s1.x >= s2.x - s1.w + 1 &&
             s1.x <= s2.x + s2.w - 1 &&
             s1.y >= s2.y - s1.h + 1 &&
             s1.y <= s2.y + s2.h - 1 );
    
} // Collisions::intersects()
                              
// **************************************************

bool Collisions::contains( const SDL_Rect& s1, const SDL_Rect& s2 )
{
    return ( s2.x >= s1.x &&
             s2.x + s2.w - 1 < s1.x + s1.w &&
             s2.y >= s1.y && 
             s2.y + s2.h - 1 < s1.y + s1.h );
    
} // Collisions::contains()

// **************************************************

