// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "User_input.h"




// *******************
// *** CONSTRUCTOR ***
// *******************
FS::User_input::User_input()
{
    // FIXME: get user-defined keys
    left_key = SDLK_LEFT;
    right_key = SDLK_RIGHT;
    up_key = SDLK_UP;
    down_key = SDLK_DOWN;
    jump_key = SDLK_SPACE;
    
} // FS::User_input::User_input

// ******************
// *** DESTRUCTOR ***
// ******************
FS::User_input::~User_input()
{
    // NYI...

} // FS::User_input::~User_input




// ************************
// *** MEMBER FUNCTIONS ***
// ************************

// **************************************************

void FS::User_input::add_event( const SDL_Event& event, bool joystick_selected )
{
    if (event.type == SDL_KEYDOWN)
    {
        if (event.key.keysym.sym == SDLK_ESCAPE)
        {
            my_list.push_back(ESCAPE_PRESSED);
        }
        else if ( !joystick_selected )
        {
            if (event.key.keysym.sym == up_key)
            {
                my_list.push_back(UP_KEY_PRESSED);
            }
            else if (event.key.keysym.sym == right_key)
            {
                my_list.push_back(RIGHT_KEY_PRESSED);      
            }
            else if (event.key.keysym.sym == down_key)
            {
                my_list.push_back(DOWN_KEY_PRESSED);
            }
            else if (event.key.keysym.sym == left_key)
            {
                my_list.push_back(LEFT_KEY_PRESSED);
            }
            else if (event.key.keysym.sym == jump_key)
            {
                my_list.push_back(JUMP_KEY_PRESSED);
            } // if ... else
        } // if ... else
    }
    else if ( (!joystick_selected) && (event.type == SDL_KEYUP) )
    {
        if (event.key.keysym.sym == up_key)
        {
            my_list.push_back(UP_KEY_RELEASED);
        }
        else if (event.key.keysym.sym == right_key)
        {
            my_list.push_back(RIGHT_KEY_RELEASED);
        }
        else if (event.key.keysym.sym == down_key)
        {
            my_list.push_back(DOWN_KEY_RELEASED);
        }
        else if (event.key.keysym.sym == left_key)
        {
            my_list.push_back(LEFT_KEY_RELEASED);
        } // if ... else
    } 
    else if ( joystick_selected && (event.type == SDL_JOYAXISMOTION) )
    {
        if ( event.jaxis.axis == 0 ) // left/right
        {
            if ( event.jaxis.value < -3200 )
            {
                my_list.push_back(LEFT_KEY_PRESSED);
                last_horizontal_event = LEFT_KEY_PRESSED;
            }
            else if ( !event.jaxis.value )
            {
                my_list.push_back( (last_horizontal_event == LEFT_KEY_PRESSED) ? 
                        LEFT_KEY_RELEASED : RIGHT_KEY_RELEASED );
            }
            else if ( event.jaxis.value > 3200 ) 
            {
                my_list.push_back(RIGHT_KEY_PRESSED);
                last_horizontal_event = RIGHT_KEY_PRESSED;
            } // if ... else
        }
        else if ( event.jaxis.axis == 1 ) 
        {
            if ( event.jaxis.value < -3200 )
            {
                my_list.push_back(UP_KEY_PRESSED);
                last_vertical_event = UP_KEY_PRESSED;
            }
            else if ( !event.jaxis.value )
            {
                my_list.push_back( (last_vertical_event == UP_KEY_PRESSED) ? 
                        UP_KEY_RELEASED : DOWN_KEY_RELEASED );
            }
            else if ( event.jaxis.value > 3200 )
            {
                my_list.push_back(DOWN_KEY_PRESSED);
                last_vertical_event = DOWN_KEY_PRESSED;
            } // if ... else
        } // if ... else
    }
    else if (joystick_selected && event.type == SDL_JOYBUTTONDOWN)
    {
        if ( event.jbutton.button == 1 )
        {
            my_list.push_back(ESCAPE_PRESSED);
        }
        else
        {
            my_list.push_back(JUMP_KEY_PRESSED);
        } // if ... else
    } // if ... else
    
} // FS::User_input::add_event

// **************************************************

bool FS::User_input::write_to_file( std::ofstream& fout ) const
{
    // NYI...
    return true;
    
} // FS::User_input::write_to_file

// **************************************************

bool FS::User_input::next_event( Keyboard_Event& ke )
{
    if ( my_list.empty() ) 
    {
        return false;
    }
    else
    {
        ke = my_list.front();
        my_list.pop_front();    // now erase!
        return true;
    } // if ... else
    
} // FS::User_input::next_event

// **************************************************

void FS::User_input::add_keydown_event( const SDL_Event& event )
{
    my_keydown_list.push_back( event.key.keysym );
    
} // FS::User_input::add_keydown_event

// **************************************************

bool FS::User_input::next_keydown_event( SDL_keysym& ks )
{
    if ( my_keydown_list.empty() )
    {
        return false;
    }
    else
    {
        ks = my_keydown_list.front();
        my_keydown_list.pop_front();
        return true;
    } // if ... else
    
} // FS::User_input::next_keydown_event

// **************************************************
