// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "Pause_menu.h"




// *******************
// *** CONSTRUCTOR ***
// *******************
FS::Pause_menu::Pause_menu()
{
   // ...

} // FS::Pause_menu::Pause_menu

// ******************
// *** DESTRUCTOR ***
// ******************
FS::Pause_menu::~Pause_menu()
{
    // ...
    
} // FS::Pause_menu::~Pause_menu




// ************************
// *** MEMBER FUNCTIONS ***
// ************************

// **************************************************

void FS::Pause_menu::reset()
{
    current_selection = PMS_CONTINUE;    // this is the default
    
} // FS::Pause_menu::reset

// **************************************************

FS::Pause_menu::Pause_menu_selection FS::Pause_menu::update()
{
    bool selection_made = false;
    User_input::Keyboard_Event ke;
    
    while ( input_ptr->next_event(ke) )
    {
        if (User_input::ESCAPE_PRESSED == ke)
        {
            current_selection = PMS_CONTINUE;
            selection_made = true;
            break;
        }
        else if (User_input::JUMP_KEY_PRESSED == ke)
        {
            selection_made = true;
            break;
        }
        else if (User_input::UP_KEY_PRESSED == ke || User_input::DOWN_KEY_PRESSED == ke)
        {
            current_selection = ((PMS_CONTINUE == current_selection) ?
                    PMS_QUIT : PMS_CONTINUE);
        } // if ... else
    } // while
    
    if (selection_made)
    {
        return current_selection;
    }
    else
    {
        return PMS_NONE;
    } // if ... else
  
} // FS::Pause_menu::update

// **************************************************
        
void FS::Pause_menu::draw()
{
    if ( PMS_CONTINUE == current_selection )
    {
        gfx_ptr->draw_texture( FS_gfx::PAUSE_MENU_CONTINUE, Menu_x, Menu_y );
    }
    else
    {
        gfx_ptr->draw_texture( FS_gfx::PAUSE_MENU_QUIT, Menu_x, Menu_y );
    } // if ... else

} // FS::Pause_menu::draw

// **************************************************

bool FS::Pause_menu::has_pressed_jump() const
{
    bool jump_pressed = false;
    User_input::Keyboard_Event ke;

    while ( input_ptr->next_event(ke) )
    {
        if ( User_input::JUMP_KEY_PRESSED == ke )
        {
            jump_pressed = true;
        } // if
    } // while
    
    return jump_pressed;
    
} // FS::Pause_menu::has_pressed_jump
