// Copyright 2022-2025 The sacloud/iaas-api-go Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// generated by 'github.com/sacloud/iaas-api-go/internal/tools/gen-api-envelope'; DO NOT EDIT

package iaas

import (
	"time"

	"github.com/sacloud/iaas-api-go/naked"
	"github.com/sacloud/iaas-api-go/search"
	"github.com/sacloud/iaas-api-go/types"
)

// archiveFindRequestEnvelope is envelop of API request
type archiveFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// archiveFindResponseEnvelope is envelop of API response
type archiveFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Archives []*naked.Archive `json:",omitempty"`
}

// archiveCreateRequestEnvelope is envelop of API request
type archiveCreateRequestEnvelope struct {
	Archive *naked.Archive `json:",omitempty"`
}

// archiveCreateResponseEnvelope is envelop of API response
type archiveCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Archive *naked.Archive `json:",omitempty"`
}

// archiveCreateBlankRequestEnvelope is envelop of API request
type archiveCreateBlankRequestEnvelope struct {
	Archive *naked.Archive `json:",omitempty"`
}

// archiveCreateBlankResponseEnvelope is envelop of API response
type archiveCreateBlankResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Archive   *naked.Archive          `json:",omitempty"`
	FTPServer *naked.OpeningFTPServer `json:",omitempty"`
}

// archiveReadResponseEnvelope is envelop of API response
type archiveReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Archive *naked.Archive `json:",omitempty"`
}

// archiveUpdateRequestEnvelope is envelop of API request
type archiveUpdateRequestEnvelope struct {
	Archive *naked.Archive `json:",omitempty"`
}

// archiveUpdateResponseEnvelope is envelop of API response
type archiveUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Archive *naked.Archive `json:",omitempty"`
}

// archiveOpenFTPRequestEnvelope is envelop of API request
type archiveOpenFTPRequestEnvelope struct {
	ChangePassword bool `json:",omitempty"`
}

// archiveOpenFTPResponseEnvelope is envelop of API response
type archiveOpenFTPResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	FTPServer *naked.OpeningFTPServer `json:",omitempty"`
}

// archiveShareRequestEnvelope is envelop of API request
type archiveShareRequestEnvelope struct {
	Shared bool `json:",omitempty"`
}

// archiveShareResponseEnvelope is envelop of API response
type archiveShareResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	ArchiveShareInfo *naked.ArchiveShareInfo `json:",omitempty"`
}

// archiveCreateFromSharedRequestEnvelope is envelop of API request
type archiveCreateFromSharedRequestEnvelope struct {
	Archive *naked.Archive `json:",omitempty"`
}

// archiveCreateFromSharedResponseEnvelope is envelop of API response
type archiveCreateFromSharedResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Archive *naked.Archive `json:",omitempty"`
}

// archiveTransferRequestEnvelope is envelop of API request
type archiveTransferRequestEnvelope struct {
	Archive *naked.Archive `json:",omitempty"`
}

// archiveTransferResponseEnvelope is envelop of API response
type archiveTransferResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Archive *naked.Archive `json:",omitempty"`
}

// authStatusReadResponseEnvelope is envelop of API response
type authStatusReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	AuthStatus *naked.AuthStatus `json:",omitempty"`
}

// autoBackupFindRequestEnvelope is envelop of API request
type autoBackupFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// autoBackupFindResponseEnvelope is envelop of API response
type autoBackupFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	CommonServiceItems []*naked.AutoBackup `json:",omitempty"`
}

// autoBackupCreateRequestEnvelope is envelop of API request
type autoBackupCreateRequestEnvelope struct {
	CommonServiceItem *naked.AutoBackup `json:",omitempty"`
}

// autoBackupCreateResponseEnvelope is envelop of API response
type autoBackupCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.AutoBackup `json:",omitempty"`
}

// autoBackupReadResponseEnvelope is envelop of API response
type autoBackupReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.AutoBackup `json:",omitempty"`
}

// autoBackupUpdateRequestEnvelope is envelop of API request
type autoBackupUpdateRequestEnvelope struct {
	CommonServiceItem *naked.AutoBackup `json:",omitempty"`
}

// autoBackupUpdateResponseEnvelope is envelop of API response
type autoBackupUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.AutoBackup `json:",omitempty"`
}

// autoBackupUpdateSettingsRequestEnvelope is envelop of API request
type autoBackupUpdateSettingsRequestEnvelope struct {
	CommonServiceItem *naked.AutoBackupSettingsUpdate `json:",omitempty"`
}

// autoBackupUpdateSettingsResponseEnvelope is envelop of API response
type autoBackupUpdateSettingsResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.AutoBackup `json:",omitempty"`
}

// autoScaleFindRequestEnvelope is envelop of API request
type autoScaleFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// autoScaleFindResponseEnvelope is envelop of API response
type autoScaleFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	CommonServiceItems []*naked.AutoScale `json:",omitempty"`
}

// autoScaleCreateRequestEnvelope is envelop of API request
type autoScaleCreateRequestEnvelope struct {
	CommonServiceItem *naked.AutoScale `json:",omitempty"`
}

// autoScaleCreateResponseEnvelope is envelop of API response
type autoScaleCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.AutoScale `json:",omitempty"`
}

// autoScaleReadResponseEnvelope is envelop of API response
type autoScaleReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.AutoScale `json:",omitempty"`
}

// autoScaleUpdateRequestEnvelope is envelop of API request
type autoScaleUpdateRequestEnvelope struct {
	CommonServiceItem *naked.AutoScale `json:",omitempty"`
}

// autoScaleUpdateResponseEnvelope is envelop of API response
type autoScaleUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.AutoScale `json:",omitempty"`
}

// autoScaleUpdateSettingsRequestEnvelope is envelop of API request
type autoScaleUpdateSettingsRequestEnvelope struct {
	CommonServiceItem *naked.AutoScaleSettingsUpdate `json:",omitempty"`
}

// autoScaleUpdateSettingsResponseEnvelope is envelop of API response
type autoScaleUpdateSettingsResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.AutoScale `json:",omitempty"`
}

// autoScaleStatusResponseEnvelope is envelop of API response
type autoScaleStatusResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	AutoScale *naked.AutoScaleRunningStatus `json:",omitempty"`
}

// billByContractResponseEnvelope is envelop of API response
type billByContractResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Bills []*naked.Bill `json:",omitempty"`
}

// billByContractYearResponseEnvelope is envelop of API response
type billByContractYearResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Bills []*naked.Bill `json:",omitempty"`
}

// billByContractYearMonthResponseEnvelope is envelop of API response
type billByContractYearMonthResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Bills []*naked.Bill `json:",omitempty"`
}

// billReadResponseEnvelope is envelop of API response
type billReadResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Bills []*naked.Bill `json:",omitempty"`
}

// billDetailsResponseEnvelope is envelop of API response
type billDetailsResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	BillDetails []*naked.BillDetail `json:",omitempty"`
}

// billDetailsCSVResponseEnvelope is envelop of API response
type billDetailsCSVResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CSV *naked.BillDetailCSV `json:",omitempty"`
}

// bridgeFindRequestEnvelope is envelop of API request
type bridgeFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// bridgeFindResponseEnvelope is envelop of API response
type bridgeFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Bridges []*naked.Bridge `json:",omitempty"`
}

// bridgeCreateRequestEnvelope is envelop of API request
type bridgeCreateRequestEnvelope struct {
	Bridge *naked.Bridge `json:",omitempty"`
}

// bridgeCreateResponseEnvelope is envelop of API response
type bridgeCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Bridge *naked.Bridge `json:",omitempty"`
}

// bridgeReadResponseEnvelope is envelop of API response
type bridgeReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Bridge *naked.Bridge `json:",omitempty"`
}

// bridgeUpdateRequestEnvelope is envelop of API request
type bridgeUpdateRequestEnvelope struct {
	Bridge *naked.Bridge `json:",omitempty"`
}

// bridgeUpdateResponseEnvelope is envelop of API response
type bridgeUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Bridge *naked.Bridge `json:",omitempty"`
}

// cDROMFindRequestEnvelope is envelop of API request
type cDROMFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// cDROMFindResponseEnvelope is envelop of API response
type cDROMFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	CDROMs []*naked.CDROM `json:",omitempty"`
}

// cDROMCreateRequestEnvelope is envelop of API request
type cDROMCreateRequestEnvelope struct {
	CDROM *naked.CDROM `json:",omitempty"`
}

// cDROMCreateResponseEnvelope is envelop of API response
type cDROMCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CDROM     *naked.CDROM            `json:",omitempty"`
	FTPServer *naked.OpeningFTPServer `json:",omitempty"`
}

// cDROMReadResponseEnvelope is envelop of API response
type cDROMReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CDROM *naked.CDROM `json:",omitempty"`
}

// cDROMUpdateRequestEnvelope is envelop of API request
type cDROMUpdateRequestEnvelope struct {
	CDROM *naked.CDROM `json:",omitempty"`
}

// cDROMUpdateResponseEnvelope is envelop of API response
type cDROMUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CDROM *naked.CDROM `json:",omitempty"`
}

// cDROMOpenFTPRequestEnvelope is envelop of API request
type cDROMOpenFTPRequestEnvelope struct {
	ChangePassword bool `json:",omitempty"`
}

// cDROMOpenFTPResponseEnvelope is envelop of API response
type cDROMOpenFTPResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	FTPServer *naked.OpeningFTPServer `json:",omitempty"`
}

// certificateAuthorityFindRequestEnvelope is envelop of API request
type certificateAuthorityFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// certificateAuthorityFindResponseEnvelope is envelop of API response
type certificateAuthorityFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	CommonServiceItems []*naked.CertificateAuthority `json:",omitempty"`
}

// certificateAuthorityCreateRequestEnvelope is envelop of API request
type certificateAuthorityCreateRequestEnvelope struct {
	CommonServiceItem *naked.CertificateAuthority `json:",omitempty"`
}

// certificateAuthorityCreateResponseEnvelope is envelop of API response
type certificateAuthorityCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.CertificateAuthority `json:",omitempty"`
}

// certificateAuthorityReadResponseEnvelope is envelop of API response
type certificateAuthorityReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.CertificateAuthority `json:",omitempty"`
}

// certificateAuthorityUpdateRequestEnvelope is envelop of API request
type certificateAuthorityUpdateRequestEnvelope struct {
	CommonServiceItem *naked.CertificateAuthority `json:",omitempty"`
}

// certificateAuthorityUpdateResponseEnvelope is envelop of API response
type certificateAuthorityUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.CertificateAuthority `json:",omitempty"`
}

// certificateAuthorityDetailResponseEnvelope is envelop of API response
type certificateAuthorityDetailResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CertificateAuthority *naked.CertificateAuthorityDetail `json:",omitempty"`
}

// certificateAuthorityAddClientRequestEnvelope is envelop of API request
type certificateAuthorityAddClientRequestEnvelope struct {
	CertificateAuthority *naked.CertificateAuthorityAddClientParameter `json:",omitempty"`
}

// certificateAuthorityAddClientResponseEnvelope is envelop of API response
type certificateAuthorityAddClientResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CertificateAuthority *naked.CertificateAuthorityAddClientOrServerResult `json:",omitempty"`
}

// certificateAuthorityListClientsResponseEnvelope is envelop of API response
type certificateAuthorityListClientsResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	CertificateAuthority []*naked.CertificateAuthorityClientDetail `json:",omitempty"`
}

// certificateAuthorityReadClientResponseEnvelope is envelop of API response
type certificateAuthorityReadClientResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CertificateAuthority *naked.CertificateAuthorityClientDetail `json:",omitempty"`
}

// certificateAuthorityAddServerRequestEnvelope is envelop of API request
type certificateAuthorityAddServerRequestEnvelope struct {
	CertificateAuthority *naked.CertificateAuthorityAddServerParameter `json:",omitempty"`
}

// certificateAuthorityAddServerResponseEnvelope is envelop of API response
type certificateAuthorityAddServerResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CertificateAuthority *naked.CertificateAuthorityAddClientOrServerResult `json:",omitempty"`
}

// certificateAuthorityListServersResponseEnvelope is envelop of API response
type certificateAuthorityListServersResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	CertificateAuthority []*naked.CertificateAuthorityServerDetail `json:",omitempty"`
}

// certificateAuthorityReadServerResponseEnvelope is envelop of API response
type certificateAuthorityReadServerResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CertificateAuthority *naked.CertificateAuthorityServerDetail `json:",omitempty"`
}

// containerRegistryFindRequestEnvelope is envelop of API request
type containerRegistryFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// containerRegistryFindResponseEnvelope is envelop of API response
type containerRegistryFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	CommonServiceItems []*naked.ContainerRegistry `json:",omitempty"`
}

// containerRegistryCreateRequestEnvelope is envelop of API request
type containerRegistryCreateRequestEnvelope struct {
	CommonServiceItem *naked.ContainerRegistry `json:",omitempty"`
}

// containerRegistryCreateResponseEnvelope is envelop of API response
type containerRegistryCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.ContainerRegistry `json:",omitempty"`
}

// containerRegistryReadResponseEnvelope is envelop of API response
type containerRegistryReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.ContainerRegistry `json:",omitempty"`
}

// containerRegistryUpdateRequestEnvelope is envelop of API request
type containerRegistryUpdateRequestEnvelope struct {
	CommonServiceItem *naked.ContainerRegistry `json:",omitempty"`
}

// containerRegistryUpdateResponseEnvelope is envelop of API response
type containerRegistryUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.ContainerRegistry `json:",omitempty"`
}

// containerRegistryUpdateSettingsRequestEnvelope is envelop of API request
type containerRegistryUpdateSettingsRequestEnvelope struct {
	CommonServiceItem *naked.ContainerRegistrySettingsUpdate `json:",omitempty"`
}

// containerRegistryUpdateSettingsResponseEnvelope is envelop of API response
type containerRegistryUpdateSettingsResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.ContainerRegistry `json:",omitempty"`
}

// containerRegistryListUsersResponseEnvelope is envelop of API response
type containerRegistryListUsersResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	ContainerRegistry *naked.ContainerRegistryUsers `json:",omitempty"`
}

// containerRegistryAddUserRequestEnvelope is envelop of API request
type containerRegistryAddUserRequestEnvelope struct {
	ContainerRegistry *naked.ContainerRegistryUser `json:",omitempty"`
}

// containerRegistryUpdateUserRequestEnvelope is envelop of API request
type containerRegistryUpdateUserRequestEnvelope struct {
	ContainerRegistry *naked.ContainerRegistryUser `json:",omitempty"`
}

// couponFindResponseEnvelope is envelop of API response
type couponFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Coupon []*naked.Coupon `json:",omitempty"`
}

// databaseFindRequestEnvelope is envelop of API request
type databaseFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// databaseFindResponseEnvelope is envelop of API response
type databaseFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Appliances []*naked.Database `json:",omitempty"`
}

// databaseCreateRequestEnvelope is envelop of API request
type databaseCreateRequestEnvelope struct {
	Appliance *naked.Database `json:",omitempty"`
}

// databaseCreateResponseEnvelope is envelop of API response
type databaseCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Appliance *naked.Database `json:",omitempty"`
}

// databaseReadResponseEnvelope is envelop of API response
type databaseReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Appliance *naked.Database `json:",omitempty"`
}

// databaseUpdateRequestEnvelope is envelop of API request
type databaseUpdateRequestEnvelope struct {
	Appliance *naked.Database `json:",omitempty"`
}

// databaseUpdateResponseEnvelope is envelop of API response
type databaseUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Appliance *naked.Database `json:",omitempty"`
}

// databaseUpdateSettingsRequestEnvelope is envelop of API request
type databaseUpdateSettingsRequestEnvelope struct {
	Appliance *naked.DatabaseSettingsUpdate `json:",omitempty"`
}

// databaseUpdateSettingsResponseEnvelope is envelop of API response
type databaseUpdateSettingsResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Appliance *naked.Database `json:",omitempty"`
}

// databaseShutdownRequestEnvelope is envelop of API request
type databaseShutdownRequestEnvelope struct {
	Force bool `json:",omitempty"`
}

// databaseMonitorCPURequestEnvelope is envelop of API request
type databaseMonitorCPURequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// databaseMonitorCPUResponseEnvelope is envelop of API response
type databaseMonitorCPUResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// databaseMonitorDiskRequestEnvelope is envelop of API request
type databaseMonitorDiskRequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// databaseMonitorDiskResponseEnvelope is envelop of API response
type databaseMonitorDiskResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// databaseMonitorInterfaceRequestEnvelope is envelop of API request
type databaseMonitorInterfaceRequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// databaseMonitorInterfaceResponseEnvelope is envelop of API response
type databaseMonitorInterfaceResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// databaseMonitorDatabaseRequestEnvelope is envelop of API request
type databaseMonitorDatabaseRequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// databaseMonitorDatabaseResponseEnvelope is envelop of API response
type databaseMonitorDatabaseResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// databaseStatusResponseEnvelope is envelop of API response
type databaseStatusResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Appliance *naked.DatabaseStatusResponse `json:",omitempty"`
}

// databaseGetParameterResponseEnvelope is envelop of API response
type databaseGetParameterResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Database *naked.DatabaseParameter `json:",omitempty"`
}

// databaseSetParameterRequestEnvelope is envelop of API request
type databaseSetParameterRequestEnvelope struct {
	Parameter *naked.DatabaseParameterSetting `json:",omitempty"`
}

// diskFindRequestEnvelope is envelop of API request
type diskFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// diskFindResponseEnvelope is envelop of API response
type diskFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Disks []*naked.Disk `json:",omitempty"`
}

// diskCreateRequestEnvelope is envelop of API request
type diskCreateRequestEnvelope struct {
	Disk        *naked.Disk   `json:",omitempty"`
	DistantFrom []types.ID    `json:",omitempty"`
	KMSKey      *naked.KMSKey `json:",omitempty"`
}

// diskCreateResponseEnvelope is envelop of API response
type diskCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Disk *naked.Disk `json:",omitempty"`
}

// diskConfigRequestEnvelope is envelop of API request
type diskConfigRequestEnvelope struct {
	Background          bool                  `json:",omitempty" mapconv:",omitempty"`
	Password            string                `json:",omitempty" mapconv:",omitempty"`
	SSHKey              *DiskEditSSHKey       `json:",omitempty" mapconv:",omitempty,recursive"`
	SSHKeys             []*DiskEditSSHKey     `json:",omitempty" mapconv:"[]SSHKeys,omitempty,recursive"`
	DisablePWAuth       bool                  `json:",omitempty" mapconv:",omitempty"`
	EnableDHCP          bool                  `json:",omitempty" mapconv:",omitempty"`
	ChangePartitionUUID bool                  `json:",omitempty" mapconv:",omitempty"`
	HostName            string                `json:",omitempty" mapconv:",omitempty"`
	Notes               []*naked.DiskEditNote `json:",omitempty" mapconv:"[]Notes,omitempty,recursive"`
	UserIPAddress       string                `json:",omitempty" mapconv:",omitempty"`
	UserSubnet          *DiskEditUserSubnet   `json:",omitempty" mapconv:",omitempty"`
}

// diskCreateWithConfigRequestEnvelope is envelop of API request
type diskCreateWithConfigRequestEnvelope struct {
	Disk            *naked.Disk     `json:",omitempty"`
	Config          *naked.DiskEdit `json:",omitempty"`
	BootAtAvailable bool            `json:",omitempty"`
	DistantFrom     []types.ID      `json:",omitempty"`
	KMSKey          *naked.KMSKey   `json:",omitempty"`
}

// diskCreateWithConfigResponseEnvelope is envelop of API response
type diskCreateWithConfigResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Disk *naked.Disk `json:",omitempty"`
}

// diskResizePartitionRequestEnvelope is envelop of API request
type diskResizePartitionRequestEnvelope struct {
	Background bool `json:",omitempty"`
}

// diskReadResponseEnvelope is envelop of API response
type diskReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Disk *naked.Disk `json:",omitempty"`
}

// diskUpdateRequestEnvelope is envelop of API request
type diskUpdateRequestEnvelope struct {
	Disk *naked.Disk `json:",omitempty"`
}

// diskUpdateResponseEnvelope is envelop of API response
type diskUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Disk *naked.Disk `json:",omitempty"`
}

// diskMonitorRequestEnvelope is envelop of API request
type diskMonitorRequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// diskMonitorResponseEnvelope is envelop of API response
type diskMonitorResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// diskMonitorDiskRequestEnvelope is envelop of API request
type diskMonitorDiskRequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// diskMonitorDiskResponseEnvelope is envelop of API response
type diskMonitorDiskResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// diskPlanFindRequestEnvelope is envelop of API request
type diskPlanFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// diskPlanFindResponseEnvelope is envelop of API response
type diskPlanFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	DiskPlans []*naked.DiskPlan `json:",omitempty"`
}

// diskPlanReadResponseEnvelope is envelop of API response
type diskPlanReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	DiskPlan *naked.DiskPlan `json:",omitempty"`
}

// dNSFindRequestEnvelope is envelop of API request
type dNSFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// dNSFindResponseEnvelope is envelop of API response
type dNSFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	CommonServiceItems []*naked.DNS `json:",omitempty"`
}

// dNSCreateRequestEnvelope is envelop of API request
type dNSCreateRequestEnvelope struct {
	CommonServiceItem *naked.DNS `json:",omitempty"`
}

// dNSCreateResponseEnvelope is envelop of API response
type dNSCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.DNS `json:",omitempty"`
}

// dNSReadResponseEnvelope is envelop of API response
type dNSReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.DNS `json:",omitempty"`
}

// dNSUpdateRequestEnvelope is envelop of API request
type dNSUpdateRequestEnvelope struct {
	CommonServiceItem *naked.DNS `json:",omitempty"`
}

// dNSUpdateResponseEnvelope is envelop of API response
type dNSUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.DNS `json:",omitempty"`
}

// dNSUpdateSettingsRequestEnvelope is envelop of API request
type dNSUpdateSettingsRequestEnvelope struct {
	CommonServiceItem *naked.DNSSettingsUpdate `json:",omitempty"`
}

// dNSUpdateSettingsResponseEnvelope is envelop of API response
type dNSUpdateSettingsResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.DNS `json:",omitempty"`
}

// enhancedDBFindRequestEnvelope is envelop of API request
type enhancedDBFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// enhancedDBFindResponseEnvelope is envelop of API response
type enhancedDBFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	CommonServiceItems []*naked.EnhancedDB `json:",omitempty"`
}

// enhancedDBCreateRequestEnvelope is envelop of API request
type enhancedDBCreateRequestEnvelope struct {
	CommonServiceItem *naked.EnhancedDB `json:",omitempty"`
}

// enhancedDBCreateResponseEnvelope is envelop of API response
type enhancedDBCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.EnhancedDB `json:",omitempty"`
}

// enhancedDBReadResponseEnvelope is envelop of API response
type enhancedDBReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.EnhancedDB `json:",omitempty"`
}

// enhancedDBUpdateRequestEnvelope is envelop of API request
type enhancedDBUpdateRequestEnvelope struct {
	CommonServiceItem *naked.EnhancedDB `json:",omitempty"`
}

// enhancedDBUpdateResponseEnvelope is envelop of API response
type enhancedDBUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.EnhancedDB `json:",omitempty"`
}

// enhancedDBSetPasswordRequestEnvelope is envelop of API request
type enhancedDBSetPasswordRequestEnvelope struct {
	CommonServiceItem *naked.EnhancedDBPasswordSettings `json:",omitempty"`
}

// enhancedDBGetConfigResponseEnvelope is envelop of API response
type enhancedDBGetConfigResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	EnhancedDB *naked.EnhancedDBConfig `json:",omitempty"`
}

// enhancedDBSetConfigRequestEnvelope is envelop of API request
type enhancedDBSetConfigRequestEnvelope struct {
	CommonServiceItem *naked.EnhancedDBConfigSettings `json:",omitempty"`
}

// eSMEFindRequestEnvelope is envelop of API request
type eSMEFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// eSMEFindResponseEnvelope is envelop of API response
type eSMEFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	CommonServiceItems []*naked.ESME `json:",omitempty"`
}

// eSMECreateRequestEnvelope is envelop of API request
type eSMECreateRequestEnvelope struct {
	CommonServiceItem *naked.ESME `json:",omitempty"`
}

// eSMECreateResponseEnvelope is envelop of API response
type eSMECreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.ESME `json:",omitempty"`
}

// eSMEReadResponseEnvelope is envelop of API response
type eSMEReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.ESME `json:",omitempty"`
}

// eSMEUpdateRequestEnvelope is envelop of API request
type eSMEUpdateRequestEnvelope struct {
	CommonServiceItem *naked.ESME `json:",omitempty"`
}

// eSMEUpdateResponseEnvelope is envelop of API response
type eSMEUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.ESME `json:",omitempty"`
}

// eSMESendMessageWithGeneratedOTPRequestEnvelope is envelop of API request
type eSMESendMessageWithGeneratedOTPRequestEnvelope struct {
	ESME *naked.ESMESendSMSRequest `json:",omitempty"`
}

// eSMESendMessageWithGeneratedOTPResponseEnvelope is envelop of API response
type eSMESendMessageWithGeneratedOTPResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	ESME *naked.ESMESendSMSResponse `json:",omitempty"`
}

// eSMESendMessageWithInputtedOTPRequestEnvelope is envelop of API request
type eSMESendMessageWithInputtedOTPRequestEnvelope struct {
	ESME *naked.ESMESendSMSRequest `json:",omitempty"`
}

// eSMESendMessageWithInputtedOTPResponseEnvelope is envelop of API response
type eSMESendMessageWithInputtedOTPResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	ESME *naked.ESMESendSMSResponse `json:",omitempty"`
}

// eSMELogsResponseEnvelope is envelop of API response
type eSMELogsResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	ESME *naked.ESMELogs `json:",omitempty"`
}

// gSLBFindRequestEnvelope is envelop of API request
type gSLBFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// gSLBFindResponseEnvelope is envelop of API response
type gSLBFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	CommonServiceItems []*naked.GSLB `json:",omitempty"`
}

// gSLBCreateRequestEnvelope is envelop of API request
type gSLBCreateRequestEnvelope struct {
	CommonServiceItem *naked.GSLB `json:",omitempty"`
}

// gSLBCreateResponseEnvelope is envelop of API response
type gSLBCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.GSLB `json:",omitempty"`
}

// gSLBReadResponseEnvelope is envelop of API response
type gSLBReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.GSLB `json:",omitempty"`
}

// gSLBUpdateRequestEnvelope is envelop of API request
type gSLBUpdateRequestEnvelope struct {
	CommonServiceItem *naked.GSLB `json:",omitempty"`
}

// gSLBUpdateResponseEnvelope is envelop of API response
type gSLBUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.GSLB `json:",omitempty"`
}

// gSLBUpdateSettingsRequestEnvelope is envelop of API request
type gSLBUpdateSettingsRequestEnvelope struct {
	CommonServiceItem *naked.GSLBSettingsUpdate `json:",omitempty"`
}

// gSLBUpdateSettingsResponseEnvelope is envelop of API response
type gSLBUpdateSettingsResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.GSLB `json:",omitempty"`
}

// iconFindRequestEnvelope is envelop of API request
type iconFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// iconFindResponseEnvelope is envelop of API response
type iconFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Icons []*naked.Icon `json:",omitempty"`
}

// iconCreateRequestEnvelope is envelop of API request
type iconCreateRequestEnvelope struct {
	Icon *naked.Icon `json:",omitempty"`
}

// iconCreateResponseEnvelope is envelop of API response
type iconCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Icon *naked.Icon `json:",omitempty"`
}

// iconReadResponseEnvelope is envelop of API response
type iconReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Icon *naked.Icon `json:",omitempty"`
}

// iconUpdateRequestEnvelope is envelop of API request
type iconUpdateRequestEnvelope struct {
	Icon *naked.Icon `json:",omitempty"`
}

// iconUpdateResponseEnvelope is envelop of API response
type iconUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Icon *naked.Icon `json:",omitempty"`
}

// interfaceFindRequestEnvelope is envelop of API request
type interfaceFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// interfaceFindResponseEnvelope is envelop of API response
type interfaceFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Interfaces []*naked.Interface `json:",omitempty"`
}

// interfaceCreateRequestEnvelope is envelop of API request
type interfaceCreateRequestEnvelope struct {
	Interface *naked.Interface `json:",omitempty"`
}

// interfaceCreateResponseEnvelope is envelop of API response
type interfaceCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Interface *naked.Interface `json:",omitempty"`
}

// interfaceReadResponseEnvelope is envelop of API response
type interfaceReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Interface *naked.Interface `json:",omitempty"`
}

// interfaceUpdateRequestEnvelope is envelop of API request
type interfaceUpdateRequestEnvelope struct {
	Interface *naked.Interface `json:",omitempty"`
}

// interfaceUpdateResponseEnvelope is envelop of API response
type interfaceUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Interface *naked.Interface `json:",omitempty"`
}

// interfaceMonitorRequestEnvelope is envelop of API request
type interfaceMonitorRequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// interfaceMonitorResponseEnvelope is envelop of API response
type interfaceMonitorResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// internetFindRequestEnvelope is envelop of API request
type internetFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// internetFindResponseEnvelope is envelop of API response
type internetFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Internet []*naked.Internet `json:",omitempty"`
}

// internetCreateRequestEnvelope is envelop of API request
type internetCreateRequestEnvelope struct {
	Internet *naked.Internet `json:",omitempty"`
}

// internetCreateResponseEnvelope is envelop of API response
type internetCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Internet *naked.Internet `json:",omitempty"`
}

// internetReadResponseEnvelope is envelop of API response
type internetReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Internet *naked.Internet `json:",omitempty"`
}

// internetUpdateRequestEnvelope is envelop of API request
type internetUpdateRequestEnvelope struct {
	Internet *naked.Internet `json:",omitempty"`
}

// internetUpdateResponseEnvelope is envelop of API response
type internetUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Internet *naked.Internet `json:",omitempty"`
}

// internetUpdateBandWidthRequestEnvelope is envelop of API request
type internetUpdateBandWidthRequestEnvelope struct {
	Internet *naked.Internet `json:",omitempty"`
}

// internetUpdateBandWidthResponseEnvelope is envelop of API response
type internetUpdateBandWidthResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Internet *naked.Internet `json:",omitempty"`
}

// internetAddSubnetRequestEnvelope is envelop of API request
type internetAddSubnetRequestEnvelope struct {
	NetworkMaskLen int    `json:",omitempty"`
	NextHop        string `json:",omitempty"`
}

// internetAddSubnetResponseEnvelope is envelop of API response
type internetAddSubnetResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Subnet *naked.Subnet `json:",omitempty"`
}

// internetUpdateSubnetRequestEnvelope is envelop of API request
type internetUpdateSubnetRequestEnvelope struct {
	NextHop string `json:",omitempty"`
}

// internetUpdateSubnetResponseEnvelope is envelop of API response
type internetUpdateSubnetResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Subnet *naked.Subnet `json:",omitempty"`
}

// internetMonitorRequestEnvelope is envelop of API request
type internetMonitorRequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// internetMonitorResponseEnvelope is envelop of API response
type internetMonitorResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// internetMonitorRouterRequestEnvelope is envelop of API request
type internetMonitorRouterRequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// internetMonitorRouterResponseEnvelope is envelop of API response
type internetMonitorRouterResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// internetEnableIPv6ResponseEnvelope is envelop of API response
type internetEnableIPv6ResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	IPv6Net *naked.IPv6Net `json:",omitempty"`
}

// internetPlanFindRequestEnvelope is envelop of API request
type internetPlanFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// internetPlanFindResponseEnvelope is envelop of API response
type internetPlanFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	InternetPlans []*naked.InternetPlan `json:",omitempty"`
}

// internetPlanReadResponseEnvelope is envelop of API response
type internetPlanReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	InternetPlan *naked.InternetPlan `json:",omitempty"`
}

// iPAddressListResponseEnvelope is envelop of API response
type iPAddressListResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	IPAddress []*naked.IPAddress `json:",omitempty"`
}

// iPAddressReadResponseEnvelope is envelop of API response
type iPAddressReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	IPAddress *naked.IPAddress `json:",omitempty"`
}

// iPAddressUpdateHostNameRequestEnvelope is envelop of API request
type iPAddressUpdateHostNameRequestEnvelope struct {
	IPAddress *naked.IPAddress `json:",omitempty"`
}

// iPAddressUpdateHostNameResponseEnvelope is envelop of API response
type iPAddressUpdateHostNameResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	IPAddress *naked.IPAddress `json:",omitempty"`
}

// iPv6NetListResponseEnvelope is envelop of API response
type iPv6NetListResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	IPv6Nets []*naked.IPv6Net `json:",omitempty"`
}

// iPv6NetFindRequestEnvelope is envelop of API request
type iPv6NetFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// iPv6NetFindResponseEnvelope is envelop of API response
type iPv6NetFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	IPv6Nets []*naked.IPv6Net `json:",omitempty"`
}

// iPv6NetReadResponseEnvelope is envelop of API response
type iPv6NetReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	IPv6Net *naked.IPv6Net `json:",omitempty"`
}

// iPv6AddrFindRequestEnvelope is envelop of API request
type iPv6AddrFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// iPv6AddrFindResponseEnvelope is envelop of API response
type iPv6AddrFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	IPv6Addrs []*naked.IPv6Addr `json:",omitempty"`
}

// iPv6AddrCreateRequestEnvelope is envelop of API request
type iPv6AddrCreateRequestEnvelope struct {
	IPv6Addr *naked.IPv6Addr `json:",omitempty"`
}

// iPv6AddrCreateResponseEnvelope is envelop of API response
type iPv6AddrCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	IPv6Addr *naked.IPv6Addr `json:",omitempty"`
}

// iPv6AddrReadResponseEnvelope is envelop of API response
type iPv6AddrReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	IPv6Addr *naked.IPv6Addr `json:",omitempty"`
}

// iPv6AddrUpdateRequestEnvelope is envelop of API request
type iPv6AddrUpdateRequestEnvelope struct {
	IPv6Addr *naked.IPv6Addr `json:",omitempty"`
}

// iPv6AddrUpdateResponseEnvelope is envelop of API response
type iPv6AddrUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	IPv6Addr *naked.IPv6Addr `json:",omitempty"`
}

// licenseFindRequestEnvelope is envelop of API request
type licenseFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// licenseFindResponseEnvelope is envelop of API response
type licenseFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Licenses []*naked.License `json:",omitempty"`
}

// licenseCreateRequestEnvelope is envelop of API request
type licenseCreateRequestEnvelope struct {
	License *naked.License `json:",omitempty"`
}

// licenseCreateResponseEnvelope is envelop of API response
type licenseCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	License *naked.License `json:",omitempty"`
}

// licenseReadResponseEnvelope is envelop of API response
type licenseReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	License *naked.License `json:",omitempty"`
}

// licenseUpdateRequestEnvelope is envelop of API request
type licenseUpdateRequestEnvelope struct {
	License *naked.License `json:",omitempty"`
}

// licenseUpdateResponseEnvelope is envelop of API response
type licenseUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	License *naked.License `json:",omitempty"`
}

// licenseInfoFindRequestEnvelope is envelop of API request
type licenseInfoFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// licenseInfoFindResponseEnvelope is envelop of API response
type licenseInfoFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	LicenseInfo []*naked.LicenseInfo `json:",omitempty"`
}

// licenseInfoReadResponseEnvelope is envelop of API response
type licenseInfoReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	LicenseInfo *naked.LicenseInfo `json:",omitempty"`
}

// loadBalancerFindRequestEnvelope is envelop of API request
type loadBalancerFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// loadBalancerFindResponseEnvelope is envelop of API response
type loadBalancerFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Appliances []*naked.LoadBalancer `json:",omitempty"`
}

// loadBalancerCreateRequestEnvelope is envelop of API request
type loadBalancerCreateRequestEnvelope struct {
	Appliance *naked.LoadBalancer `json:",omitempty"`
}

// loadBalancerCreateResponseEnvelope is envelop of API response
type loadBalancerCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Appliance *naked.LoadBalancer `json:",omitempty"`
}

// loadBalancerReadResponseEnvelope is envelop of API response
type loadBalancerReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Appliance *naked.LoadBalancer `json:",omitempty"`
}

// loadBalancerUpdateRequestEnvelope is envelop of API request
type loadBalancerUpdateRequestEnvelope struct {
	Appliance *naked.LoadBalancer `json:",omitempty"`
}

// loadBalancerUpdateResponseEnvelope is envelop of API response
type loadBalancerUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Appliance *naked.LoadBalancer `json:",omitempty"`
}

// loadBalancerUpdateSettingsRequestEnvelope is envelop of API request
type loadBalancerUpdateSettingsRequestEnvelope struct {
	Appliance *naked.LoadBalancerSettingsUpdate `json:",omitempty"`
}

// loadBalancerUpdateSettingsResponseEnvelope is envelop of API response
type loadBalancerUpdateSettingsResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Appliance *naked.LoadBalancer `json:",omitempty"`
}

// loadBalancerShutdownRequestEnvelope is envelop of API request
type loadBalancerShutdownRequestEnvelope struct {
	Force bool `json:",omitempty"`
}

// loadBalancerMonitorCPURequestEnvelope is envelop of API request
type loadBalancerMonitorCPURequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// loadBalancerMonitorCPUResponseEnvelope is envelop of API response
type loadBalancerMonitorCPUResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// loadBalancerMonitorInterfaceRequestEnvelope is envelop of API request
type loadBalancerMonitorInterfaceRequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// loadBalancerMonitorInterfaceResponseEnvelope is envelop of API response
type loadBalancerMonitorInterfaceResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// loadBalancerStatusResponseEnvelope is envelop of API response
type loadBalancerStatusResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	LoadBalancer []*naked.LoadBalancerStatus `json:",omitempty"`
}

// localRouterFindRequestEnvelope is envelop of API request
type localRouterFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// localRouterFindResponseEnvelope is envelop of API response
type localRouterFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	CommonServiceItems []*naked.LocalRouter `json:",omitempty"`
}

// localRouterCreateRequestEnvelope is envelop of API request
type localRouterCreateRequestEnvelope struct {
	CommonServiceItem *naked.LocalRouter `json:",omitempty"`
}

// localRouterCreateResponseEnvelope is envelop of API response
type localRouterCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.LocalRouter `json:",omitempty"`
}

// localRouterReadResponseEnvelope is envelop of API response
type localRouterReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.LocalRouter `json:",omitempty"`
}

// localRouterUpdateRequestEnvelope is envelop of API request
type localRouterUpdateRequestEnvelope struct {
	CommonServiceItem *naked.LocalRouter `json:",omitempty"`
}

// localRouterUpdateResponseEnvelope is envelop of API response
type localRouterUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.LocalRouter `json:",omitempty"`
}

// localRouterUpdateSettingsRequestEnvelope is envelop of API request
type localRouterUpdateSettingsRequestEnvelope struct {
	CommonServiceItem *naked.LocalRouterSettingsUpdate `json:",omitempty"`
}

// localRouterUpdateSettingsResponseEnvelope is envelop of API response
type localRouterUpdateSettingsResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.LocalRouter `json:",omitempty"`
}

// localRouterHealthStatusResponseEnvelope is envelop of API response
type localRouterHealthStatusResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	LocalRouter *naked.LocalRouterHealth `json:",omitempty"`
}

// localRouterMonitorLocalRouterRequestEnvelope is envelop of API request
type localRouterMonitorLocalRouterRequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// localRouterMonitorLocalRouterResponseEnvelope is envelop of API response
type localRouterMonitorLocalRouterResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// mobileGatewayFindRequestEnvelope is envelop of API request
type mobileGatewayFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// mobileGatewayFindResponseEnvelope is envelop of API response
type mobileGatewayFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Appliances []*naked.MobileGateway `json:",omitempty"`
}

// mobileGatewayCreateRequestEnvelope is envelop of API request
type mobileGatewayCreateRequestEnvelope struct {
	Appliance *naked.MobileGateway `json:",omitempty"`
}

// mobileGatewayCreateResponseEnvelope is envelop of API response
type mobileGatewayCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Appliance *naked.MobileGateway `json:",omitempty"`
}

// mobileGatewayReadResponseEnvelope is envelop of API response
type mobileGatewayReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Appliance *naked.MobileGateway `json:",omitempty"`
}

// mobileGatewayUpdateRequestEnvelope is envelop of API request
type mobileGatewayUpdateRequestEnvelope struct {
	Appliance *naked.MobileGateway `json:",omitempty"`
}

// mobileGatewayUpdateResponseEnvelope is envelop of API response
type mobileGatewayUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Appliance *naked.MobileGateway `json:",omitempty"`
}

// mobileGatewayUpdateSettingsRequestEnvelope is envelop of API request
type mobileGatewayUpdateSettingsRequestEnvelope struct {
	Appliance *naked.MobileGatewaySettingsUpdate `json:",omitempty"`
}

// mobileGatewayUpdateSettingsResponseEnvelope is envelop of API response
type mobileGatewayUpdateSettingsResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Appliance *naked.MobileGateway `json:",omitempty"`
}

// mobileGatewayShutdownRequestEnvelope is envelop of API request
type mobileGatewayShutdownRequestEnvelope struct {
	Force bool `json:",omitempty"`
}

// mobileGatewayGetDNSResponseEnvelope is envelop of API response
type mobileGatewayGetDNSResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	SIMGroup *naked.MobileGatewaySIMGroup `json:"sim_group"`
}

// mobileGatewaySetDNSRequestEnvelope is envelop of API request
type mobileGatewaySetDNSRequestEnvelope struct {
	SIMGroup *naked.MobileGatewaySIMGroup `json:"sim_group"`
}

// mobileGatewayGetSIMRoutesResponseEnvelope is envelop of API response
type mobileGatewayGetSIMRoutesResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	SIMRoutes []*naked.MobileGatewaySIMRoute `json:"sim_routes"`
}

// mobileGatewaySetSIMRoutesRequestEnvelope is envelop of API request
type mobileGatewaySetSIMRoutesRequestEnvelope struct {
	SIMRoutes []*naked.MobileGatewaySIMRoute `json:"sim_routes"`
}

// mobileGatewayListSIMResponseEnvelope is envelop of API response
type mobileGatewayListSIMResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	SIM []*naked.SIMInfo `json:"sim"`
}

// mobileGatewayAddSIMRequestEnvelope is envelop of API request
type mobileGatewayAddSIMRequestEnvelope struct {
	SIM *naked.SIMInfo `json:"sim"`
}

// mobileGatewayLogsResponseEnvelope is envelop of API response
type mobileGatewayLogsResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Logs []*naked.SIMLog `json:"logs"`
}

// mobileGatewayGetTrafficConfigResponseEnvelope is envelop of API response
type mobileGatewayGetTrafficConfigResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	TrafficMonitoring *naked.TrafficMonitoringConfig `json:"traffic_monitoring_config"`
}

// mobileGatewaySetTrafficConfigRequestEnvelope is envelop of API request
type mobileGatewaySetTrafficConfigRequestEnvelope struct {
	TrafficMonitoring *naked.TrafficMonitoringConfig `json:"traffic_monitoring_config"`
}

// mobileGatewayTrafficStatusResponseEnvelope is envelop of API response
type mobileGatewayTrafficStatusResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	TrafficStatus *naked.TrafficStatus `json:"traffic_status"`
}

// mobileGatewayMonitorInterfaceRequestEnvelope is envelop of API request
type mobileGatewayMonitorInterfaceRequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// mobileGatewayMonitorInterfaceResponseEnvelope is envelop of API response
type mobileGatewayMonitorInterfaceResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// nFSFindRequestEnvelope is envelop of API request
type nFSFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// nFSFindResponseEnvelope is envelop of API response
type nFSFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Appliances []*naked.NFS `json:",omitempty"`
}

// nFSCreateRequestEnvelope is envelop of API request
type nFSCreateRequestEnvelope struct {
	Appliance *naked.NFS `json:",omitempty"`
}

// nFSCreateResponseEnvelope is envelop of API response
type nFSCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Appliance *naked.NFS `json:",omitempty"`
}

// nFSReadResponseEnvelope is envelop of API response
type nFSReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Appliance *naked.NFS `json:",omitempty"`
}

// nFSUpdateRequestEnvelope is envelop of API request
type nFSUpdateRequestEnvelope struct {
	Appliance *naked.NFS `json:",omitempty"`
}

// nFSUpdateResponseEnvelope is envelop of API response
type nFSUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Appliance *naked.NFS `json:",omitempty"`
}

// nFSShutdownRequestEnvelope is envelop of API request
type nFSShutdownRequestEnvelope struct {
	Force bool `json:",omitempty"`
}

// nFSMonitorCPURequestEnvelope is envelop of API request
type nFSMonitorCPURequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// nFSMonitorCPUResponseEnvelope is envelop of API response
type nFSMonitorCPUResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// nFSMonitorFreeDiskSizeRequestEnvelope is envelop of API request
type nFSMonitorFreeDiskSizeRequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// nFSMonitorFreeDiskSizeResponseEnvelope is envelop of API response
type nFSMonitorFreeDiskSizeResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// nFSMonitorInterfaceRequestEnvelope is envelop of API request
type nFSMonitorInterfaceRequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// nFSMonitorInterfaceResponseEnvelope is envelop of API response
type nFSMonitorInterfaceResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// noteFindRequestEnvelope is envelop of API request
type noteFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// noteFindResponseEnvelope is envelop of API response
type noteFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Notes []*naked.Note `json:",omitempty"`
}

// noteCreateRequestEnvelope is envelop of API request
type noteCreateRequestEnvelope struct {
	Note *naked.Note `json:",omitempty"`
}

// noteCreateResponseEnvelope is envelop of API response
type noteCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Note *naked.Note `json:",omitempty"`
}

// noteReadResponseEnvelope is envelop of API response
type noteReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Note *naked.Note `json:",omitempty"`
}

// noteUpdateRequestEnvelope is envelop of API request
type noteUpdateRequestEnvelope struct {
	Note *naked.Note `json:",omitempty"`
}

// noteUpdateResponseEnvelope is envelop of API response
type noteUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Note *naked.Note `json:",omitempty"`
}

// packetFilterFindRequestEnvelope is envelop of API request
type packetFilterFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// packetFilterFindResponseEnvelope is envelop of API response
type packetFilterFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	PacketFilters []*naked.PacketFilter `json:",omitempty"`
}

// packetFilterCreateRequestEnvelope is envelop of API request
type packetFilterCreateRequestEnvelope struct {
	PacketFilter *naked.PacketFilter `json:",omitempty"`
}

// packetFilterCreateResponseEnvelope is envelop of API response
type packetFilterCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	PacketFilter *naked.PacketFilter `json:",omitempty"`
}

// packetFilterReadResponseEnvelope is envelop of API response
type packetFilterReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	PacketFilter *naked.PacketFilter `json:",omitempty"`
}

// packetFilterUpdateRequestEnvelope is envelop of API request
type packetFilterUpdateRequestEnvelope struct {
	PacketFilter           *naked.PacketFilter `json:",omitempty"`
	OriginalExpressionHash string              `json:",omitempty"`
}

// packetFilterUpdateResponseEnvelope is envelop of API response
type packetFilterUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	PacketFilter *naked.PacketFilter `json:",omitempty"`
}

// privateHostFindRequestEnvelope is envelop of API request
type privateHostFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// privateHostFindResponseEnvelope is envelop of API response
type privateHostFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	PrivateHosts []*naked.PrivateHost `json:",omitempty"`
}

// privateHostCreateRequestEnvelope is envelop of API request
type privateHostCreateRequestEnvelope struct {
	PrivateHost *naked.PrivateHost `json:",omitempty"`
}

// privateHostCreateResponseEnvelope is envelop of API response
type privateHostCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	PrivateHost *naked.PrivateHost `json:",omitempty"`
}

// privateHostReadResponseEnvelope is envelop of API response
type privateHostReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	PrivateHost *naked.PrivateHost `json:",omitempty"`
}

// privateHostUpdateRequestEnvelope is envelop of API request
type privateHostUpdateRequestEnvelope struct {
	PrivateHost *naked.PrivateHost `json:",omitempty"`
}

// privateHostUpdateResponseEnvelope is envelop of API response
type privateHostUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	PrivateHost *naked.PrivateHost `json:",omitempty"`
}

// privateHostPlanFindRequestEnvelope is envelop of API request
type privateHostPlanFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// privateHostPlanFindResponseEnvelope is envelop of API response
type privateHostPlanFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	PrivateHostPlans []*naked.PrivateHostPlan `json:",omitempty"`
}

// privateHostPlanReadResponseEnvelope is envelop of API response
type privateHostPlanReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	PrivateHostPlan *naked.PrivateHostPlan `json:",omitempty"`
}

// proxyLBFindRequestEnvelope is envelop of API request
type proxyLBFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// proxyLBFindResponseEnvelope is envelop of API response
type proxyLBFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	CommonServiceItems []*naked.ProxyLB `json:",omitempty"`
}

// proxyLBCreateRequestEnvelope is envelop of API request
type proxyLBCreateRequestEnvelope struct {
	CommonServiceItem *naked.ProxyLB `json:",omitempty"`
}

// proxyLBCreateResponseEnvelope is envelop of API response
type proxyLBCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.ProxyLB `json:",omitempty"`
}

// proxyLBReadResponseEnvelope is envelop of API response
type proxyLBReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.ProxyLB `json:",omitempty"`
}

// proxyLBUpdateRequestEnvelope is envelop of API request
type proxyLBUpdateRequestEnvelope struct {
	CommonServiceItem *naked.ProxyLB `json:",omitempty"`
}

// proxyLBUpdateResponseEnvelope is envelop of API response
type proxyLBUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.ProxyLB `json:",omitempty"`
}

// proxyLBUpdateSettingsRequestEnvelope is envelop of API request
type proxyLBUpdateSettingsRequestEnvelope struct {
	CommonServiceItem *naked.ProxyLBSettingsUpdate `json:",omitempty"`
}

// proxyLBUpdateSettingsResponseEnvelope is envelop of API response
type proxyLBUpdateSettingsResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.ProxyLB `json:",omitempty"`
}

// proxyLBChangePlanRequestEnvelope is envelop of API request
type proxyLBChangePlanRequestEnvelope struct {
	CommonServiceItem *naked.ProxyLBPlanChange `json:",omitempty"`
}

// proxyLBChangePlanResponseEnvelope is envelop of API response
type proxyLBChangePlanResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.ProxyLB `json:",omitempty"`
}

// proxyLBGetCertificatesResponseEnvelope is envelop of API response
type proxyLBGetCertificatesResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	ProxyLB *naked.ProxyLBCertificates `json:",omitempty"`
}

// proxyLBSetCertificatesRequestEnvelope is envelop of API request
type proxyLBSetCertificatesRequestEnvelope struct {
	ProxyLB *naked.ProxyLBCertificates `json:",omitempty"`
}

// proxyLBSetCertificatesResponseEnvelope is envelop of API response
type proxyLBSetCertificatesResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	ProxyLB *naked.ProxyLBCertificates `json:",omitempty"`
}

// proxyLBHealthStatusResponseEnvelope is envelop of API response
type proxyLBHealthStatusResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	ProxyLB *naked.ProxyLBHealth `json:",omitempty"`
}

// proxyLBMonitorConnectionRequestEnvelope is envelop of API request
type proxyLBMonitorConnectionRequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// proxyLBMonitorConnectionResponseEnvelope is envelop of API response
type proxyLBMonitorConnectionResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// regionFindRequestEnvelope is envelop of API request
type regionFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// regionFindResponseEnvelope is envelop of API response
type regionFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Regions []*naked.Region `json:",omitempty"`
}

// regionReadResponseEnvelope is envelop of API response
type regionReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Region *naked.Region `json:",omitempty"`
}

// serverFindRequestEnvelope is envelop of API request
type serverFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// serverFindResponseEnvelope is envelop of API response
type serverFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Servers []*naked.Server `json:",omitempty"`
}

// serverCreateRequestEnvelope is envelop of API request
type serverCreateRequestEnvelope struct {
	Server *naked.Server `json:",omitempty"`
}

// serverCreateResponseEnvelope is envelop of API response
type serverCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Server *naked.Server `json:",omitempty"`
}

// serverReadResponseEnvelope is envelop of API response
type serverReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Server *naked.Server `json:",omitempty"`
}

// serverUpdateRequestEnvelope is envelop of API request
type serverUpdateRequestEnvelope struct {
	Server *naked.Server `json:",omitempty"`
}

// serverUpdateResponseEnvelope is envelop of API response
type serverUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Server *naked.Server `json:",omitempty"`
}

// serverDeleteWithDisksRequestEnvelope is envelop of API request
type serverDeleteWithDisksRequestEnvelope struct {
	WithDisk []types.ID `json:",omitempty"`
}

// serverChangePlanRequestEnvelope is envelop of API request
type serverChangePlanRequestEnvelope struct {
	CPU        int                   `json:",omitempty"`
	MemoryMB   int                   `json:",omitempty"`
	GPU        int                   `json:",omitempty"`
	GPUModel   string                `json:"GPUModel,omitempty"`
	CPUModel   string                `json:"CPUModel,omitempty"`
	Generation types.EPlanGeneration `json:"Generation,omitempty"`
	Commitment types.ECommitment     `json:"Commitment,omitempty"`
}

// serverChangePlanResponseEnvelope is envelop of API response
type serverChangePlanResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Server *naked.Server `json:",omitempty"`
}

// serverInsertCDROMRequestEnvelope is envelop of API request
type serverInsertCDROMRequestEnvelope struct {
	CDROM *naked.CDROM `json:",omitempty"`
}

// serverEjectCDROMRequestEnvelope is envelop of API request
type serverEjectCDROMRequestEnvelope struct {
	CDROM *naked.CDROM `json:",omitempty"`
}

// serverShutdownRequestEnvelope is envelop of API request
type serverShutdownRequestEnvelope struct {
	Force bool `json:",omitempty"`
}

// serverBootWithVariablesRequestEnvelope is envelop of API request
type serverBootWithVariablesRequestEnvelope struct {
	UserBootVariables *naked.ServerBootVariables `json:",omitempty"`
}

// serverSendKeyRequestEnvelope is envelop of API request
type serverSendKeyRequestEnvelope struct {
	Key  string   `json:",omitempty"`
	Keys []string `json:",omitempty"`
}

// serverGetVNCProxyResponseEnvelope is envelop of API response
type serverGetVNCProxyResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	VNCProxyInfo *naked.VNCProxyInfo `json:",omitempty"`
}

// serverMonitorRequestEnvelope is envelop of API request
type serverMonitorRequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// serverMonitorResponseEnvelope is envelop of API response
type serverMonitorResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// serverMonitorCPURequestEnvelope is envelop of API request
type serverMonitorCPURequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// serverMonitorCPUResponseEnvelope is envelop of API response
type serverMonitorCPUResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// serverPlanFindRequestEnvelope is envelop of API request
type serverPlanFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// serverPlanFindResponseEnvelope is envelop of API response
type serverPlanFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	ServerPlans []*naked.ServerPlan `json:",omitempty"`
}

// serverPlanReadResponseEnvelope is envelop of API response
type serverPlanReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	ServerPlan *naked.ServerPlan `json:",omitempty"`
}

// serviceClassFindRequestEnvelope is envelop of API request
type serviceClassFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// serviceClassFindResponseEnvelope is envelop of API response
type serviceClassFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	ServiceClasses []*naked.ServiceClass `json:",omitempty"`
}

// sIMFindRequestEnvelope is envelop of API request
type sIMFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// sIMFindResponseEnvelope is envelop of API response
type sIMFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	CommonServiceItems []*naked.SIM `json:",omitempty"`
}

// sIMCreateRequestEnvelope is envelop of API request
type sIMCreateRequestEnvelope struct {
	CommonServiceItem *naked.SIM `json:",omitempty"`
}

// sIMCreateResponseEnvelope is envelop of API response
type sIMCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.SIM `json:",omitempty"`
}

// sIMReadResponseEnvelope is envelop of API response
type sIMReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.SIM `json:",omitempty"`
}

// sIMUpdateRequestEnvelope is envelop of API request
type sIMUpdateRequestEnvelope struct {
	CommonServiceItem *naked.SIM `json:",omitempty"`
}

// sIMUpdateResponseEnvelope is envelop of API response
type sIMUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.SIM `json:",omitempty"`
}

// sIMAssignIPRequestEnvelope is envelop of API request
type sIMAssignIPRequestEnvelope struct {
	SIM *naked.SIMAssignIPRequest `json:"sim"`
}

// sIMIMEILockRequestEnvelope is envelop of API request
type sIMIMEILockRequestEnvelope struct {
	SIM *naked.SIMIMEILockRequest `json:"sim"`
}

// sIMLogsResponseEnvelope is envelop of API response
type sIMLogsResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Logs []*naked.SIMLog `json:"logs"`
}

// sIMGetNetworkOperatorResponseEnvelope is envelop of API response
type sIMGetNetworkOperatorResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	NetworkOperationConfigs []*naked.SIMNetworkOperatorConfig `json:"network_operator_config"`
}

// sIMSetNetworkOperatorRequestEnvelope is envelop of API request
type sIMSetNetworkOperatorRequestEnvelope struct {
	NetworkOperatorConfigs []*naked.SIMNetworkOperatorConfig `json:"network_operator_config"`
}

// sIMMonitorSIMRequestEnvelope is envelop of API request
type sIMMonitorSIMRequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// sIMMonitorSIMResponseEnvelope is envelop of API response
type sIMMonitorSIMResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// sIMStatusResponseEnvelope is envelop of API response
type sIMStatusResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	SIM *naked.SIMInfo `json:"sim"`
}

// simpleMonitorFindRequestEnvelope is envelop of API request
type simpleMonitorFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// simpleMonitorFindResponseEnvelope is envelop of API response
type simpleMonitorFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	CommonServiceItems []*naked.SimpleMonitor `json:",omitempty"`
}

// simpleMonitorCreateRequestEnvelope is envelop of API request
type simpleMonitorCreateRequestEnvelope struct {
	CommonServiceItem *naked.SimpleMonitor `json:",omitempty"`
}

// simpleMonitorCreateResponseEnvelope is envelop of API response
type simpleMonitorCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.SimpleMonitor `json:",omitempty"`
}

// simpleMonitorReadResponseEnvelope is envelop of API response
type simpleMonitorReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.SimpleMonitor `json:",omitempty"`
}

// simpleMonitorUpdateRequestEnvelope is envelop of API request
type simpleMonitorUpdateRequestEnvelope struct {
	CommonServiceItem *naked.SimpleMonitor `json:",omitempty"`
}

// simpleMonitorUpdateResponseEnvelope is envelop of API response
type simpleMonitorUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.SimpleMonitor `json:",omitempty"`
}

// simpleMonitorUpdateSettingsRequestEnvelope is envelop of API request
type simpleMonitorUpdateSettingsRequestEnvelope struct {
	CommonServiceItem *naked.SimpleMonitorSettingsUpdate `json:",omitempty"`
}

// simpleMonitorUpdateSettingsResponseEnvelope is envelop of API response
type simpleMonitorUpdateSettingsResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.SimpleMonitor `json:",omitempty"`
}

// simpleMonitorMonitorResponseTimeRequestEnvelope is envelop of API request
type simpleMonitorMonitorResponseTimeRequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// simpleMonitorMonitorResponseTimeResponseEnvelope is envelop of API response
type simpleMonitorMonitorResponseTimeResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// simpleMonitorHealthStatusResponseEnvelope is envelop of API response
type simpleMonitorHealthStatusResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	SimpleMonitor *naked.SimpleMonitorHealthCheckStatus `json:",omitempty"`
}

// simpleNotificationDestinationFindRequestEnvelope is envelop of API request
type simpleNotificationDestinationFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// simpleNotificationDestinationFindResponseEnvelope is envelop of API response
type simpleNotificationDestinationFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	CommonServiceItems []*naked.SimpleNotificationDestination `json:",omitempty"`
}

// simpleNotificationDestinationCreateRequestEnvelope is envelop of API request
type simpleNotificationDestinationCreateRequestEnvelope struct {
	CommonServiceItem *naked.SimpleNotificationDestination `json:",omitempty"`
}

// simpleNotificationDestinationCreateResponseEnvelope is envelop of API response
type simpleNotificationDestinationCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.SimpleNotificationDestination `json:",omitempty"`
}

// simpleNotificationDestinationReadResponseEnvelope is envelop of API response
type simpleNotificationDestinationReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.SimpleNotificationDestination `json:",omitempty"`
}

// simpleNotificationDestinationUpdateRequestEnvelope is envelop of API request
type simpleNotificationDestinationUpdateRequestEnvelope struct {
	CommonServiceItem *naked.SimpleNotificationDestination `json:",omitempty"`
}

// simpleNotificationDestinationUpdateResponseEnvelope is envelop of API response
type simpleNotificationDestinationUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.SimpleNotificationDestination `json:",omitempty"`
}

// simpleNotificationDestinationUpdateSettingsRequestEnvelope is envelop of API request
type simpleNotificationDestinationUpdateSettingsRequestEnvelope struct {
	CommonServiceItem *naked.SimpleNotificationDestinationSettingsUpdate `json:",omitempty"`
}

// simpleNotificationDestinationUpdateSettingsResponseEnvelope is envelop of API response
type simpleNotificationDestinationUpdateSettingsResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.SimpleNotificationDestination `json:",omitempty"`
}

// simpleNotificationDestinationStatusResponseEnvelope is envelop of API response
type simpleNotificationDestinationStatusResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	SimpleNotificationDestination *naked.SimpleNotificationDestinationRunningStatus `json:",omitempty"`
}

// simpleNotificationGroupFindRequestEnvelope is envelop of API request
type simpleNotificationGroupFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// simpleNotificationGroupFindResponseEnvelope is envelop of API response
type simpleNotificationGroupFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	CommonServiceItems []*naked.SimpleNotificationGroup `json:",omitempty"`
}

// simpleNotificationGroupCreateRequestEnvelope is envelop of API request
type simpleNotificationGroupCreateRequestEnvelope struct {
	CommonServiceItem *naked.SimpleNotificationGroup `json:",omitempty"`
}

// simpleNotificationGroupCreateResponseEnvelope is envelop of API response
type simpleNotificationGroupCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.SimpleNotificationGroup `json:",omitempty"`
}

// simpleNotificationGroupReadResponseEnvelope is envelop of API response
type simpleNotificationGroupReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.SimpleNotificationGroup `json:",omitempty"`
}

// simpleNotificationGroupUpdateRequestEnvelope is envelop of API request
type simpleNotificationGroupUpdateRequestEnvelope struct {
	CommonServiceItem *naked.SimpleNotificationGroup `json:",omitempty"`
}

// simpleNotificationGroupUpdateResponseEnvelope is envelop of API response
type simpleNotificationGroupUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.SimpleNotificationGroup `json:",omitempty"`
}

// simpleNotificationGroupUpdateSettingsRequestEnvelope is envelop of API request
type simpleNotificationGroupUpdateSettingsRequestEnvelope struct {
	CommonServiceItem *naked.SimpleNotificationGroupSettingsUpdate `json:",omitempty"`
}

// simpleNotificationGroupUpdateSettingsResponseEnvelope is envelop of API response
type simpleNotificationGroupUpdateSettingsResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	CommonServiceItem *naked.SimpleNotificationGroup `json:",omitempty"`
}

// simpleNotificationGroupPostMessageRequestEnvelope is envelop of API request
type simpleNotificationGroupPostMessageRequestEnvelope struct {
	Message string `json:",omitempty"`
}

// simpleNotificationGroupHistoryResponseEnvelope is envelop of API response
type simpleNotificationGroupHistoryResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	NotificationHistories *naked.SimpleNotificationHistories `json:",omitempty"`
}

// sSHKeyFindRequestEnvelope is envelop of API request
type sSHKeyFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// sSHKeyFindResponseEnvelope is envelop of API response
type sSHKeyFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	SSHKeys []*naked.SSHKey `json:",omitempty"`
}

// sSHKeyCreateRequestEnvelope is envelop of API request
type sSHKeyCreateRequestEnvelope struct {
	SSHKey *naked.SSHKey `json:",omitempty"`
}

// sSHKeyCreateResponseEnvelope is envelop of API response
type sSHKeyCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	SSHKey *naked.SSHKey `json:",omitempty"`
}

// sSHKeyReadResponseEnvelope is envelop of API response
type sSHKeyReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	SSHKey *naked.SSHKey `json:",omitempty"`
}

// sSHKeyUpdateRequestEnvelope is envelop of API request
type sSHKeyUpdateRequestEnvelope struct {
	SSHKey *naked.SSHKey `json:",omitempty"`
}

// sSHKeyUpdateResponseEnvelope is envelop of API response
type sSHKeyUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	SSHKey *naked.SSHKey `json:",omitempty"`
}

// subnetFindRequestEnvelope is envelop of API request
type subnetFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// subnetFindResponseEnvelope is envelop of API response
type subnetFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Subnets []*naked.Subnet `json:",omitempty"`
}

// subnetReadResponseEnvelope is envelop of API response
type subnetReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Subnet *naked.Subnet `json:",omitempty"`
}

// switchFindRequestEnvelope is envelop of API request
type switchFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// switchFindResponseEnvelope is envelop of API response
type switchFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Switches []*naked.Switch `json:",omitempty"`
}

// switchCreateRequestEnvelope is envelop of API request
type switchCreateRequestEnvelope struct {
	Switch *naked.Switch `json:",omitempty"`
}

// switchCreateResponseEnvelope is envelop of API response
type switchCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Switch *naked.Switch `json:",omitempty"`
}

// switchReadResponseEnvelope is envelop of API response
type switchReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Switch *naked.Switch `json:",omitempty"`
}

// switchUpdateRequestEnvelope is envelop of API request
type switchUpdateRequestEnvelope struct {
	Switch *naked.Switch `json:",omitempty"`
}

// switchUpdateResponseEnvelope is envelop of API response
type switchUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Switch *naked.Switch `json:",omitempty"`
}

// switchGetServersResponseEnvelope is envelop of API response
type switchGetServersResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Servers []*naked.Server `json:",omitempty"`
}

// vPCRouterFindRequestEnvelope is envelop of API request
type vPCRouterFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// vPCRouterFindResponseEnvelope is envelop of API response
type vPCRouterFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Appliances []*naked.VPCRouter `json:",omitempty"`
}

// vPCRouterCreateRequestEnvelope is envelop of API request
type vPCRouterCreateRequestEnvelope struct {
	Appliance *naked.VPCRouter `json:",omitempty"`
}

// vPCRouterCreateResponseEnvelope is envelop of API response
type vPCRouterCreateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Appliance *naked.VPCRouter `json:",omitempty"`
}

// vPCRouterReadResponseEnvelope is envelop of API response
type vPCRouterReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Appliance *naked.VPCRouter `json:",omitempty"`
}

// vPCRouterUpdateRequestEnvelope is envelop of API request
type vPCRouterUpdateRequestEnvelope struct {
	Appliance *naked.VPCRouter `json:",omitempty"`
}

// vPCRouterUpdateResponseEnvelope is envelop of API response
type vPCRouterUpdateResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Appliance *naked.VPCRouter `json:",omitempty"`
}

// vPCRouterUpdateSettingsRequestEnvelope is envelop of API request
type vPCRouterUpdateSettingsRequestEnvelope struct {
	Appliance *naked.VPCRouterSettingsUpdate `json:",omitempty"`
}

// vPCRouterUpdateSettingsResponseEnvelope is envelop of API response
type vPCRouterUpdateSettingsResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Appliance *naked.VPCRouter `json:",omitempty"`
}

// vPCRouterShutdownRequestEnvelope is envelop of API request
type vPCRouterShutdownRequestEnvelope struct {
	Force bool `json:",omitempty"`
}

// vPCRouterMonitorCPURequestEnvelope is envelop of API request
type vPCRouterMonitorCPURequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// vPCRouterMonitorCPUResponseEnvelope is envelop of API response
type vPCRouterMonitorCPUResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// vPCRouterMonitorInterfaceRequestEnvelope is envelop of API request
type vPCRouterMonitorInterfaceRequestEnvelope struct {
	Start time.Time `json:",omitempty"`
	End   time.Time `json:",omitempty"`
}

// vPCRouterMonitorInterfaceResponseEnvelope is envelop of API response
type vPCRouterMonitorInterfaceResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Data *naked.MonitorValues `json:",omitempty"`
}

// vPCRouterStatusResponseEnvelope is envelop of API response
type vPCRouterStatusResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Router *naked.VPCRouterStatus `json:",omitempty"`
}

// vPCRouterLogsResponseEnvelope is envelop of API response
type vPCRouterLogsResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	VPCRouter *naked.VPCRouterLog `json:",omitempty"`
}

// vPCRouterPingResponseEnvelope is envelop of API response
type vPCRouterPingResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	VPCRouter *naked.VPCRouterPingResult `json:",omitempty"`
}

// zoneFindRequestEnvelope is envelop of API request
type zoneFindRequestEnvelope struct {
	Count   int             `mapconv:",omitempty"`
	From    int             `mapconv:",omitempty"`
	Sort    search.SortKeys `json:",omitempty" mapconv:",omitempty"`
	Filter  search.Filter   `json:",omitempty" mapconv:",omitempty"`
	Include []string        `json:",omitempty" mapconv:",omitempty"`
	Exclude []string        `json:",omitempty" mapconv:",omitempty"`
}

// zoneFindResponseEnvelope is envelop of API response
type zoneFindResponseEnvelope struct {
	Total int `json:",omitempty"` // トータル件数
	From  int `json:",omitempty"` // ページング開始ページ
	Count int `json:",omitempty"` // 件数

	Zones []*naked.Zone `json:",omitempty"`
}

// zoneReadResponseEnvelope is envelop of API response
type zoneReadResponseEnvelope struct {
	IsOk    bool            `json:"is_ok,omitempty"` // is_ok項目
	Success types.APIResult `json:",omitempty"`      // success項目

	Zone *naked.Zone `json:",omitempty"`
}
