// SPDX-License-Identifier: MIT
// Copyright (C) 2018-present iced project and contributors

use core::fmt;

// GENERATOR-BEGIN: CtorKind
// ⚠️This was generated by GENERATOR!🦹‍♂️
#[derive(Copy, Clone, Eq, PartialEq)]
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) enum CtorKind {
	Previous,
	Normal_1,
	Normal_2,
	AamAad,
	AX,
	AY,
	bnd,
	STIG1,
	DeclareData,
	DX,
	fword,
	Int3,
	imul,
	invlpga,
	CCa_1,
	CCa_2,
	CCa_3,
	CCb_1,
	CCb_2,
	CCb_3,
	jcc_1,
	jcc_2,
	jcc_3,
	Loopcc1,
	Loopcc2,
	maskmovq,
	memsize,
	YD,
	YX,
	monitor,
	mwait,
	mwaitx,
	nop,
	OpSize_1,
	OpSize_2,
	OpSize2,
	YA,
	pblendvb,
	pclmulqdq,
	pops_2,
	pops_3,
	XY,
	reg,
	Reg16,
	Reg32,
	reverse,
	ST_STi,
	STi_ST,
	XLAT,
}
#[rustfmt::skip]
static GEN_DEBUG_CTOR_KIND: [&str; 49] = [
	"Previous",
	"Normal_1",
	"Normal_2",
	"AamAad",
	"AX",
	"AY",
	"bnd",
	"STIG1",
	"DeclareData",
	"DX",
	"fword",
	"Int3",
	"imul",
	"invlpga",
	"CCa_1",
	"CCa_2",
	"CCa_3",
	"CCb_1",
	"CCb_2",
	"CCb_3",
	"jcc_1",
	"jcc_2",
	"jcc_3",
	"Loopcc1",
	"Loopcc2",
	"maskmovq",
	"memsize",
	"YD",
	"YX",
	"monitor",
	"mwait",
	"mwaitx",
	"nop",
	"OpSize_1",
	"OpSize_2",
	"OpSize2",
	"YA",
	"pblendvb",
	"pclmulqdq",
	"pops_2",
	"pops_3",
	"XY",
	"reg",
	"Reg16",
	"Reg32",
	"reverse",
	"ST_STi",
	"STi_ST",
	"XLAT",
];
impl fmt::Debug for CtorKind {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_CTOR_KIND[*self as usize])
	}
}
impl Default for CtorKind {
	#[must_use]
	#[inline]
	fn default() -> Self {
		CtorKind::Previous
	}
}
// GENERATOR-END: CtorKind

// GENERATOR-BEGIN: InstrOpInfoFlags
// ⚠️This was generated by GENERATOR!🦹‍♂️
pub(crate) struct InstrOpInfoFlags;
#[allow(dead_code)]
impl InstrOpInfoFlags {
	pub(crate) const NONE: u32 = 0x0000_0000;
	pub(crate) const MEM_SIZE_MASK: u32 = 0x0000_0007;
	pub(crate) const MEM_SIZE_SSE: u32 = 0x0000_0000;
	pub(crate) const MEM_SIZE_MMX: u32 = 0x0000_0001;
	pub(crate) const MEM_SIZE_NORMAL: u32 = 0x0000_0002;
	pub(crate) const MEM_SIZE_NOTHING: u32 = 0x0000_0003;
	pub(crate) const MEM_SIZE_XMMWORD_PTR: u32 = 0x0000_0004;
	pub(crate) const MEM_SIZE_DWORD_OR_QWORD: u32 = 0x0000_0005;
	pub(crate) const SHOW_NO_MEM_SIZE_FORCE_SIZE: u32 = 0x0000_0008;
	pub(crate) const SHOW_MIN_MEM_SIZE_FORCE_SIZE: u32 = 0x0000_0010;
	pub(crate) const JCC_NOT_TAKEN: u32 = 0x0000_0020;
	pub(crate) const JCC_TAKEN: u32 = 0x0000_0040;
	pub(crate) const BND_PREFIX: u32 = 0x0000_0080;
	pub(crate) const IGNORE_INDEX_REG: u32 = 0x0000_0100;
	pub(crate) const MNEMONIC_IS_DIRECTIVE: u32 = 0x0000_0200;
}
// GENERATOR-END: InstrOpInfoFlags

// GENERATOR-BEGIN: InstrOpKind
// ⚠️This was generated by GENERATOR!🦹‍♂️
#[derive(Copy, Clone, Eq, PartialEq)]
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) enum InstrOpKind {
	Register,
	NearBranch16,
	NearBranch32,
	NearBranch64,
	FarBranch16,
	FarBranch32,
	Immediate8,
	Immediate8_2nd,
	Immediate16,
	Immediate32,
	Immediate64,
	Immediate8to16,
	Immediate8to32,
	Immediate8to64,
	Immediate32to64,
	MemorySegSI,
	MemorySegESI,
	MemorySegRSI,
	MemorySegDI,
	MemorySegEDI,
	MemorySegRDI,
	MemoryESDI,
	MemoryESEDI,
	MemoryESRDI,
	Memory,
	ExtraImmediate8_Value3,
	DeclareByte,
	DeclareWord,
	DeclareDword,
	DeclareQword,
}
#[rustfmt::skip]
static GEN_DEBUG_INSTR_OP_KIND: [&str; 30] = [
	"Register",
	"NearBranch16",
	"NearBranch32",
	"NearBranch64",
	"FarBranch16",
	"FarBranch32",
	"Immediate8",
	"Immediate8_2nd",
	"Immediate16",
	"Immediate32",
	"Immediate64",
	"Immediate8to16",
	"Immediate8to32",
	"Immediate8to64",
	"Immediate32to64",
	"MemorySegSI",
	"MemorySegESI",
	"MemorySegRSI",
	"MemorySegDI",
	"MemorySegEDI",
	"MemorySegRDI",
	"MemoryESDI",
	"MemoryESEDI",
	"MemoryESRDI",
	"Memory",
	"ExtraImmediate8_Value3",
	"DeclareByte",
	"DeclareWord",
	"DeclareDword",
	"DeclareQword",
];
impl fmt::Debug for InstrOpKind {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_INSTR_OP_KIND[*self as usize])
	}
}
impl Default for InstrOpKind {
	#[must_use]
	#[inline]
	fn default() -> Self {
		InstrOpKind::Register
	}
}
// GENERATOR-END: InstrOpKind
