// Code generated by go-swagger; DO NOT EDIT.

package consul_telemetry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewQueryRangeBatchParams creates a new QueryRangeBatchParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryRangeBatchParams() *QueryRangeBatchParams {
	return &QueryRangeBatchParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryRangeBatchParamsWithTimeout creates a new QueryRangeBatchParams object
// with the ability to set a timeout on a request.
func NewQueryRangeBatchParamsWithTimeout(timeout time.Duration) *QueryRangeBatchParams {
	return &QueryRangeBatchParams{
		timeout: timeout,
	}
}

// NewQueryRangeBatchParamsWithContext creates a new QueryRangeBatchParams object
// with the ability to set a context for a request.
func NewQueryRangeBatchParamsWithContext(ctx context.Context) *QueryRangeBatchParams {
	return &QueryRangeBatchParams{
		Context: ctx,
	}
}

// NewQueryRangeBatchParamsWithHTTPClient creates a new QueryRangeBatchParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryRangeBatchParamsWithHTTPClient(client *http.Client) *QueryRangeBatchParams {
	return &QueryRangeBatchParams{
		HTTPClient: client,
	}
}

/*
QueryRangeBatchParams contains all the parameters to send to the API endpoint

	for the query range batch operation.

	Typically these are written to a http.Request.
*/
type QueryRangeBatchParams struct {

	// Body.
	Body QueryRangeBatchBody

	// ClusterID.
	ClusterID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query range batch params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryRangeBatchParams) WithDefaults() *QueryRangeBatchParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query range batch params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryRangeBatchParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query range batch params
func (o *QueryRangeBatchParams) WithTimeout(timeout time.Duration) *QueryRangeBatchParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query range batch params
func (o *QueryRangeBatchParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query range batch params
func (o *QueryRangeBatchParams) WithContext(ctx context.Context) *QueryRangeBatchParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query range batch params
func (o *QueryRangeBatchParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query range batch params
func (o *QueryRangeBatchParams) WithHTTPClient(client *http.Client) *QueryRangeBatchParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query range batch params
func (o *QueryRangeBatchParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the query range batch params
func (o *QueryRangeBatchParams) WithBody(body QueryRangeBatchBody) *QueryRangeBatchParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the query range batch params
func (o *QueryRangeBatchParams) SetBody(body QueryRangeBatchBody) {
	o.Body = body
}

// WithClusterID adds the clusterID to the query range batch params
func (o *QueryRangeBatchParams) WithClusterID(clusterID string) *QueryRangeBatchParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the query range batch params
func (o *QueryRangeBatchParams) SetClusterID(clusterID string) {
	o.ClusterID = clusterID
}

// WithLocationOrganizationID adds the locationOrganizationID to the query range batch params
func (o *QueryRangeBatchParams) WithLocationOrganizationID(locationOrganizationID string) *QueryRangeBatchParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the query range batch params
func (o *QueryRangeBatchParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the query range batch params
func (o *QueryRangeBatchParams) WithLocationProjectID(locationProjectID string) *QueryRangeBatchParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the query range batch params
func (o *QueryRangeBatchParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *QueryRangeBatchParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if err := r.SetBodyParam(o.Body); err != nil {
		return err
	}

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
