// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        (unknown)
// source: pbmesh/v2beta1/pbproxystate/transport_socket.proto

package pbproxystate

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// +kubebuilder:validation:Enum=TLS_VERSION_AUTO;TLS_VERSION_1_0;TLS_VERSION_1_1;TLS_VERSION_1_2;TLS_VERSION_1_3;TLS_VERSION_INVALID;TLS_VERSION_UNSPECIFIED
// +kubebuilder:validation:Type=string
type TLSVersion int32

const (
	// buf:lint:ignore ENUM_ZERO_VALUE_SUFFIX
	TLSVersion_TLS_VERSION_AUTO        TLSVersion = 0
	TLSVersion_TLS_VERSION_1_0         TLSVersion = 1
	TLSVersion_TLS_VERSION_1_1         TLSVersion = 2
	TLSVersion_TLS_VERSION_1_2         TLSVersion = 3
	TLSVersion_TLS_VERSION_1_3         TLSVersion = 4
	TLSVersion_TLS_VERSION_INVALID     TLSVersion = 5
	TLSVersion_TLS_VERSION_UNSPECIFIED TLSVersion = 6
)

// Enum value maps for TLSVersion.
var (
	TLSVersion_name = map[int32]string{
		0: "TLS_VERSION_AUTO",
		1: "TLS_VERSION_1_0",
		2: "TLS_VERSION_1_1",
		3: "TLS_VERSION_1_2",
		4: "TLS_VERSION_1_3",
		5: "TLS_VERSION_INVALID",
		6: "TLS_VERSION_UNSPECIFIED",
	}
	TLSVersion_value = map[string]int32{
		"TLS_VERSION_AUTO":        0,
		"TLS_VERSION_1_0":         1,
		"TLS_VERSION_1_1":         2,
		"TLS_VERSION_1_2":         3,
		"TLS_VERSION_1_3":         4,
		"TLS_VERSION_INVALID":     5,
		"TLS_VERSION_UNSPECIFIED": 6,
	}
)

func (x TLSVersion) Enum() *TLSVersion {
	p := new(TLSVersion)
	*p = x
	return p
}

func (x TLSVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TLSVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_enumTypes[0].Descriptor()
}

func (TLSVersion) Type() protoreflect.EnumType {
	return &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_enumTypes[0]
}

func (x TLSVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TLSVersion.Descriptor instead.
func (TLSVersion) EnumDescriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescGZIP(), []int{0}
}

// +kubebuilder:validation:Enum=TLS_CIPHER_SUITE_ECDHE_ECDSA_AES128_GCM_SHA256;TLS_CIPHER_SUITE_AES256_SHA;TLS_CIPHER_SUITE_ECDHE_ECDSA_CHACHA20_POLY1305;TLS_CIPHER_SUITE_ECDHE_RSA_AES128_GCM_SHA256;TLS_CIPHER_SUITE_ECDHE_RSA_CHACHA20_POLY1305;TLS_CIPHER_SUITE_ECDHE_ECDSA_AES128_SHA;TLS_CIPHER_SUITE_ECDHE_RSA_AES128_SHA;TLS_CIPHER_SUITE_AES128_GCM_SHA256;TLS_CIPHER_SUITE_AES128_SHA;TLS_CIPHER_SUITE_ECDHE_ECDSA_AES256_GCM_SHA384;TLS_CIPHER_SUITE_ECDHE_RSA_AES256_GCM_SHA384;TLS_CIPHER_SUITE_ECDHE_ECDSA_AES256_SHA;TLS_CIPHER_SUITE_ECDHE_RSA_AES256_SHA;TLS_CIPHER_SUITE_AES256_GCM_SHA384
// +kubebuilder:validation:Type=string
type TLSCipherSuite int32

const (
	// buf:lint:ignore ENUM_ZERO_VALUE_SUFFIX
	TLSCipherSuite_TLS_CIPHER_SUITE_ECDHE_ECDSA_AES128_GCM_SHA256 TLSCipherSuite = 0
	TLSCipherSuite_TLS_CIPHER_SUITE_ECDHE_ECDSA_CHACHA20_POLY1305 TLSCipherSuite = 1
	TLSCipherSuite_TLS_CIPHER_SUITE_ECDHE_RSA_AES128_GCM_SHA256   TLSCipherSuite = 2
	TLSCipherSuite_TLS_CIPHER_SUITE_ECDHE_RSA_CHACHA20_POLY1305   TLSCipherSuite = 3
	TLSCipherSuite_TLS_CIPHER_SUITE_ECDHE_ECDSA_AES128_SHA        TLSCipherSuite = 4
	TLSCipherSuite_TLS_CIPHER_SUITE_ECDHE_RSA_AES128_SHA          TLSCipherSuite = 5
	TLSCipherSuite_TLS_CIPHER_SUITE_AES128_GCM_SHA256             TLSCipherSuite = 6
	TLSCipherSuite_TLS_CIPHER_SUITE_AES128_SHA                    TLSCipherSuite = 7
	TLSCipherSuite_TLS_CIPHER_SUITE_ECDHE_ECDSA_AES256_GCM_SHA384 TLSCipherSuite = 8
	TLSCipherSuite_TLS_CIPHER_SUITE_ECDHE_RSA_AES256_GCM_SHA384   TLSCipherSuite = 9
	TLSCipherSuite_TLS_CIPHER_SUITE_ECDHE_ECDSA_AES256_SHA        TLSCipherSuite = 10
	TLSCipherSuite_TLS_CIPHER_SUITE_ECDHE_RSA_AES256_SHA          TLSCipherSuite = 11
	TLSCipherSuite_TLS_CIPHER_SUITE_AES256_GCM_SHA384             TLSCipherSuite = 12
	TLSCipherSuite_TLS_CIPHER_SUITE_AES256_SHA                    TLSCipherSuite = 13
)

// Enum value maps for TLSCipherSuite.
var (
	TLSCipherSuite_name = map[int32]string{
		0:  "TLS_CIPHER_SUITE_ECDHE_ECDSA_AES128_GCM_SHA256",
		1:  "TLS_CIPHER_SUITE_ECDHE_ECDSA_CHACHA20_POLY1305",
		2:  "TLS_CIPHER_SUITE_ECDHE_RSA_AES128_GCM_SHA256",
		3:  "TLS_CIPHER_SUITE_ECDHE_RSA_CHACHA20_POLY1305",
		4:  "TLS_CIPHER_SUITE_ECDHE_ECDSA_AES128_SHA",
		5:  "TLS_CIPHER_SUITE_ECDHE_RSA_AES128_SHA",
		6:  "TLS_CIPHER_SUITE_AES128_GCM_SHA256",
		7:  "TLS_CIPHER_SUITE_AES128_SHA",
		8:  "TLS_CIPHER_SUITE_ECDHE_ECDSA_AES256_GCM_SHA384",
		9:  "TLS_CIPHER_SUITE_ECDHE_RSA_AES256_GCM_SHA384",
		10: "TLS_CIPHER_SUITE_ECDHE_ECDSA_AES256_SHA",
		11: "TLS_CIPHER_SUITE_ECDHE_RSA_AES256_SHA",
		12: "TLS_CIPHER_SUITE_AES256_GCM_SHA384",
		13: "TLS_CIPHER_SUITE_AES256_SHA",
	}
	TLSCipherSuite_value = map[string]int32{
		"TLS_CIPHER_SUITE_ECDHE_ECDSA_AES128_GCM_SHA256": 0,
		"TLS_CIPHER_SUITE_ECDHE_ECDSA_CHACHA20_POLY1305": 1,
		"TLS_CIPHER_SUITE_ECDHE_RSA_AES128_GCM_SHA256":   2,
		"TLS_CIPHER_SUITE_ECDHE_RSA_CHACHA20_POLY1305":   3,
		"TLS_CIPHER_SUITE_ECDHE_ECDSA_AES128_SHA":        4,
		"TLS_CIPHER_SUITE_ECDHE_RSA_AES128_SHA":          5,
		"TLS_CIPHER_SUITE_AES128_GCM_SHA256":             6,
		"TLS_CIPHER_SUITE_AES128_SHA":                    7,
		"TLS_CIPHER_SUITE_ECDHE_ECDSA_AES256_GCM_SHA384": 8,
		"TLS_CIPHER_SUITE_ECDHE_RSA_AES256_GCM_SHA384":   9,
		"TLS_CIPHER_SUITE_ECDHE_ECDSA_AES256_SHA":        10,
		"TLS_CIPHER_SUITE_ECDHE_RSA_AES256_SHA":          11,
		"TLS_CIPHER_SUITE_AES256_GCM_SHA384":             12,
		"TLS_CIPHER_SUITE_AES256_SHA":                    13,
	}
)

func (x TLSCipherSuite) Enum() *TLSCipherSuite {
	p := new(TLSCipherSuite)
	*p = x
	return p
}

func (x TLSCipherSuite) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TLSCipherSuite) Descriptor() protoreflect.EnumDescriptor {
	return file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_enumTypes[1].Descriptor()
}

func (TLSCipherSuite) Type() protoreflect.EnumType {
	return &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_enumTypes[1]
}

func (x TLSCipherSuite) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TLSCipherSuite.Descriptor instead.
func (TLSCipherSuite) EnumDescriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescGZIP(), []int{1}
}

type TLS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// inbound_tls_parameters has default TLS parameter configuration for inbound connections. These can be overridden per
	// transport socket.
	InboundTlsParameters *TLSParameters `protobuf:"bytes,1,opt,name=inbound_tls_parameters,json=inboundTlsParameters,proto3" json:"inbound_tls_parameters,omitempty"`
	// outbound_tls_parameters has default TLS parameter configuration for inbound connections. These can be overridden per transport socket.
	OutboundTlsParameters *TLSParameters `protobuf:"bytes,2,opt,name=outbound_tls_parameters,json=outboundTlsParameters,proto3" json:"outbound_tls_parameters,omitempty"`
}

func (x *TLS) Reset() {
	*x = TLS{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TLS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TLS) ProtoMessage() {}

func (x *TLS) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TLS.ProtoReflect.Descriptor instead.
func (*TLS) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescGZIP(), []int{0}
}

func (x *TLS) GetInboundTlsParameters() *TLSParameters {
	if x != nil {
		return x.InboundTlsParameters
	}
	return nil
}

func (x *TLS) GetOutboundTlsParameters() *TLSParameters {
	if x != nil {
		return x.OutboundTlsParameters
	}
	return nil
}

type TransportSocket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name of the transport socket
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are assignable to ConnectionTls:
	//
	//	*TransportSocket_InboundMesh
	//	*TransportSocket_OutboundMesh
	//	*TransportSocket_InboundNonMesh
	//	*TransportSocket_OutboundNonMesh
	ConnectionTls isTransportSocket_ConnectionTls `protobuf_oneof:"connection_tls"`
	// tls_parameters can override any top level tls parameters that are configured.
	TlsParameters *TLSParameters `protobuf:"bytes,6,opt,name=tls_parameters,json=tlsParameters,proto3" json:"tls_parameters,omitempty"`
	AlpnProtocols []string       `protobuf:"bytes,7,rep,name=alpn_protocols,json=alpnProtocols,proto3" json:"alpn_protocols,omitempty"`
}

func (x *TransportSocket) Reset() {
	*x = TransportSocket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransportSocket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransportSocket) ProtoMessage() {}

func (x *TransportSocket) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransportSocket.ProtoReflect.Descriptor instead.
func (*TransportSocket) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescGZIP(), []int{1}
}

func (x *TransportSocket) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *TransportSocket) GetConnectionTls() isTransportSocket_ConnectionTls {
	if m != nil {
		return m.ConnectionTls
	}
	return nil
}

func (x *TransportSocket) GetInboundMesh() *InboundMeshMTLS {
	if x, ok := x.GetConnectionTls().(*TransportSocket_InboundMesh); ok {
		return x.InboundMesh
	}
	return nil
}

func (x *TransportSocket) GetOutboundMesh() *OutboundMeshMTLS {
	if x, ok := x.GetConnectionTls().(*TransportSocket_OutboundMesh); ok {
		return x.OutboundMesh
	}
	return nil
}

func (x *TransportSocket) GetInboundNonMesh() *InboundNonMeshTLS {
	if x, ok := x.GetConnectionTls().(*TransportSocket_InboundNonMesh); ok {
		return x.InboundNonMesh
	}
	return nil
}

func (x *TransportSocket) GetOutboundNonMesh() *OutboundNonMeshTLS {
	if x, ok := x.GetConnectionTls().(*TransportSocket_OutboundNonMesh); ok {
		return x.OutboundNonMesh
	}
	return nil
}

func (x *TransportSocket) GetTlsParameters() *TLSParameters {
	if x != nil {
		return x.TlsParameters
	}
	return nil
}

func (x *TransportSocket) GetAlpnProtocols() []string {
	if x != nil {
		return x.AlpnProtocols
	}
	return nil
}

type isTransportSocket_ConnectionTls interface {
	isTransportSocket_ConnectionTls()
}

type TransportSocket_InboundMesh struct {
	// inbound_mesh is for incoming connections FROM the mesh.
	InboundMesh *InboundMeshMTLS `protobuf:"bytes,2,opt,name=inbound_mesh,json=inboundMesh,proto3,oneof"`
}

type TransportSocket_OutboundMesh struct {
	// outbound_mesh is for outbound connections TO mesh destinations.
	OutboundMesh *OutboundMeshMTLS `protobuf:"bytes,3,opt,name=outbound_mesh,json=outboundMesh,proto3,oneof"`
}

type TransportSocket_InboundNonMesh struct {
	// inbound_non_mesh is for incoming connections FROM non mesh.
	InboundNonMesh *InboundNonMeshTLS `protobuf:"bytes,4,opt,name=inbound_non_mesh,json=inboundNonMesh,proto3,oneof"`
}

type TransportSocket_OutboundNonMesh struct {
	// outbound_non_mesh is for outbound connections TO non mesh destinations.
	OutboundNonMesh *OutboundNonMeshTLS `protobuf:"bytes,5,opt,name=outbound_non_mesh,json=outboundNonMesh,proto3,oneof"`
}

func (*TransportSocket_InboundMesh) isTransportSocket_ConnectionTls() {}

func (*TransportSocket_OutboundMesh) isTransportSocket_ConnectionTls() {}

func (*TransportSocket_InboundNonMesh) isTransportSocket_ConnectionTls() {}

func (*TransportSocket_OutboundNonMesh) isTransportSocket_ConnectionTls() {}

type InboundMeshMTLS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// identity_key is UUID key to use to look up the leaf certificate in ProxyState to present for incoming connections.
	IdentityKey string `protobuf:"bytes,1,opt,name=identity_key,json=identityKey,proto3" json:"identity_key,omitempty"`
	// validation_context has what is needed to validate incoming connections.
	ValidationContext *MeshInboundValidationContext `protobuf:"bytes,2,opt,name=validation_context,json=validationContext,proto3" json:"validation_context,omitempty"`
}

func (x *InboundMeshMTLS) Reset() {
	*x = InboundMeshMTLS{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InboundMeshMTLS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InboundMeshMTLS) ProtoMessage() {}

func (x *InboundMeshMTLS) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InboundMeshMTLS.ProtoReflect.Descriptor instead.
func (*InboundMeshMTLS) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescGZIP(), []int{2}
}

func (x *InboundMeshMTLS) GetIdentityKey() string {
	if x != nil {
		return x.IdentityKey
	}
	return ""
}

func (x *InboundMeshMTLS) GetValidationContext() *MeshInboundValidationContext {
	if x != nil {
		return x.ValidationContext
	}
	return nil
}

type OutboundMeshMTLS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// identity_key is UUID key to use to look up the leaf certificate in ProxyState when connecting to destinations.
	IdentityKey string `protobuf:"bytes,1,opt,name=identity_key,json=identityKey,proto3" json:"identity_key,omitempty"`
	// validation_context has what is needed to validate the destination.
	ValidationContext *MeshOutboundValidationContext `protobuf:"bytes,2,opt,name=validation_context,json=validationContext,proto3" json:"validation_context,omitempty"`
	// sni to use when connecting to the destination.
	Sni string `protobuf:"bytes,3,opt,name=sni,proto3" json:"sni,omitempty"`
}

func (x *OutboundMeshMTLS) Reset() {
	*x = OutboundMeshMTLS{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutboundMeshMTLS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutboundMeshMTLS) ProtoMessage() {}

func (x *OutboundMeshMTLS) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutboundMeshMTLS.ProtoReflect.Descriptor instead.
func (*OutboundMeshMTLS) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescGZIP(), []int{3}
}

func (x *OutboundMeshMTLS) GetIdentityKey() string {
	if x != nil {
		return x.IdentityKey
	}
	return ""
}

func (x *OutboundMeshMTLS) GetValidationContext() *MeshOutboundValidationContext {
	if x != nil {
		return x.ValidationContext
	}
	return nil
}

func (x *OutboundMeshMTLS) GetSni() string {
	if x != nil {
		return x.Sni
	}
	return ""
}

type InboundNonMeshTLS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// identity is the reference to the leaf certificate to present for incoming connections.
	//
	// Types that are assignable to Identity:
	//
	//	*InboundNonMeshTLS_LeafKey
	//	*InboundNonMeshTLS_Sds
	Identity isInboundNonMeshTLS_Identity `protobuf_oneof:"identity"`
}

func (x *InboundNonMeshTLS) Reset() {
	*x = InboundNonMeshTLS{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InboundNonMeshTLS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InboundNonMeshTLS) ProtoMessage() {}

func (x *InboundNonMeshTLS) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InboundNonMeshTLS.ProtoReflect.Descriptor instead.
func (*InboundNonMeshTLS) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescGZIP(), []int{4}
}

func (m *InboundNonMeshTLS) GetIdentity() isInboundNonMeshTLS_Identity {
	if m != nil {
		return m.Identity
	}
	return nil
}

func (x *InboundNonMeshTLS) GetLeafKey() string {
	if x, ok := x.GetIdentity().(*InboundNonMeshTLS_LeafKey); ok {
		return x.LeafKey
	}
	return ""
}

func (x *InboundNonMeshTLS) GetSds() *SDSCertificate {
	if x, ok := x.GetIdentity().(*InboundNonMeshTLS_Sds); ok {
		return x.Sds
	}
	return nil
}

type isInboundNonMeshTLS_Identity interface {
	isInboundNonMeshTLS_Identity()
}

type InboundNonMeshTLS_LeafKey struct {
	// leaf_key is the UUID key to use to look up the leaf certificate in the ProxyState leaf certificate map.
	LeafKey string `protobuf:"bytes,1,opt,name=leaf_key,json=leafKey,proto3,oneof"`
}

type InboundNonMeshTLS_Sds struct {
	// sds refers to certificates retrieved via Envoy SDS.
	Sds *SDSCertificate `protobuf:"bytes,2,opt,name=sds,proto3,oneof"`
}

func (*InboundNonMeshTLS_LeafKey) isInboundNonMeshTLS_Identity() {}

func (*InboundNonMeshTLS_Sds) isInboundNonMeshTLS_Identity() {}

type OutboundNonMeshTLS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// cert_file is a filename for a certificate to present for outbound connections.
	CertFile string `protobuf:"bytes,1,opt,name=cert_file,json=certFile,proto3" json:"cert_file,omitempty"`
	// key_file is a filename for a key for outbound connections.
	KeyFile string `protobuf:"bytes,2,opt,name=key_file,json=keyFile,proto3" json:"key_file,omitempty"`
	// validation_context has what is needed to validate the destination.
	ValidationContext *NonMeshOutboundValidationContext `protobuf:"bytes,3,opt,name=validation_context,json=validationContext,proto3" json:"validation_context,omitempty"`
}

func (x *OutboundNonMeshTLS) Reset() {
	*x = OutboundNonMeshTLS{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutboundNonMeshTLS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutboundNonMeshTLS) ProtoMessage() {}

func (x *OutboundNonMeshTLS) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutboundNonMeshTLS.ProtoReflect.Descriptor instead.
func (*OutboundNonMeshTLS) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescGZIP(), []int{5}
}

func (x *OutboundNonMeshTLS) GetCertFile() string {
	if x != nil {
		return x.CertFile
	}
	return ""
}

func (x *OutboundNonMeshTLS) GetKeyFile() string {
	if x != nil {
		return x.KeyFile
	}
	return ""
}

func (x *OutboundNonMeshTLS) GetValidationContext() *NonMeshOutboundValidationContext {
	if x != nil {
		return x.ValidationContext
	}
	return nil
}

type MeshInboundValidationContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// trust_bundle_peer_name_keys is which trust bundles to use for validating incoming connections. If this workload is exported
	// to peers, the incoming connection could be from a different peer, requiring that trust bundle to validate the
	// connection. These could be local or peered trust bundles. This will be a key in the trust bundle map.
	TrustBundlePeerNameKeys []string `protobuf:"bytes,1,rep,name=trust_bundle_peer_name_keys,json=trustBundlePeerNameKeys,proto3" json:"trust_bundle_peer_name_keys,omitempty"`
}

func (x *MeshInboundValidationContext) Reset() {
	*x = MeshInboundValidationContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MeshInboundValidationContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshInboundValidationContext) ProtoMessage() {}

func (x *MeshInboundValidationContext) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshInboundValidationContext.ProtoReflect.Descriptor instead.
func (*MeshInboundValidationContext) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescGZIP(), []int{6}
}

func (x *MeshInboundValidationContext) GetTrustBundlePeerNameKeys() []string {
	if x != nil {
		return x.TrustBundlePeerNameKeys
	}
	return nil
}

type MeshOutboundValidationContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// trust_bundle_peer_name_key is which trust bundle to use for the destination. It could be the local or a peer's trust bundle.
	// This will be a key in the trust bundle map.
	TrustBundlePeerNameKey string `protobuf:"bytes,1,opt,name=trust_bundle_peer_name_key,json=trustBundlePeerNameKey,proto3" json:"trust_bundle_peer_name_key,omitempty"`
	// spiffe_ids is one or more spiffe IDs to validate.
	SpiffeIds []string `protobuf:"bytes,2,rep,name=spiffe_ids,json=spiffeIds,proto3" json:"spiffe_ids,omitempty"`
}

func (x *MeshOutboundValidationContext) Reset() {
	*x = MeshOutboundValidationContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MeshOutboundValidationContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshOutboundValidationContext) ProtoMessage() {}

func (x *MeshOutboundValidationContext) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshOutboundValidationContext.ProtoReflect.Descriptor instead.
func (*MeshOutboundValidationContext) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescGZIP(), []int{7}
}

func (x *MeshOutboundValidationContext) GetTrustBundlePeerNameKey() string {
	if x != nil {
		return x.TrustBundlePeerNameKey
	}
	return ""
}

func (x *MeshOutboundValidationContext) GetSpiffeIds() []string {
	if x != nil {
		return x.SpiffeIds
	}
	return nil
}

type NonMeshOutboundValidationContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ca_file is a filename for a ca for outbound connections to validate the destination.
	CaFile string `protobuf:"bytes,1,opt,name=ca_file,json=caFile,proto3" json:"ca_file,omitempty"`
}

func (x *NonMeshOutboundValidationContext) Reset() {
	*x = NonMeshOutboundValidationContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NonMeshOutboundValidationContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NonMeshOutboundValidationContext) ProtoMessage() {}

func (x *NonMeshOutboundValidationContext) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NonMeshOutboundValidationContext.ProtoReflect.Descriptor instead.
func (*NonMeshOutboundValidationContext) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescGZIP(), []int{8}
}

func (x *NonMeshOutboundValidationContext) GetCaFile() string {
	if x != nil {
		return x.CaFile
	}
	return ""
}

type SDSCertificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClusterName  string `protobuf:"bytes,1,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	CertResource string `protobuf:"bytes,2,opt,name=cert_resource,json=certResource,proto3" json:"cert_resource,omitempty"`
}

func (x *SDSCertificate) Reset() {
	*x = SDSCertificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SDSCertificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SDSCertificate) ProtoMessage() {}

func (x *SDSCertificate) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SDSCertificate.ProtoReflect.Descriptor instead.
func (*SDSCertificate) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescGZIP(), []int{9}
}

func (x *SDSCertificate) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

func (x *SDSCertificate) GetCertResource() string {
	if x != nil {
		return x.CertResource
	}
	return ""
}

type TLSParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MinVersion   TLSVersion       `protobuf:"varint,1,opt,name=min_version,json=minVersion,proto3,enum=hashicorp.consul.mesh.v2beta1.pbproxystate.TLSVersion" json:"min_version,omitempty"`
	MaxVersion   TLSVersion       `protobuf:"varint,2,opt,name=max_version,json=maxVersion,proto3,enum=hashicorp.consul.mesh.v2beta1.pbproxystate.TLSVersion" json:"max_version,omitempty"`
	CipherSuites []TLSCipherSuite `protobuf:"varint,3,rep,packed,name=cipher_suites,json=cipherSuites,proto3,enum=hashicorp.consul.mesh.v2beta1.pbproxystate.TLSCipherSuite" json:"cipher_suites,omitempty"`
}

func (x *TLSParameters) Reset() {
	*x = TLSParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TLSParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TLSParameters) ProtoMessage() {}

func (x *TLSParameters) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TLSParameters.ProtoReflect.Descriptor instead.
func (*TLSParameters) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescGZIP(), []int{10}
}

func (x *TLSParameters) GetMinVersion() TLSVersion {
	if x != nil {
		return x.MinVersion
	}
	return TLSVersion_TLS_VERSION_AUTO
}

func (x *TLSParameters) GetMaxVersion() TLSVersion {
	if x != nil {
		return x.MaxVersion
	}
	return TLSVersion_TLS_VERSION_AUTO
}

func (x *TLSParameters) GetCipherSuites() []TLSCipherSuite {
	if x != nil {
		return x.CipherSuites
	}
	return nil
}

type LeafCertificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Cert string `protobuf:"bytes,1,opt,name=cert,proto3" json:"cert,omitempty"`
	Key  string `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *LeafCertificate) Reset() {
	*x = LeafCertificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LeafCertificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LeafCertificate) ProtoMessage() {}

func (x *LeafCertificate) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LeafCertificate.ProtoReflect.Descriptor instead.
func (*LeafCertificate) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescGZIP(), []int{11}
}

func (x *LeafCertificate) GetCert() string {
	if x != nil {
		return x.Cert
	}
	return ""
}

func (x *LeafCertificate) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

type TrustBundle struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TrustDomain string   `protobuf:"bytes,1,opt,name=trust_domain,json=trustDomain,proto3" json:"trust_domain,omitempty"`
	Roots       []string `protobuf:"bytes,2,rep,name=roots,proto3" json:"roots,omitempty"`
}

func (x *TrustBundle) Reset() {
	*x = TrustBundle{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrustBundle) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrustBundle) ProtoMessage() {}

func (x *TrustBundle) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrustBundle.ProtoReflect.Descriptor instead.
func (*TrustBundle) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescGZIP(), []int{12}
}

func (x *TrustBundle) GetTrustDomain() string {
	if x != nil {
		return x.TrustDomain
	}
	return ""
}

func (x *TrustBundle) GetRoots() []string {
	if x != nil {
		return x.Roots
	}
	return nil
}

var File_pbmesh_v2beta1_pbproxystate_transport_socket_proto protoreflect.FileDescriptor

var file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDesc = []byte{
	0x0a, 0x32, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2a, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x22, 0xe9, 0x01, 0x0a, 0x03, 0x54, 0x4c, 0x53, 0x12, 0x6f, 0x0a, 0x16, 0x69, 0x6e, 0x62, 0x6f,
	0x75, 0x6e, 0x64, 0x5f, 0x74, 0x6c, 0x73, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x54, 0x4c, 0x53, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x52, 0x14, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x54, 0x6c, 0x73, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x71, 0x0a, 0x17, 0x6f, 0x75, 0x74,
	0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x74, 0x6c, 0x73, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65,
	0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f,
	0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x54, 0x4c, 0x53, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x15, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x54,
	0x6c, 0x73, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0xe0, 0x04, 0x0a,
	0x0f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x6f, 0x63, 0x6b, 0x65, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x60, 0x0a, 0x0c, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f,
	0x6d, 0x65, 0x73, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65,
	0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f,
	0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4d,
	0x65, 0x73, 0x68, 0x4d, 0x54, 0x4c, 0x53, 0x48, 0x00, 0x52, 0x0b, 0x69, 0x6e, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x4d, 0x65, 0x73, 0x68, 0x12, 0x63, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x5f, 0x6d, 0x65, 0x73, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62,
	0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x4f, 0x75, 0x74, 0x62, 0x6f,
	0x75, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x68, 0x4d, 0x54, 0x4c, 0x53, 0x48, 0x00, 0x52, 0x0c, 0x6f,
	0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x68, 0x12, 0x69, 0x0a, 0x10, 0x69,
	0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x6e, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x73, 0x68, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x2e, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4e, 0x6f, 0x6e, 0x4d, 0x65, 0x73,
	0x68, 0x54, 0x4c, 0x53, 0x48, 0x00, 0x52, 0x0e, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4e,
	0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x68, 0x12, 0x6c, 0x0a, 0x11, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x5f, 0x6e, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x73, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x4f,
	0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4e, 0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x68, 0x54, 0x4c,
	0x53, 0x48, 0x00, 0x52, 0x0f, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4e, 0x6f, 0x6e,
	0x4d, 0x65, 0x73, 0x68, 0x12, 0x60, 0x0a, 0x0e, 0x74, 0x6c, 0x73, 0x5f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70,
	0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x54, 0x4c, 0x53, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x0d, 0x74, 0x6c, 0x73, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x6c, 0x70, 0x6e, 0x5f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d,
	0x61, 0x6c, 0x70, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x73, 0x42, 0x10, 0x0a,
	0x0e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6c, 0x73, 0x22,
	0xad, 0x01, 0x0a, 0x0f, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x68, 0x4d,
	0x54, 0x4c, 0x53, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x4b, 0x65, 0x79, 0x12, 0x77, 0x0a, 0x12, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x48, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e,
	0x4d, 0x65, 0x73, 0x68, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x11, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22,
	0xc1, 0x01, 0x0a, 0x10, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x68,
	0x4d, 0x54, 0x4c, 0x53, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x4b, 0x65, 0x79, 0x12, 0x78, 0x0a, 0x12, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x4d, 0x65, 0x73, 0x68, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x11,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x6e, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x73, 0x6e, 0x69, 0x22, 0x8c, 0x01, 0x0a, 0x11, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4e,
	0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x68, 0x54, 0x4c, 0x53, 0x12, 0x1b, 0x0a, 0x08, 0x6c, 0x65, 0x61,
	0x66, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x6c,
	0x65, 0x61, 0x66, 0x4b, 0x65, 0x79, 0x12, 0x4e, 0x0a, 0x03, 0x73, 0x64, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x53, 0x44, 0x53, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x48,
	0x00, 0x52, 0x03, 0x73, 0x64, 0x73, 0x42, 0x0a, 0x0a, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x22, 0xc9, 0x01, 0x0a, 0x12, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4e,
	0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x68, 0x54, 0x4c, 0x53, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x65, 0x72,
	0x74, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x65,
	0x72, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x66, 0x69,
	0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x46, 0x69, 0x6c,
	0x65, 0x12, 0x7b, 0x0a, 0x12, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62,
	0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x4e, 0x6f, 0x6e, 0x4d, 0x65,
	0x73, 0x68, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x11, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x5c,
	0x0a, 0x1c, 0x4d, 0x65, 0x73, 0x68, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x3c,
	0x0a, 0x1b, 0x74, 0x72, 0x75, 0x73, 0x74, 0x5f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x5f, 0x70,
	0x65, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x17, 0x74, 0x72, 0x75, 0x73, 0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65,
	0x50, 0x65, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x22, 0x7a, 0x0a, 0x1d,
	0x4d, 0x65, 0x73, 0x68, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x3a, 0x0a,
	0x1a, 0x74, 0x72, 0x75, 0x73, 0x74, 0x5f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x5f, 0x70, 0x65,
	0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x16, 0x74, 0x72, 0x75, 0x73, 0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x50, 0x65,
	0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x70, 0x69,
	0x66, 0x66, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x73,
	0x70, 0x69, 0x66, 0x66, 0x65, 0x49, 0x64, 0x73, 0x22, 0x3b, 0x0a, 0x20, 0x4e, 0x6f, 0x6e, 0x4d,
	0x65, 0x73, 0x68, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x17, 0x0a, 0x07,
	0x63, 0x61, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63,
	0x61, 0x46, 0x69, 0x6c, 0x65, 0x22, 0x58, 0x0a, 0x0e, 0x53, 0x44, 0x53, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x65,
	0x72, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x63, 0x65, 0x72, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22,
	0xa2, 0x02, 0x0a, 0x0d, 0x54, 0x4c, 0x53, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x12, 0x57, 0x0a, 0x0b, 0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x2e, 0x54, 0x4c, 0x53, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a,
	0x6d, 0x69, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x0b, 0x6d, 0x61,
	0x78, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x36, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x54, 0x4c, 0x53,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x5f, 0x0a, 0x0d, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x5f, 0x73, 0x75,
	0x69, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65,
	0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f,
	0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x54, 0x4c, 0x53, 0x43, 0x69, 0x70, 0x68, 0x65,
	0x72, 0x53, 0x75, 0x69, 0x74, 0x65, 0x52, 0x0c, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x53, 0x75,
	0x69, 0x74, 0x65, 0x73, 0x22, 0x37, 0x0a, 0x0f, 0x4c, 0x65, 0x61, 0x66, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x65, 0x72, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x63, 0x65, 0x72, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0x46, 0x0a,
	0x0b, 0x54, 0x72, 0x75, 0x73, 0x74, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x74, 0x72, 0x75, 0x73, 0x74, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x74, 0x72, 0x75, 0x73, 0x74, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12,
	0x14, 0x0a, 0x05, 0x72, 0x6f, 0x6f, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05,
	0x72, 0x6f, 0x6f, 0x74, 0x73, 0x2a, 0xac, 0x01, 0x0a, 0x0a, 0x54, 0x4c, 0x53, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x4c, 0x53, 0x5f, 0x56, 0x45, 0x52, 0x53,
	0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x55, 0x54, 0x4f, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x4c,
	0x53, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x31, 0x5f, 0x30, 0x10, 0x01, 0x12,
	0x13, 0x0a, 0x0f, 0x54, 0x4c, 0x53, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x31,
	0x5f, 0x31, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x4c, 0x53, 0x5f, 0x56, 0x45, 0x52, 0x53,
	0x49, 0x4f, 0x4e, 0x5f, 0x31, 0x5f, 0x32, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x4c, 0x53,
	0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x31, 0x5f, 0x33, 0x10, 0x04, 0x12, 0x17,
	0x0a, 0x13, 0x54, 0x4c, 0x53, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x4e,
	0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x05, 0x12, 0x1b, 0x0a, 0x17, 0x54, 0x4c, 0x53, 0x5f, 0x56,
	0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x06, 0x2a, 0x84, 0x05, 0x0a, 0x0e, 0x54, 0x4c, 0x53, 0x43, 0x69, 0x70, 0x68,
	0x65, 0x72, 0x53, 0x75, 0x69, 0x74, 0x65, 0x12, 0x32, 0x0a, 0x2e, 0x54, 0x4c, 0x53, 0x5f, 0x43,
	0x49, 0x50, 0x48, 0x45, 0x52, 0x5f, 0x53, 0x55, 0x49, 0x54, 0x45, 0x5f, 0x45, 0x43, 0x44, 0x48,
	0x45, 0x5f, 0x45, 0x43, 0x44, 0x53, 0x41, 0x5f, 0x41, 0x45, 0x53, 0x31, 0x32, 0x38, 0x5f, 0x47,
	0x43, 0x4d, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x00, 0x12, 0x32, 0x0a, 0x2e, 0x54,
	0x4c, 0x53, 0x5f, 0x43, 0x49, 0x50, 0x48, 0x45, 0x52, 0x5f, 0x53, 0x55, 0x49, 0x54, 0x45, 0x5f,
	0x45, 0x43, 0x44, 0x48, 0x45, 0x5f, 0x45, 0x43, 0x44, 0x53, 0x41, 0x5f, 0x43, 0x48, 0x41, 0x43,
	0x48, 0x41, 0x32, 0x30, 0x5f, 0x50, 0x4f, 0x4c, 0x59, 0x31, 0x33, 0x30, 0x35, 0x10, 0x01, 0x12,
	0x30, 0x0a, 0x2c, 0x54, 0x4c, 0x53, 0x5f, 0x43, 0x49, 0x50, 0x48, 0x45, 0x52, 0x5f, 0x53, 0x55,
	0x49, 0x54, 0x45, 0x5f, 0x45, 0x43, 0x44, 0x48, 0x45, 0x5f, 0x52, 0x53, 0x41, 0x5f, 0x41, 0x45,
	0x53, 0x31, 0x32, 0x38, 0x5f, 0x47, 0x43, 0x4d, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10,
	0x02, 0x12, 0x30, 0x0a, 0x2c, 0x54, 0x4c, 0x53, 0x5f, 0x43, 0x49, 0x50, 0x48, 0x45, 0x52, 0x5f,
	0x53, 0x55, 0x49, 0x54, 0x45, 0x5f, 0x45, 0x43, 0x44, 0x48, 0x45, 0x5f, 0x52, 0x53, 0x41, 0x5f,
	0x43, 0x48, 0x41, 0x43, 0x48, 0x41, 0x32, 0x30, 0x5f, 0x50, 0x4f, 0x4c, 0x59, 0x31, 0x33, 0x30,
	0x35, 0x10, 0x03, 0x12, 0x2b, 0x0a, 0x27, 0x54, 0x4c, 0x53, 0x5f, 0x43, 0x49, 0x50, 0x48, 0x45,
	0x52, 0x5f, 0x53, 0x55, 0x49, 0x54, 0x45, 0x5f, 0x45, 0x43, 0x44, 0x48, 0x45, 0x5f, 0x45, 0x43,
	0x44, 0x53, 0x41, 0x5f, 0x41, 0x45, 0x53, 0x31, 0x32, 0x38, 0x5f, 0x53, 0x48, 0x41, 0x10, 0x04,
	0x12, 0x29, 0x0a, 0x25, 0x54, 0x4c, 0x53, 0x5f, 0x43, 0x49, 0x50, 0x48, 0x45, 0x52, 0x5f, 0x53,
	0x55, 0x49, 0x54, 0x45, 0x5f, 0x45, 0x43, 0x44, 0x48, 0x45, 0x5f, 0x52, 0x53, 0x41, 0x5f, 0x41,
	0x45, 0x53, 0x31, 0x32, 0x38, 0x5f, 0x53, 0x48, 0x41, 0x10, 0x05, 0x12, 0x26, 0x0a, 0x22, 0x54,
	0x4c, 0x53, 0x5f, 0x43, 0x49, 0x50, 0x48, 0x45, 0x52, 0x5f, 0x53, 0x55, 0x49, 0x54, 0x45, 0x5f,
	0x41, 0x45, 0x53, 0x31, 0x32, 0x38, 0x5f, 0x47, 0x43, 0x4d, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35,
	0x36, 0x10, 0x06, 0x12, 0x1f, 0x0a, 0x1b, 0x54, 0x4c, 0x53, 0x5f, 0x43, 0x49, 0x50, 0x48, 0x45,
	0x52, 0x5f, 0x53, 0x55, 0x49, 0x54, 0x45, 0x5f, 0x41, 0x45, 0x53, 0x31, 0x32, 0x38, 0x5f, 0x53,
	0x48, 0x41, 0x10, 0x07, 0x12, 0x32, 0x0a, 0x2e, 0x54, 0x4c, 0x53, 0x5f, 0x43, 0x49, 0x50, 0x48,
	0x45, 0x52, 0x5f, 0x53, 0x55, 0x49, 0x54, 0x45, 0x5f, 0x45, 0x43, 0x44, 0x48, 0x45, 0x5f, 0x45,
	0x43, 0x44, 0x53, 0x41, 0x5f, 0x41, 0x45, 0x53, 0x32, 0x35, 0x36, 0x5f, 0x47, 0x43, 0x4d, 0x5f,
	0x53, 0x48, 0x41, 0x33, 0x38, 0x34, 0x10, 0x08, 0x12, 0x30, 0x0a, 0x2c, 0x54, 0x4c, 0x53, 0x5f,
	0x43, 0x49, 0x50, 0x48, 0x45, 0x52, 0x5f, 0x53, 0x55, 0x49, 0x54, 0x45, 0x5f, 0x45, 0x43, 0x44,
	0x48, 0x45, 0x5f, 0x52, 0x53, 0x41, 0x5f, 0x41, 0x45, 0x53, 0x32, 0x35, 0x36, 0x5f, 0x47, 0x43,
	0x4d, 0x5f, 0x53, 0x48, 0x41, 0x33, 0x38, 0x34, 0x10, 0x09, 0x12, 0x2b, 0x0a, 0x27, 0x54, 0x4c,
	0x53, 0x5f, 0x43, 0x49, 0x50, 0x48, 0x45, 0x52, 0x5f, 0x53, 0x55, 0x49, 0x54, 0x45, 0x5f, 0x45,
	0x43, 0x44, 0x48, 0x45, 0x5f, 0x45, 0x43, 0x44, 0x53, 0x41, 0x5f, 0x41, 0x45, 0x53, 0x32, 0x35,
	0x36, 0x5f, 0x53, 0x48, 0x41, 0x10, 0x0a, 0x12, 0x29, 0x0a, 0x25, 0x54, 0x4c, 0x53, 0x5f, 0x43,
	0x49, 0x50, 0x48, 0x45, 0x52, 0x5f, 0x53, 0x55, 0x49, 0x54, 0x45, 0x5f, 0x45, 0x43, 0x44, 0x48,
	0x45, 0x5f, 0x52, 0x53, 0x41, 0x5f, 0x41, 0x45, 0x53, 0x32, 0x35, 0x36, 0x5f, 0x53, 0x48, 0x41,
	0x10, 0x0b, 0x12, 0x26, 0x0a, 0x22, 0x54, 0x4c, 0x53, 0x5f, 0x43, 0x49, 0x50, 0x48, 0x45, 0x52,
	0x5f, 0x53, 0x55, 0x49, 0x54, 0x45, 0x5f, 0x41, 0x45, 0x53, 0x32, 0x35, 0x36, 0x5f, 0x47, 0x43,
	0x4d, 0x5f, 0x53, 0x48, 0x41, 0x33, 0x38, 0x34, 0x10, 0x0c, 0x12, 0x1f, 0x0a, 0x1b, 0x54, 0x4c,
	0x53, 0x5f, 0x43, 0x49, 0x50, 0x48, 0x45, 0x52, 0x5f, 0x53, 0x55, 0x49, 0x54, 0x45, 0x5f, 0x41,
	0x45, 0x53, 0x32, 0x35, 0x36, 0x5f, 0x53, 0x48, 0x41, 0x10, 0x0d, 0x42, 0xda, 0x02, 0x0a, 0x2e,
	0x63, 0x6f, 0x6d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x42, 0x14,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x2f, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0xa2, 0x02, 0x05, 0x48,
	0x43, 0x4d, 0x56, 0x50, 0xaa, 0x02, 0x2a, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x4d, 0x65, 0x73, 0x68, 0x2e, 0x56, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74,
	0x65, 0xca, 0x02, 0x2a, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x5c, 0x4d, 0x65, 0x73, 0x68, 0x5c, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x5c, 0x50, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0xe2, 0x02,
	0x36, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x5c, 0x4d, 0x65, 0x73, 0x68, 0x5c, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x5c, 0x50,
	0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5c, 0x47, 0x50, 0x42, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x3a, 0x3a, 0x4d, 0x65, 0x73,
	0x68, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3a, 0x3a, 0x50, 0x62, 0x70, 0x72,
	0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescOnce sync.Once
	file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescData = file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDesc
)

func file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescGZIP() []byte {
	file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescOnce.Do(func() {
		file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescData = protoimpl.X.CompressGZIP(file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescData)
	})
	return file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDescData
}

var file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_goTypes = []interface{}{
	(TLSVersion)(0),                          // 0: hashicorp.consul.mesh.v2beta1.pbproxystate.TLSVersion
	(TLSCipherSuite)(0),                      // 1: hashicorp.consul.mesh.v2beta1.pbproxystate.TLSCipherSuite
	(*TLS)(nil),                              // 2: hashicorp.consul.mesh.v2beta1.pbproxystate.TLS
	(*TransportSocket)(nil),                  // 3: hashicorp.consul.mesh.v2beta1.pbproxystate.TransportSocket
	(*InboundMeshMTLS)(nil),                  // 4: hashicorp.consul.mesh.v2beta1.pbproxystate.InboundMeshMTLS
	(*OutboundMeshMTLS)(nil),                 // 5: hashicorp.consul.mesh.v2beta1.pbproxystate.OutboundMeshMTLS
	(*InboundNonMeshTLS)(nil),                // 6: hashicorp.consul.mesh.v2beta1.pbproxystate.InboundNonMeshTLS
	(*OutboundNonMeshTLS)(nil),               // 7: hashicorp.consul.mesh.v2beta1.pbproxystate.OutboundNonMeshTLS
	(*MeshInboundValidationContext)(nil),     // 8: hashicorp.consul.mesh.v2beta1.pbproxystate.MeshInboundValidationContext
	(*MeshOutboundValidationContext)(nil),    // 9: hashicorp.consul.mesh.v2beta1.pbproxystate.MeshOutboundValidationContext
	(*NonMeshOutboundValidationContext)(nil), // 10: hashicorp.consul.mesh.v2beta1.pbproxystate.NonMeshOutboundValidationContext
	(*SDSCertificate)(nil),                   // 11: hashicorp.consul.mesh.v2beta1.pbproxystate.SDSCertificate
	(*TLSParameters)(nil),                    // 12: hashicorp.consul.mesh.v2beta1.pbproxystate.TLSParameters
	(*LeafCertificate)(nil),                  // 13: hashicorp.consul.mesh.v2beta1.pbproxystate.LeafCertificate
	(*TrustBundle)(nil),                      // 14: hashicorp.consul.mesh.v2beta1.pbproxystate.TrustBundle
}
var file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_depIdxs = []int32{
	12, // 0: hashicorp.consul.mesh.v2beta1.pbproxystate.TLS.inbound_tls_parameters:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.TLSParameters
	12, // 1: hashicorp.consul.mesh.v2beta1.pbproxystate.TLS.outbound_tls_parameters:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.TLSParameters
	4,  // 2: hashicorp.consul.mesh.v2beta1.pbproxystate.TransportSocket.inbound_mesh:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.InboundMeshMTLS
	5,  // 3: hashicorp.consul.mesh.v2beta1.pbproxystate.TransportSocket.outbound_mesh:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.OutboundMeshMTLS
	6,  // 4: hashicorp.consul.mesh.v2beta1.pbproxystate.TransportSocket.inbound_non_mesh:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.InboundNonMeshTLS
	7,  // 5: hashicorp.consul.mesh.v2beta1.pbproxystate.TransportSocket.outbound_non_mesh:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.OutboundNonMeshTLS
	12, // 6: hashicorp.consul.mesh.v2beta1.pbproxystate.TransportSocket.tls_parameters:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.TLSParameters
	8,  // 7: hashicorp.consul.mesh.v2beta1.pbproxystate.InboundMeshMTLS.validation_context:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.MeshInboundValidationContext
	9,  // 8: hashicorp.consul.mesh.v2beta1.pbproxystate.OutboundMeshMTLS.validation_context:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.MeshOutboundValidationContext
	11, // 9: hashicorp.consul.mesh.v2beta1.pbproxystate.InboundNonMeshTLS.sds:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.SDSCertificate
	10, // 10: hashicorp.consul.mesh.v2beta1.pbproxystate.OutboundNonMeshTLS.validation_context:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.NonMeshOutboundValidationContext
	0,  // 11: hashicorp.consul.mesh.v2beta1.pbproxystate.TLSParameters.min_version:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.TLSVersion
	0,  // 12: hashicorp.consul.mesh.v2beta1.pbproxystate.TLSParameters.max_version:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.TLSVersion
	1,  // 13: hashicorp.consul.mesh.v2beta1.pbproxystate.TLSParameters.cipher_suites:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.TLSCipherSuite
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_init() }
func file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_init() {
	if File_pbmesh_v2beta1_pbproxystate_transport_socket_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TLS); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransportSocket); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InboundMeshMTLS); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutboundMeshMTLS); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InboundNonMeshTLS); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutboundNonMeshTLS); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MeshInboundValidationContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MeshOutboundValidationContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NonMeshOutboundValidationContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SDSCertificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TLSParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LeafCertificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrustBundle); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*TransportSocket_InboundMesh)(nil),
		(*TransportSocket_OutboundMesh)(nil),
		(*TransportSocket_InboundNonMesh)(nil),
		(*TransportSocket_OutboundNonMesh)(nil),
	}
	file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*InboundNonMeshTLS_LeafKey)(nil),
		(*InboundNonMeshTLS_Sds)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_goTypes,
		DependencyIndexes: file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_depIdxs,
		EnumInfos:         file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_enumTypes,
		MessageInfos:      file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_msgTypes,
	}.Build()
	File_pbmesh_v2beta1_pbproxystate_transport_socket_proto = out.File
	file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_rawDesc = nil
	file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_goTypes = nil
	file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_depIdxs = nil
}
