package models
// Malware severity
type WindowsMalwareSeverity int

const (
    // Unknown
    UNKNOWN_WINDOWSMALWARESEVERITY WindowsMalwareSeverity = iota
    // Low
    LOW_WINDOWSMALWARESEVERITY
    // Moderate
    MODERATE_WINDOWSMALWARESEVERITY
    // High
    HIGH_WINDOWSMALWARESEVERITY
    // Severe
    SEVERE_WINDOWSMALWARESEVERITY
)

func (i WindowsMalwareSeverity) String() string {
    return []string{"unknown", "low", "moderate", "high", "severe"}[i]
}
func ParseWindowsMalwareSeverity(v string) (any, error) {
    result := UNKNOWN_WINDOWSMALWARESEVERITY
    switch v {
        case "unknown":
            result = UNKNOWN_WINDOWSMALWARESEVERITY
        case "low":
            result = LOW_WINDOWSMALWARESEVERITY
        case "moderate":
            result = MODERATE_WINDOWSMALWARESEVERITY
        case "high":
            result = HIGH_WINDOWSMALWARESEVERITY
        case "severe":
            result = SEVERE_WINDOWSMALWARESEVERITY
        default:
            return nil, nil
    }
    return &result, nil
}
func SerializeWindowsMalwareSeverity(values []WindowsMalwareSeverity) []string {
    result := make([]string, len(values))
    for i, v := range values {
        result[i] = v.String()
    }
    return result
}
func (i WindowsMalwareSeverity) isMultiValue() bool {
    return false
}
